/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential;

import edu.rit.pj.ParallelTeam;
import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.numerics.math.DoubleMath;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.Utilities;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.MSGroup;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.Molecule;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.RendererCache;
import ffx.potential.bonded.Residue;
import ffx.potential.parameters.ForceField;
import ffx.utilities.StringUtils;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.LineAttributes;
import org.jogamp.java3d.Link;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.RenderingAttributes;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.SharedGroup;
import org.jogamp.java3d.Switch;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.picking.PickTool;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Matrix3d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;

public class MolecularAssembly
extends MSGroup {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MolecularAssembly.class.getName());
    private static final double[] a = new double[3];
    private Character alternateLocation = Character.valueOf(' ');
    private final List<String> headerLines = new ArrayList<String>();
    private final MSNode ions = new MSNode("Ions");
    private final HashMap<String, Molecule> ionHashMap = new HashMap();
    private final MSNode water = new MSNode("Water");
    private final HashMap<String, Molecule> waterHashMap = new HashMap();
    private final MSNode molecules = new MSNode("Hetero Molecules");
    private final HashMap<String, Molecule> moleculeHashMap = new HashMap();
    private final List<BranchGroup> myNewShapes = new ArrayList<BranchGroup>();
    protected ForceField forceField;
    private File file;
    private File archiveFile;
    private ForceFieldEnergy potentialEnergy;
    private CompositeConfiguration properties;
    private Vector3d offset;
    private int cycles = 1;
    private int currentCycle = 1;
    private BranchGroup branchGroup;
    private TransformGroup originToRot;
    private Transform3D originToRotT3D;
    private Vector3d originToRotV3D;
    private TransformGroup rotToCOM;
    private Transform3D rotToCOMT3D;
    private Vector3d rotToCOMV3D;
    private BranchGroup base;
    private Switch switchGroup;
    private Shape3D wire;
    private BranchGroup vrml;
    private TransformGroup vrmlTG;
    private Transform3D vrmlTd;
    private BranchGroup childNodes;
    private Atom[] atomLookUp;
    private LineAttributes lineAttributes;
    private boolean visible = false;
    private FractionalMode fractionalMode = FractionalMode.MOLECULE;
    private double[][] fractionalCoordinates;
    private boolean titrateConformer = false;
    private Atom atomInitial;

    public MolecularAssembly(String name) {
        super(name);
        this.getAtomNode().setName("MacroMolecules");
        this.add(this.molecules);
        this.add(this.ions);
        this.add(this.water);
    }

    public MolecularAssembly(String name, MSNode Polymers) {
        super(name, Polymers);
    }

    public MolecularAssembly(String name, MSNode Polymers, CompositeConfiguration properties) {
        this(name, Polymers);
        this.properties = properties;
    }

    public void setAlternateLocation(Character alternateLocation) {
        this.alternateLocation = alternateLocation;
    }

    public Character getAlternateLocation() {
        return this.alternateLocation;
    }

    @Override
    public void setOccupancy(double occupancy) {
        List<Atom> atoms = this.getAtomList();
        for (Atom atom : atoms) {
            atom.setOccupancy(occupancy);
        }
    }

    public void setOccupancy(double occupancy, Character alternateLocation) {
        List<Atom> atoms = this.getAtomList();
        for (Atom atom : atoms) {
            if (!atom.getAltLoc().equals(alternateLocation)) continue;
            atom.setOccupancy(occupancy);
        }
    }

    public void addHeaderLine(String line) {
        this.headerLines.add(line);
    }

    @Override
    public MSNode addMSNode(MSNode o) {
        List<MSNode> Polymers = this.getAtomNodeList();
        if (o instanceof Atom) {
            Atom atom = (Atom)o;
            if (atom.isModRes()) {
                return this.getResidue(atom, true, Residue.ResidueType.AA);
            }
            if (!atom.isHetero()) {
                String resName;
                switch (resName = atom.getResidueName()) {
                    case "HIS": 
                    case "HIE": 
                    case "HID": 
                    case "ASP": 
                    case "ASH": 
                    case "GLU": 
                    case "GLH": 
                    case "LYS": 
                    case "LYD": {
                        for (Residue residue : this.getResidueList()) {
                            if (residue.getResidueNumber() != atom.getResidueNumber()) continue;
                            for (Atom currentAtom : residue.getAtomList()) {
                                if (atom.getResidueNumber() == currentAtom.getResidueNumber() && atom.getChainID() == currentAtom.getChainID() && atom.getAltLoc() != currentAtom.getAltLoc() && !atom.getResidueName().equals(currentAtom.getResidueName()) && atom.getName().equals(currentAtom.getName())) {
                                    this.titrateConformer = true;
                                    this.atomInitial = currentAtom;
                                    return this.getResidue(atom, true);
                                }
                                this.titrateConformer = false;
                                this.atomInitial = null;
                            }
                        }
                        break;
                    }
                }
                return this.getResidue(atom, true);
            }
            return this.getMolecule(atom, true);
        }
        if (o instanceof Residue) {
            String segID;
            Residue residue = (Residue)o;
            Character chainID = residue.getChainID();
            int index = Polymers.indexOf(new Polymer(chainID, segID = residue.getSegID()));
            if (index != -1) {
                Polymer c = (Polymer)Polymers.get(index);
                this.setFinalized(false);
                return c.addMSNode(residue);
            }
            Polymer newc = new Polymer(chainID, segID);
            this.getAtomNode().add(newc);
            this.setFinalized(false);
            return newc.addMSNode(residue);
        }
        if (o instanceof Polymer) {
            Polymer c = (Polymer)o;
            int index = Polymers.indexOf(c);
            if (index == -1) {
                this.getAtomNode().add(c);
                this.setFinalized(false);
                return c;
            }
            return Polymers.get(index);
        }
        if (o instanceof Molecule) {
            Molecule m = (Molecule)o;
            String key = m.getKey();
            if (m.getAtomNode().getChildCount() == 1) {
                this.ions.add(m);
                if (this.ionHashMap.containsKey(key)) {
                    logger.info(" Ion map already contains " + String.valueOf(m));
                } else {
                    this.ionHashMap.put(m.getKey(), m);
                }
                return m;
            }
            if (Utilities.isWaterOxygen((Atom)m.getAtomNode().getChildAt(0))) {
                this.water.add(m);
                if (this.waterHashMap.containsKey(key)) {
                    logger.info(" Water map already contains " + String.valueOf(m));
                } else {
                    this.waterHashMap.put(m.getKey(), m);
                }
                return m;
            }
            this.molecules.add(m);
            if (this.moleculeHashMap.containsKey(key)) {
                logger.info(" Molecule map already contains " + String.valueOf(m));
            } else {
                this.moleculeHashMap.put(m.getKey(), m);
            }
            return m;
        }
        String message = "Programming error in MolecularAssembly addNode";
        logger.log(Level.SEVERE, message);
        return o;
    }

    public void applyRandomDensity(double ucDensity) {
        if (ucDensity > 0.0) {
            logger.info(String.format("\n Applying random unit cell axes with target density %6.3f (g/cc).", ucDensity));
            Crystal crystal = this.getCrystal();
            if (!crystal.aperiodic()) {
                double mass = this.getMass();
                crystal.randomParameters(ucDensity, mass);
                logger.info(crystal.toString());
                this.potentialEnergy.setCrystal(crystal);
            } else {
                logger.fine(String.format(" Potential %s is an aperiodic system!", this.potentialEnergy));
            }
        }
    }

    public void applyRandomSymOp(double x) {
        Crystal crystal = this.getCrystal().getUnitCell();
        if (crystal.aperiodic() || x < 0.0) {
            return;
        }
        double[] xyz = new double[3];
        List<MSNode> molecules = this.getMolecules();
        int moleculeNum = 1;
        for (MSNode msNode : molecules) {
            SymOp symOp;
            List<Atom> atoms = msNode.getAtomList();
            if (x == 0.0) {
                double[] translation = crystal.getRandomCartTranslation();
                symOp = SymOp.randomSymOpFactory((double[])translation);
            } else {
                symOp = SymOp.randomSymOpFactory((double)x);
            }
            logger.info(String.format("\n Applying random Cartesian SymOp to molecule %d:\n%s", moleculeNum, symOp));
            for (Atom atom : atoms) {
                atom.getXYZ(xyz);
                SymOp.applyCartesianSymOp((double[])xyz, (double[])xyz, (SymOp)symOp);
                atom.setXYZ(xyz);
            }
            ++moleculeNum;
        }
    }

    public void center() {
        double[] center = this.getMultiScaleCenter(false);
        this.offset = new Vector3d(center);
        if (this.vrml != null) {
            this.vrmlTd.set(this.offset);
            this.vrmlTG.setTransform(this.vrmlTd);
        }
        this.offset.negate();
        this.originToRotV3D.set((Tuple3d)this.offset);
        this.originToRotT3D.setTranslation(this.originToRotV3D);
        this.originToRot.setTransform(this.originToRotT3D);
        this.rotToCOMT3D.setIdentity();
        this.rotToCOM.setTransform(this.rotToCOMT3D);
        this.offset.negate();
        this.rotateAbout(this.offset);
        this.originToRotT3D.get(this.offset);
    }

    public void centerAt(double[] d) {
        double[] Rc = new double[]{0.0, 0.0, 0.0};
        double[] c = new double[3];
        int num = this.getAtomList().size();
        ListIterator<Atom> li = this.getAtomList().listIterator();
        while (li.hasNext()) {
            li.next().getXYZ(a);
            Rc[0] = Rc[0] + a[0];
            Rc[1] = Rc[1] + a[1];
            Rc[2] = Rc[2] + a[2];
        }
        int i = 0;
        while (i < 3) {
            int n = i++;
            Rc[n] = Rc[n] / (double)num;
        }
        DoubleMath.sub((double[])d, (double[])Rc, (double[])c);
        li = this.getAtomList().listIterator();
        while (li.hasNext()) {
            li.next().move(c);
        }
    }

    public void centerView(boolean rot, boolean trans) {
        this.originToRot.getTransform(this.originToRotT3D);
        if (rot) {
            Matrix3d m3d = new Matrix3d();
            m3d.setIdentity();
            this.originToRotT3D.setRotation(m3d);
        }
        if (trans) {
            this.originToRotV3D.set((Tuple3d)this.offset);
            this.originToRotT3D.set(this.originToRotV3D);
        }
        this.originToRot.setTransform(this.originToRotT3D);
    }

    public void computeFractionalCoordinates() {
        this.fractionalCount();
        Crystal unitCell = this.getCrystal().getUnitCell();
        double[] com = new double[3];
        switch (this.fractionalMode.ordinal()) {
            case 1: {
                double m;
                double totalMass;
                int iMolecule = 0;
                Polymer[] polymers = this.getChains();
                if (polymers != null && polymers.length > 0) {
                    for (Polymer polymer : polymers) {
                        List<Atom> list = polymer.getAtomList();
                        com[0] = 0.0;
                        com[1] = 0.0;
                        com[2] = 0.0;
                        totalMass = 0.0;
                        for (Atom atom : list) {
                            m = atom.getMass();
                            com[0] = com[0] + atom.getX() * m;
                            com[1] = com[1] + atom.getY() * m;
                            com[2] = com[2] + atom.getZ() * m;
                            totalMass += m;
                        }
                        com[0] = com[0] / totalMass;
                        com[1] = com[1] / totalMass;
                        com[2] = com[2] / totalMass;
                        unitCell.toFractionalCoordinates(com, this.fractionalCoordinates[iMolecule++]);
                    }
                }
                List<MSNode> molecules = this.getMolecules();
                for (MSNode molecule : molecules) {
                    List<Atom> list = molecule.getAtomList();
                    com[0] = 0.0;
                    com[1] = 0.0;
                    com[2] = 0.0;
                    double totalMass2 = 0.0;
                    for (Atom atom : list) {
                        double m2 = atom.getMass();
                        com[0] = com[0] + atom.getX() * m2;
                        com[1] = com[1] + atom.getY() * m2;
                        com[2] = com[2] + atom.getZ() * m2;
                        totalMass2 += m2;
                    }
                    com[0] = com[0] / totalMass2;
                    com[1] = com[1] / totalMass2;
                    com[2] = com[2] / totalMass2;
                    unitCell.toFractionalCoordinates(com, this.fractionalCoordinates[iMolecule++]);
                }
                List<MSNode> water = this.getWater();
                for (MSNode mSNode : water) {
                    List<Atom> list = mSNode.getAtomList();
                    com[0] = 0.0;
                    com[1] = 0.0;
                    com[2] = 0.0;
                    totalMass = 0.0;
                    for (Atom atom : list) {
                        m = atom.getMass();
                        com[0] = com[0] + atom.getX() * m;
                        com[1] = com[1] + atom.getY() * m;
                        com[2] = com[2] + atom.getZ() * m;
                        totalMass += m;
                    }
                    com[0] = com[0] / totalMass;
                    com[1] = com[1] / totalMass;
                    com[2] = com[2] / totalMass;
                    unitCell.toFractionalCoordinates(com, this.fractionalCoordinates[iMolecule++]);
                }
                List<MSNode> ions = this.getIons();
                for (MSNode ion : ions) {
                    List<Atom> list = ion.getAtomList();
                    com[0] = 0.0;
                    com[1] = 0.0;
                    com[2] = 0.0;
                    double totalMass3 = 0.0;
                    for (Atom atom : list) {
                        double m3 = atom.getMass();
                        com[0] = com[0] + atom.getX() * m3;
                        com[1] = com[1] + atom.getY() * m3;
                        com[2] = com[2] + atom.getZ() * m3;
                        totalMass3 += m3;
                    }
                    com[0] = com[0] / totalMass3;
                    com[1] = com[1] / totalMass3;
                    com[2] = com[2] / totalMass3;
                    unitCell.toFractionalCoordinates(com, this.fractionalCoordinates[iMolecule++]);
                }
                break;
            }
            case 2: {
                Atom[] atomArray = this.getAtomArray();
                int nAtoms = atomArray.length;
                for (int i = 0; i < nAtoms; ++i) {
                    atomArray[i].getXYZ(com);
                    unitCell.toFractionalCoordinates(com, this.fractionalCoordinates[i]);
                }
                break;
            }
        }
    }

    public void createBox() {
        int vertices = 8;
        LineArray la = new LineArray(4 * vertices, 15);
        la.setCapability(1);
        la.setCapability(0);
        la.setCapability(3);
        la.setCapability(8);
        la.setCapability(18);
        la.setCapability(17);
        ColoringAttributes cola = new ColoringAttributes(new Color3f(), 3);
        Appearance app = new Appearance();
        this.lineAttributes = new LineAttributes();
        this.lineAttributes.setLineWidth((float)RendererCache.bondwidth);
        this.lineAttributes.setCapability(1);
        this.lineAttributes.setLineAntialiasingEnable(true);
        app.setLineAttributes(this.lineAttributes);
        app.setCapability(16);
        app.setCapability(17);
        RenderingAttributes ra = new RenderingAttributes();
        ra.setAlphaTestValue(0.1f);
        ra.setAlphaTestFunction(6);
        ra.setDepthBufferEnable(true);
        ra.setDepthBufferWriteEnable(true);
        app.setRenderingAttributes(ra);
        app.setColoringAttributes(cola);
        Shape3D wireframe = new Shape3D((Geometry)la, app);
        wireframe.setUserData((Object)this);
        wireframe.setBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 10.0));
        try {
            wireframe.setBoundsAutoCompute(false);
        }
        catch (Exception e) {
            logger.warning(" Exception in setting bounds for wireframe:\n" + String.valueOf(e));
        }
        wireframe.setCapability(12);
        wireframe.setCapability(14);
    }

    public void deleteMolecule(Molecule molecule) {
        Molecule m;
        List<MSNode> list = this.ions.getChildList();
        for (MSNode node : list) {
            m = (Molecule)node;
            if (molecule != m) continue;
            this.ions.remove(m);
            this.ionHashMap.remove(m.getKey());
            return;
        }
        list = this.water.getChildList();
        for (MSNode node : list) {
            m = (Molecule)node;
            if (molecule != m) continue;
            this.water.remove(m);
            this.waterHashMap.remove(m.getKey());
            return;
        }
        list = this.molecules.getChildList();
        for (MSNode node : list) {
            m = (Molecule)node;
            if (molecule != m) continue;
            this.molecules.remove(m);
            this.moleculeHashMap.remove(m.getKey());
            return;
        }
    }

    @Override
    public boolean destroy() {
        try {
            if (this.potentialEnergy == null) {
                this.finishDestruction();
                return true;
            }
            return this.potentialEnergy.destroy();
        }
        catch (Exception ex) {
            logger.warning(String.format(" Exception in destroying a MolecularAssembly: %s", ex));
            logger.info(Utilities.stackTraceToString(ex));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach() {
        MolecularAssembly molecularAssembly = this;
        synchronized (molecularAssembly) {
            if (this.branchGroup != null && this.branchGroup.isLive()) {
                this.branchGroup.detach();
            }
        }
    }

    @Override
    public void finalize(boolean finalizeGroups, ForceField forceField) {
        this.setFinalized(false);
        if (finalizeGroups) {
            Molecule molecule;
            bondTime = 0L;
            angleTime = 0L;
            stretchBendTime = 0L;
            ureyBradleyTime = 0L;
            outOfPlaneBendTime = 0L;
            torsionTime = 0L;
            piOrbitalTorsionTime = 0L;
            torsionTorsionTime = 0L;
            List<MSNode> Polymers = this.getAtomNodeList();
            for (MSNode msNode : Polymers) {
                MSGroup group = (MSGroup)msNode;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" Finalizing bonded terms for polymer " + group.toString());
                }
                try {
                    group.finalize(true, forceField);
                }
                catch (Exception e) {
                    String message = "Fatal exception finalizing " + group.toString();
                    logger.log(Level.SEVERE, message, e);
                    System.exit(-1);
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                Runtime runtime = Runtime.getRuntime();
                long occupiedMemory = runtime.totalMemory() - runtime.freeMemory();
                long MB = 0x100000L;
                logger.fine("\n In-Use Memory   (Mb): " + occupiedMemory / MB + "\n Free Memory     (Mb): " + runtime.freeMemory() / MB + "\n Total Memory    (Mb): " + runtime.totalMemory() / MB);
            }
            for (MSNode m : this.molecules.getChildList()) {
                molecule = (Molecule)m;
                molecule.finalize(true, forceField);
            }
            for (MSNode m : this.water.getChildList()) {
                molecule = (Molecule)m;
                molecule.finalize(true, forceField);
            }
            for (MSNode m : this.ions.getChildList()) {
                molecule = (Molecule)m;
                molecule.finalize(true, forceField);
            }
            if (logger.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder("\n Time to create bonded energy terms\n\n");
                sb.append(String.format(" Bond Streching     %10.3f\n", (double)bondTime * 1.0E-9));
                sb.append(String.format(" Angle Bending      %10.3f\n", (double)angleTime * 1.0E-9));
                sb.append(String.format(" Stretch-Bend       %10.3f\n", (double)stretchBendTime * 1.0E-9));
                sb.append(String.format(" Urey-Bradley       %10.3f\n", (double)ureyBradleyTime * 1.0E-9));
                sb.append(String.format(" Out-of-Plane Bend  %10.3f\n", (double)outOfPlaneBendTime * 1.0E-9));
                sb.append(String.format(" Torsionanl Angle   %10.3f\n", (double)torsionTime * 1.0E-9));
                sb.append(String.format(" Pi-Orbital Torsion %10.3f\n", (double)piOrbitalTorsionTime * 1.0E-9));
                sb.append(String.format(" Torsion-Torsion    %10.3f\n", (double)torsionTorsionTime * 1.0E-9));
                logger.fine(sb.toString());
            }
        }
        if (!GraphicsEnvironment.isHeadless()) {
            this.createScene(!finalizeGroups);
            this.center();
        }
        this.removeLeaves();
        boolean heavyHydrogen = forceField.getBoolean("HEAVY_HYDROGENS", false);
        heavyHydrogen = forceField.getBoolean("HEAVY_HYDROGEN", heavyHydrogen);
        if (heavyHydrogen) {
            this.applyHeavyHydrogen();
        }
        this.setFinalized(true);
    }

    public Atom findAtom(Atom atom) {
        return this.findAtom(atom, false);
    }

    public Atom findAtom(Atom atom, boolean matchDeuterium) {
        String segID;
        if (!atom.isHetero() || atom.isModRes()) {
            Residue res;
            Polymer polymer = this.getPolymer(atom.getChainID(), atom.getSegID(), false);
            if (polymer != null && (res = polymer.getResidue(atom.getResidueName(), atom.getResidueNumber(), false)) != null) {
                MSNode node = res.getAtomNode();
                Atom foundAtom = (Atom)node.contains(atom);
                if (foundAtom == null && matchDeuterium && atom.getAtomicNumber() == 1) {
                    String atomName = atom.getName().toUpperCase();
                    if (atomName.startsWith("H")) {
                        atom.setName(atomName.replaceFirst("H", "D"));
                        foundAtom = (Atom)node.contains(atom);
                        atom.setName(atomName);
                    } else if (atomName.startsWith("D")) {
                        atom.setName(atomName.replaceFirst("D", "H"));
                        foundAtom = (Atom)node.contains(atom);
                        atom.setName(atomName);
                    }
                }
                return foundAtom;
            }
            return null;
        }
        String resName = atom.getResidueName();
        int resNum = atom.getResidueNumber();
        String key = resNum + resName + (segID = atom.getSegID());
        Molecule m = this.ionHashMap.get(key);
        if (m == null && (m = this.waterHashMap.get(key)) == null && (m = this.moleculeHashMap.get(key)) == null) {
            return null;
        }
        return (Atom)m.contains(atom);
    }

    public int fractionalCount() {
        int count = 0;
        switch (this.fractionalMode.ordinal()) {
            case 1: {
                List<MSNode> ions;
                List<MSNode> water;
                List<MSNode> molecules;
                Polymer[] polymers = this.getChains();
                if (polymers != null && polymers.length > 0) {
                    count += polymers.length;
                }
                if ((molecules = this.getMolecules()) != null) {
                    count += molecules.size();
                }
                if ((water = this.getWater()) != null) {
                    count += water.size();
                }
                if ((ions = this.getIons()) == null) break;
                count += ions.size();
                break;
            }
            case 2: {
                count = this.getAtomArray().length;
                break;
            }
            case 0: {
                count = 0;
            }
        }
        if (this.fractionalCoordinates == null || this.fractionalCoordinates.length != count) {
            this.fractionalCoordinates = new double[count][3];
        }
        return count;
    }

    public Atom[] getActiveAtomArray() {
        List<Atom> atoms = this.getAtomList();
        ArrayList<Atom> activeAtoms = new ArrayList<Atom>();
        for (Atom a : atoms) {
            if (!a.isActive()) continue;
            activeAtoms.add(a);
        }
        Object[] atomArray = activeAtoms.toArray(new Atom[0]);
        Arrays.sort(atomArray);
        return atomArray;
    }

    public List<MSNode> getAllBondedEntities() {
        HashSet<MSNode> allBondedNodes = new HashSet<MSNode>(this.getIons());
        allBondedNodes.addAll(this.getMolecules());
        allBondedNodes.addAll(this.getWater());
        Polymer[] polys = this.getChains();
        if (polys != null && polys.length > 0) {
            allBondedNodes.addAll(Arrays.asList(polys));
        }
        return new ArrayList<MSNode>(allBondedNodes);
    }

    public Atom[] getAtomArray() {
        List<Atom> atoms = this.getAtomList();
        Atom[] atomArray = atoms.toArray(new Atom[0]);
        for (int i = 0; i < atoms.size(); ++i) {
            atomArray[i].setXyzIndex(i + 1);
        }
        return atomArray;
    }

    public Atom getAtomFromWireVertex(int i) {
        if (this.atomLookUp != null && this.atomLookUp.length > i) {
            return this.atomLookUp[i];
        }
        return null;
    }

    public List<Atom> getBackBoneAtoms() {
        ArrayList<Atom> backbone = new ArrayList<Atom>();
        List<Residue> residues = this.getResidueList();
        for (Residue residue : residues) {
            backbone.addAll(residue.getBackboneAtoms());
        }
        return backbone;
    }

    public BranchGroup getBranchGroup() {
        return this.branchGroup;
    }

    public Polymer getChain(String name) {
        for (MSNode node : this.getAtomNodeList()) {
            if (!(node instanceof Polymer)) continue;
            String chainName = node.getName();
            if (chainName.equalsIgnoreCase(name)) {
                return (Polymer)node;
            }
            if (!name.contentEquals(" ")) continue;
            return (Polymer)node;
        }
        return null;
    }

    public String[] getChainNames() {
        ArrayList<String> temp = new ArrayList<String>();
        for (MSNode node : this.getAtomNodeList()) {
            if (!(node instanceof Polymer)) continue;
            temp.add(node.getName());
        }
        if (temp.isEmpty()) {
            return null;
        }
        String[] names = new String[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            names[i] = (String)temp.get(i);
        }
        return names;
    }

    public Polymer[] getChains() {
        ArrayList<Polymer> polymers = new ArrayList<Polymer>();
        for (MSNode node : this.getAtomNodeList()) {
            if (!(node instanceof Polymer)) continue;
            polymers.add((Polymer)node);
        }
        if (polymers.isEmpty()) {
            return null;
        }
        return polymers.toArray(new Polymer[0]);
    }

    public double getCharge(boolean alwaysLog) {
        double totalCharge = 0.0;
        for (MSNode node : this.getNodeList()) {
            double charge = 0.0;
            boolean isNonstandard = false;
            for (Atom atom : node.getAtomList()) {
                charge += atom.getCharge(this.forceField);
                if (!atom.isModRes()) continue;
                isNonstandard = true;
            }
            if ((alwaysLog || isNonstandard) && Math.abs((double)Math.round(charge) - charge) > 1.0E-5) {
                logger.warning(String.format(" Node %s has non-unitary charge %12.8f", node, charge));
            }
            totalCharge += charge;
        }
        return totalCharge;
    }

    public boolean hasDeuterium() {
        Atom[] atoms;
        for (Atom atom : atoms = this.getAtomArray()) {
            if (!atom.isDeuterium()) continue;
            return true;
        }
        return false;
    }

    public Crystal getCrystal() {
        if (this.potentialEnergy == null) {
            return null;
        }
        return this.potentialEnergy.getCrystal();
    }

    public void setCrystal(Crystal crystal) {
        if (this.potentialEnergy != null) {
            this.potentialEnergy.setCrystal(crystal);
        }
    }

    public int getCurrentCycle() {
        return this.currentCycle;
    }

    public void setCurrentCycle(int c) {
        if (c <= this.cycles && c > 0) {
            this.currentCycle = c;
            for (Atom atom : this.getAtomList()) {
                atom.setCurrentCycle(this.currentCycle);
            }
        }
    }

    public int getCycles() {
        return this.cycles;
    }

    public void setCycles(int c) {
        this.cycles = c;
    }

    @Override
    public double getExtent() {
        double[] Rc = new double[]{0.0, 0.0, 0.0};
        int num = this.getAtomList().size();
        for (Atom atom : this.getAtomList()) {
            atom.getXYZ(a);
            Rc[0] = Rc[0] + a[0];
            Rc[1] = Rc[1] + a[1];
            Rc[2] = Rc[2] + a[2];
        }
        int i = 0;
        while (i < 3) {
            int n = i++;
            Rc[n] = Rc[n] / (double)num;
        }
        double d = 0.0;
        double[] xyz = new double[3];
        for (Atom atom : this.getAtomList()) {
            atom.getXYZ(xyz);
            DoubleMath.sub((double[])xyz, (double[])Rc, (double[])xyz);
            double r = DoubleMath.length((double[])xyz);
            if (!(d < r)) continue;
            d = r;
        }
        return d;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (file == null) {
            return;
        }
        this.file = file;
    }

    public File getArchiveFile() {
        return this.archiveFile;
    }

    public void setArchiveFile(File archiveFile) {
        if (archiveFile == null) {
            return;
        }
        this.archiveFile = archiveFile;
    }

    public ForceField getForceField() {
        return this.forceField;
    }

    public void setForceField(ForceField forceField) {
        this.forceField = forceField;
    }

    public FractionalMode getFractionalMode() {
        return this.fractionalMode;
    }

    public void setFractionalMode(FractionalMode mode) {
        this.fractionalMode = mode;
    }

    public String[] getHeaderLines() {
        String[] ret = new String[this.headerLines.size()];
        this.headerLines.toArray(ret);
        return ret;
    }

    public List<MSNode> getIons() {
        return this.ions.getChildList();
    }

    public double getMass() {
        double mass = 0.0;
        for (Atom atom : this.getAtomArray()) {
            mass += atom.getMass();
        }
        return mass;
    }

    public boolean[] getNeuralNetworkIdentity() {
        Atom[] atomArray = this.getAtomArray();
        int nAtoms = atomArray.length;
        boolean[] neuralNetwork = new boolean[nAtoms];
        for (int i = 0; i < nAtoms; ++i) {
            neuralNetwork[i] = atomArray[i].isNeuralNetwork();
        }
        return neuralNetwork;
    }

    public int[] getMoleculeNumbers() {
        int[] moleculeNumber = new int[this.getAtomList().size()];
        int current = 0;
        Polymer[] polymers = this.getChains();
        if (polymers != null) {
            for (Polymer polymer : polymers) {
                List<Atom> atomList = polymer.getAtomList();
                for (Atom atom : atomList) {
                    moleculeNumber[atom.getXyzIndex() - 1] = current;
                    atom.setMoleculeNumber(current);
                }
                ++current;
            }
        }
        for (MSNode molecule : this.molecules.getChildList()) {
            List<Atom> atomList = molecule.getAtomList();
            for (Atom atom : atomList) {
                moleculeNumber[atom.getXyzIndex() - 1] = current;
                atom.setMoleculeNumber(current);
            }
            ++current;
        }
        for (MSNode wat : this.water.getChildList()) {
            List<Atom> atomList = wat.getAtomList();
            for (Atom atom : atomList) {
                moleculeNumber[atom.getXyzIndex() - 1] = current;
                atom.setMoleculeNumber(current);
            }
            ++current;
        }
        for (MSNode ion : this.ions.getChildList()) {
            List<Atom> atomList = ion.getAtomList();
            for (Atom atom : atomList) {
                moleculeNumber[atom.getXyzIndex() - 1] = current;
                atom.setMoleculeNumber(current);
            }
            ++current;
        }
        return moleculeNumber;
    }

    public List<MSNode> getMolecules() {
        return this.molecules.getChildList();
    }

    public Molecule[] getMoleculeArray() {
        Molecule[] m = new Molecule[this.molecules.getChildCount()];
        int i = 0;
        for (MSNode msNode : this.molecules.getChildList()) {
            m[i++] = (Molecule)msNode;
        }
        return m;
    }

    public void setChainIDAndRenumberMolecules(Character chainID) {
        int resID = 1;
        Polymer polymer = this.getPolymer(chainID, chainID.toString(), false);
        if (polymer != null) {
            List<Residue> residues = polymer.getResidues();
            for (Residue residue : residues) {
                int resID2 = residue.getResidueNumber();
                if (resID2 < resID) continue;
                resID = resID2 + 1;
            }
        }
        for (MSNode m : this.getMolecules()) {
            Molecule molecule = (Molecule)m;
            molecule.setChainID(chainID);
            molecule.setResidueNum(resID++);
        }
        for (MSNode ion : this.getIons()) {
            Molecule m = (Molecule)ion;
            m.setChainID(chainID);
            m.setResidueNum(resID++);
        }
        for (MSNode wat : this.getWater()) {
            Molecule water = (Molecule)wat;
            water.setChainID(chainID);
            water.setResidueNum(resID++);
        }
    }

    public List<MSNode> getNodeList() {
        return this.getNodeList(false);
    }

    public List<MSNode> getNodeList(boolean ignorePolymers) {
        Polymer[] polymers;
        ArrayList<MSNode> nodeList = new ArrayList<MSNode>();
        if (!ignorePolymers && (polymers = this.getChains()) != null) {
            for (Polymer polymer : polymers) {
                nodeList.addAll(polymer.getResidues());
            }
        }
        nodeList.addAll(this.ions.getChildList());
        nodeList.addAll(this.water.getChildList());
        nodeList.addAll(this.molecules.getChildList());
        return nodeList;
    }

    public Vector3d getOffset() {
        if (this.offset == null) {
            this.offset = new Vector3d(0.0, 0.0, 0.0);
        }
        return this.offset;
    }

    public void setOffset(Vector3d o) {
        this.offset = o;
    }

    public TransformGroup getOriginToRot() {
        return this.originToRot;
    }

    public ParallelTeam getParallelTeam() {
        if (this.potentialEnergy != null) {
            return this.potentialEnergy.getParallelTeam();
        }
        return null;
    }

    public Polymer getPolymer(Character chainID, String segID, boolean create) {
        for (MSNode node : this.getAtomNodeList()) {
            Polymer polymer;
            if (!(node instanceof Polymer) || !(polymer = (Polymer)node).getName().equals(segID) || !polymer.getChainID().equals(chainID)) continue;
            return (Polymer)node;
        }
        if (create) {
            Polymer polymer = new Polymer(chainID, segID, true);
            this.addMSNode(polymer);
            return polymer;
        }
        return null;
    }

    public ForceFieldEnergy getPotentialEnergy() {
        return this.potentialEnergy;
    }

    public CompositeConfiguration getProperties() {
        return this.properties == null ? this.forceField.getProperties() : this.properties;
    }

    public List<Residue> getResidueList() {
        ArrayList<Residue> residues = new ArrayList<Residue>();
        ListIterator<MSNode> li = this.getAtomNodeList().listIterator();
        while (li.hasNext()) {
            MSNode o = li.next();
            if (!(o instanceof Polymer)) continue;
            Polymer c = (Polymer)o;
            ListIterator<MSNode> lj = c.getAtomNodeList().listIterator();
            while (lj.hasNext()) {
                o = lj.next();
                if (!(o instanceof Residue)) continue;
                residues.add((Residue)o);
            }
        }
        return residues;
    }

    public TransformGroup getTransformGroup() {
        return this.originToRot;
    }

    public List<MSNode> getWater() {
        return this.water.getChildList();
    }

    public Node getWireFrame() {
        return this.wire;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public BranchGroup loadVRML() {
        return null;
    }

    public void moveAllIntoUnitCell() {
        this.moveIntoUnitCell(this.getChains());
        this.moveIntoUnitCell(this.getWater());
        this.moveIntoUnitCell(this.getIons());
        this.moveIntoUnitCell(this.getMolecules());
    }

    public void moveCenter(double[] d) {
        for (Atom atom : this.getAtomList()) {
            atom.move(d);
        }
    }

    public void moveToFractionalCoordinates() {
        if (this.fractionalCoordinates == null) {
            return;
        }
        Crystal unitCell = this.getCrystal().getUnitCell();
        double[] com = new double[3];
        switch (this.fractionalMode.ordinal()) {
            case 1: {
                double totalMass;
                int iMolecule = 0;
                Polymer[] polymers = this.getChains();
                if (polymers != null && polymers.length > 0) {
                    for (Polymer polymer : polymers) {
                        List<Atom> list = polymer.getAtomList();
                        totalMass = 0.9;
                        com[0] = 0.0;
                        com[1] = 0.0;
                        com[2] = 0.0;
                        for (Atom atom : list) {
                            double m = atom.getMass();
                            com[0] = com[0] + atom.getX() * m;
                            com[1] = com[1] + atom.getY() * m;
                            com[2] = com[2] + atom.getZ() * m;
                            totalMass += m;
                        }
                        com[0] = com[0] / totalMass;
                        com[1] = com[1] / totalMass;
                        com[2] = com[2] / totalMass;
                        unitCell.toFractionalCoordinates(com, com);
                        double[] dArray = this.fractionalCoordinates[iMolecule++];
                        com[0] = dArray[0] - com[0];
                        com[1] = dArray[1] - com[1];
                        com[2] = dArray[2] - com[2];
                        unitCell.toCartesianCoordinates(com, com);
                        for (Atom atom3 : list) {
                            atom3.move(com);
                        }
                    }
                }
                List<MSNode> molecules = this.getMolecules();
                for (MSNode molecule : molecules) {
                    List<Atom> list = molecule.getAtomList();
                    com[0] = 0.0;
                    com[1] = 0.0;
                    com[2] = 0.0;
                    double totalMass2 = 0.0;
                    for (Atom atom : list) {
                        double d = atom.getMass();
                        com[0] = com[0] + atom.getX() * d;
                        com[1] = com[1] + atom.getY() * d;
                        com[2] = com[2] + atom.getZ() * d;
                        totalMass2 += d;
                    }
                    com[0] = com[0] / totalMass2;
                    com[1] = com[1] / totalMass2;
                    com[2] = com[2] / totalMass2;
                    unitCell.toFractionalCoordinates(com, com);
                    double[] frac2 = this.fractionalCoordinates[iMolecule++];
                    com[0] = frac2[0] - com[0];
                    com[1] = frac2[1] - com[1];
                    com[2] = frac2[2] - com[2];
                    unitCell.toCartesianCoordinates(com, com);
                    for (Atom atom : list) {
                        atom.move(com);
                    }
                }
                List<MSNode> water = this.getWater();
                for (MSNode mSNode : water) {
                    List<Atom> list = mSNode.getAtomList();
                    com[0] = 0.0;
                    com[1] = 0.0;
                    com[2] = 0.0;
                    totalMass = 0.0;
                    for (Atom atom : list) {
                        double m = atom.getMass();
                        com[0] = com[0] + atom.getX() * m;
                        com[1] = com[1] + atom.getY() * m;
                        com[2] = com[2] + atom.getZ() * m;
                        totalMass += m;
                    }
                    com[0] = com[0] / totalMass;
                    com[1] = com[1] / totalMass;
                    com[2] = com[2] / totalMass;
                    unitCell.toFractionalCoordinates(com, com);
                    double[] dArray = this.fractionalCoordinates[iMolecule++];
                    com[0] = dArray[0] - com[0];
                    com[1] = dArray[1] - com[1];
                    com[2] = dArray[2] - com[2];
                    unitCell.toCartesianCoordinates(com, com);
                    double d = DoubleMath.length((double[])com);
                    if (d > 1.0) {
                        int i = iMolecule - 1;
                        logger.info(String.format(" %d R: %16.8f", i, d));
                        logger.info(String.format(" %d FRAC %16.8f %16.8f %16.8f", i, dArray[0], dArray[1], dArray[2]));
                        logger.info(String.format(" %d COM  %16.8f %16.8f %16.8f", i, com[0], com[1], com[2]));
                    }
                    for (Atom atom : list) {
                        atom.move(com);
                    }
                }
                List<MSNode> ions = this.getIons();
                for (MSNode ion : ions) {
                    List<Atom> list = ion.getAtomList();
                    com[0] = 0.0;
                    com[1] = 0.0;
                    com[2] = 0.0;
                    double totalMass3 = 0.0;
                    for (Atom atom : list) {
                        double m = atom.getMass();
                        com[0] = com[0] + atom.getX() * m;
                        com[1] = com[1] + atom.getY() * m;
                        com[2] = com[2] + atom.getZ() * m;
                        totalMass3 += m;
                    }
                    com[0] = com[0] / totalMass3;
                    com[1] = com[1] / totalMass3;
                    com[2] = com[2] / totalMass3;
                    unitCell.toFractionalCoordinates(com, com);
                    double[] dArray = this.fractionalCoordinates[iMolecule++];
                    com[0] = dArray[0] - com[0];
                    com[1] = dArray[1] - com[1];
                    com[2] = dArray[2] - com[2];
                    unitCell.toCartesianCoordinates(com, com);
                    for (Atom atom : list) {
                        atom.move(com);
                    }
                }
                break;
            }
            case 2: {
                Atom[] atomArray = this.getAtomArray();
                int nAtoms = atomArray.length;
                for (int i = 0; i < nAtoms; ++i) {
                    unitCell.toCartesianCoordinates(this.fractionalCoordinates[i], com);
                    atomArray[i].moveTo(com);
                }
                break;
            }
        }
    }

    public void rotateAbout(Vector3d v) {
        Vector3d newRotPoint = new Vector3d(v);
        this.originToRot.getTransform(this.originToRotT3D);
        this.originToRotT3D.get(this.originToRotV3D);
        this.originToRotT3D.setTranslation(new Vector3d(0.0, 0.0, 0.0));
        this.rotToCOM.getTransform(this.rotToCOMT3D);
        this.rotToCOMT3D.get(this.rotToCOMV3D);
        newRotPoint.add((Tuple3d)this.rotToCOMV3D);
        this.originToRotT3D.transform(newRotPoint);
        newRotPoint.add((Tuple3d)this.originToRotV3D);
        this.originToRotT3D.setTranslation(newRotPoint);
        this.rotToCOMV3D.set((Tuple3d)v);
        this.rotToCOMV3D.negate();
        this.rotToCOMT3D.setTranslation(this.rotToCOMV3D);
        this.originToRot.setTransform(this.originToRotT3D);
        this.rotToCOM.setTransform(this.rotToCOMT3D);
    }

    public void sceneGraphChange(List<BranchGroup> newShapes) {
        if (newShapes == null) {
            newShapes = this.myNewShapes;
        }
        if (newShapes.isEmpty()) {
            return;
        }
        boolean reCompile = false;
        ListIterator<BranchGroup> li = newShapes.listIterator();
        while (li.hasNext()) {
            BranchGroup group = li.next();
            li.remove();
            if (group.getUserData() != null) {
                logger.info(String.format("%s %s", group, group.getUserData().toString()));
                continue;
            }
            group.setUserData((Object)this);
            if (!reCompile) {
                if (this.childNodes.isLive()) {
                    this.childNodes.detach();
                }
                reCompile = true;
            }
            this.childNodes.addChild((Node)group);
        }
        if (reCompile) {
            this.childNodes.compile();
            this.base.addChild((Node)this.childNodes);
        }
    }

    @Override
    public void setColor(RendererCache.ColorModel newColorModel, Color3f color, Material mat) {
        for (MSNode msNode : this.getAtomNodeList()) {
            MSGroup group = (MSGroup)msNode;
            group.setColor(newColorModel, color, mat);
        }
        for (MSNode m : this.molecules.getChildList()) {
            m.setColor(newColorModel, color, mat);
        }
        for (MSNode m : this.water.getChildList()) {
            m.setColor(newColorModel, color, mat);
        }
        for (MSNode m : this.ions.getChildList()) {
            m.setColor(newColorModel, color, mat);
        }
    }

    public void setPotential(ForceFieldEnergy potentialEnergy) {
        this.potentialEnergy = potentialEnergy;
    }

    @Override
    public void setView(RendererCache.ViewModel newViewModel, List<BranchGroup> newShapes) {
        if (newViewModel == RendererCache.ViewModel.DESTROY) {
            if (this.switchGroup != null) {
                this.switchGroup.setWhichChild(-1);
            }
            this.visible = false;
        } else if (newViewModel == RendererCache.ViewModel.SHOWVRML) {
            this.switchGroup.setWhichChild(-2);
        } else if (newViewModel == RendererCache.ViewModel.HIDEVRML) {
            this.switchGroup.setWhichChild(0);
        } else {
            this.setWireWidth(RendererCache.bondwidth);
            if (newViewModel == RendererCache.ViewModel.DETAIL && this.childNodes.isLive()) {
                this.childNodes.detach();
            }
            super.setView(newViewModel, this.myNewShapes);
            List<Molecule> moleculeList = this.getList(Molecule.class, new ArrayList());
            for (Molecule molecule : moleculeList) {
                molecule.setView(newViewModel, this.myNewShapes);
            }
            for (MSNode mSNode : this.molecules.getChildList()) {
                mSNode.setView(newViewModel, this.myNewShapes);
            }
            for (MSNode mSNode : this.water.getChildList()) {
                mSNode.setView(newViewModel, this.myNewShapes);
            }
            for (MSNode mSNode : this.ions.getChildList()) {
                mSNode.setView(newViewModel, this.myNewShapes);
            }
            if (newViewModel == RendererCache.ViewModel.INVISIBLE) {
                this.switchGroup.setWhichChild(0);
            }
            if (newViewModel == RendererCache.ViewModel.DETAIL) {
                this.childNodes.compile();
                this.base.addChild((Node)this.childNodes);
            }
        }
    }

    public void setWireWidth(float f) {
        if (this.wire == null) {
            return;
        }
        this.lineAttributes.setLineWidth(f);
    }

    private BranchGroup createScene(boolean zero) {
        this.originToRotT3D = new Transform3D();
        this.originToRotV3D = new Vector3d();
        this.originToRot = new TransformGroup(this.originToRotT3D);
        this.branchGroup = new BranchGroup();
        this.rotToCOM = new TransformGroup();
        this.rotToCOMT3D = new Transform3D();
        this.rotToCOMV3D = new Vector3d();
        this.branchGroup.setCapability(17);
        this.originToRot.setCapability(18);
        this.originToRot.setCapability(17);
        this.originToRot.setCapability(1);
        this.rotToCOM.setCapability(17);
        this.rotToCOM.setCapability(18);
        if (zero) {
            this.originToRotV3D.set(0.0, 0.0, 0.0);
            this.originToRotT3D.set(this.originToRotV3D);
            this.originToRot.setTransform(this.originToRotT3D);
        }
        this.wire = this.renderWire();
        this.switchGroup = new Switch(-1);
        this.switchGroup.setCapability(18);
        this.base = new BranchGroup();
        this.base.setCapability(14);
        this.base.setCapability(13);
        this.childNodes = new BranchGroup();
        this.childNodes.setCapability(17);
        this.childNodes.setCapability(14);
        this.childNodes.setCapability(13);
        this.switchGroup.addChild((Node)this.base);
        if (this.wire != null) {
            this.base.addChild((Node)this.wire);
        }
        this.vrml = this.loadVRML();
        if (this.vrml != null) {
            this.vrmlTG = new TransformGroup();
            this.vrmlTd = new Transform3D();
            this.vrmlTG.setTransform(this.vrmlTd);
            this.vrmlTG.setCapability(18);
            this.vrmlTG.addChild((Node)this.vrml);
            this.switchGroup.addChild((Node)this.vrmlTG);
            this.setView(RendererCache.ViewModel.INVISIBLE, null);
        }
        this.switchGroup.setWhichChild(-2);
        this.rotToCOM.addChild((Node)this.switchGroup);
        this.originToRot.addChild((Node)this.rotToCOM);
        this.branchGroup.addChild((Node)this.originToRot);
        this.branchGroup.compile();
        return this.branchGroup;
    }

    void finishDestruction() {
        this.detach();
        super.destroy();
    }

    private void applyHeavyHydrogen() {
        logger.info(" Setting Hydrogen Mass to 3 AMU");
        List<Bond> bonds = this.getBondList();
        for (Bond bond : bonds) {
            Atom a1 = bond.getAtom(0);
            Atom a2 = bond.getAtom(1);
            if (a1.isHydrogen() && a2.isHeavy()) {
                double hydrogenMass = a1.getMass();
                double heavyAtomMass = a2.getMass();
                if (!(hydrogenMass < 1.1)) continue;
                a2.setMass(heavyAtomMass - 2.0 * hydrogenMass);
                a1.setMass(3.0 * hydrogenMass);
                continue;
            }
            if (!a1.isHeavy() || !a2.isHydrogen()) continue;
            double heavyAtomMass = a1.getMass();
            double hydrogenMass = a2.getMass();
            if (!(hydrogenMass < 1.1)) continue;
            a1.setMass(heavyAtomMass - 2.0 * hydrogenMass);
            a2.setMass(3.0 * hydrogenMass);
        }
    }

    private Atom getResidue(Atom atom, boolean create) {
        return this.getResidue(atom, create, Residue.ResidueType.UNK);
    }

    private Atom getResidue(Atom atom, boolean create, Residue.ResidueType defaultRT) {
        Residue res;
        Character chainID = atom.getChainID();
        String resName = atom.getResidueName();
        int resNum = atom.getResidueNumber();
        String segID = atom.getSegID();
        Polymer polymer = this.getPolymer(chainID, segID, create);
        if (polymer == null) {
            return null;
        }
        if (this.titrateConformer) {
            res = polymer.getResidue(this.atomInitial.getResidueName(), this.atomInitial.getResidueNumber(), create, defaultRT);
            res.setName(atom.getResidueName());
        } else {
            res = polymer.getResidue(resName, resNum, create, defaultRT);
        }
        if (create && res != null) {
            res.setTitrateConformers(this.titrateConformer);
            if (this.titrateConformer) {
                res.setAtomInitial(this.atomInitial);
            }
            return (Atom)res.addMSNode(atom);
        }
        return null;
    }

    private Atom getMolecule(Atom atom, boolean create) {
        String resName = atom.getResidueName();
        int resNum = atom.getResidueNumber();
        Character chainID = atom.getChainID();
        String segID = atom.getSegID();
        String key = resNum + resName + segID;
        Molecule m = this.ionHashMap.get(key);
        if (m == null && (m = this.waterHashMap.get(key)) == null) {
            m = this.moleculeHashMap.get(key);
        }
        if (m != null) {
            return (Atom)m.addMSNode(atom);
        }
        if (create) {
            boolean isWater = false;
            boolean isIon = false;
            if (StringUtils.looksLikeWater((String)resName)) {
                if (!resName.equalsIgnoreCase("DOD")) {
                    resName = "HOH";
                }
                isWater = true;
            } else if (StringUtils.looksLikeIon((String)resName)) {
                resName = StringUtils.tryParseIon((String)resName);
                isIon = true;
            }
            atom.setResName(resName);
            m = new Molecule(resName, resNum, chainID, segID);
            m.addMSNode(atom);
            if (resName == null) {
                logger.warning(String.format(" Attempting to create a molecule %s with a null name on atom %s! Defaulting to creating a generic Molecule.", m, atom));
                this.molecules.add(m);
                this.moleculeHashMap.put(key, m);
            } else if (isWater) {
                this.water.add(m);
                this.waterHashMap.put(key, m);
            } else if (isIon) {
                this.ions.add(m);
                this.ionHashMap.put(key, m);
            } else {
                this.molecules.add(m);
                this.moleculeHashMap.put(key, m);
            }
            return atom;
        }
        return null;
    }

    private void recurseVRML(Node node) {
        block5: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                if (!(node instanceof Shape3D)) break block4;
                                Shape3D s3d = (Shape3D)node;
                                PickTool.setCapabilities((Node)s3d, (int)4098);
                                break block5;
                            }
                            if (!(node instanceof SharedGroup)) break block6;
                            SharedGroup sg = (SharedGroup)node;
                            Iterator e = sg.getAllChildren();
                            while (e.hasNext()) {
                                this.recurseVRML((Node)e.next());
                            }
                            break block5;
                        }
                        if (!(node instanceof BranchGroup)) break block7;
                        BranchGroup bg = (BranchGroup)node;
                        Iterator e = bg.getAllChildren();
                        while (e.hasNext()) {
                            this.recurseVRML((Node)e.next());
                        }
                        break block5;
                    }
                    if (!(node instanceof TransformGroup)) break block8;
                    TransformGroup vrmlTG1 = (TransformGroup)node;
                    Iterator e = vrmlTG1.getAllChildren();
                    while (e.hasNext()) {
                        node = (Node)e.next();
                        this.recurseVRML(node);
                    }
                    break block5;
                }
                if (!(node instanceof Link)) break block9;
                Link link = (Link)node;
                this.recurseVRML((Node)link.getSharedGroup());
                break block5;
            }
            if (!(node instanceof Group)) break block5;
            Group group = (Group)node;
            Iterator e = group.getAllChildren();
            while (e.hasNext()) {
                this.recurseVRML((Node)e.next());
            }
        }
    }

    @Override
    protected void removeLeaves() {
        super.removeLeaves();
        MSNode macroNode = this.getAtomNode();
        if (macroNode != null) {
            if (macroNode.getChildCount() > 0) {
                this.getAtomNode().setName("Macromolecules (" + macroNode.getChildCount() + ")");
            } else if (macroNode.getParent() == this) {
                this.removeChild(macroNode);
            }
        }
        if (this.molecules.getChildCount() == 0) {
            this.removeChild(this.molecules);
        } else {
            this.molecules.setName("Hetero Molecules (" + this.molecules.getChildCount() + ")");
        }
        if (this.ions.getChildCount() == 0) {
            this.removeChild(this.ions);
        } else {
            this.ions.setName("Ions (" + this.ions.getChildCount() + ")");
        }
        if (this.water.getChildCount() == 0) {
            this.removeChild(this.water);
        } else {
            this.water.setName("Water (" + this.water.getChildCount() + ")");
        }
    }

    private Shape3D renderWire() {
        List<Bond> bonds = this.getBondList();
        int numbonds = bonds.size();
        if (numbonds < 1) {
            return null;
        }
        Vector3d bondmidpoint = new Vector3d();
        double[] mid = new double[]{0.0, 0.0, 0.0};
        Vector3d v1 = new Vector3d();
        Vector3d v2 = new Vector3d();
        float[] a1 = new float[]{0.0f, 0.0f, 0.0f};
        float[] a2 = new float[]{0.0f, 0.0f, 0.0f};
        float[] col = new float[4];
        LineArray la = new LineArray(4 * numbonds, 15);
        la.setCapability(1);
        la.setCapability(0);
        la.setCapability(3);
        la.setCapability(8);
        la.setCapability(18);
        la.setCapability(17);
        this.atomLookUp = new Atom[4 * numbonds];
        int i = 0;
        col[3] = 0.9f;
        for (Bond bond : bonds) {
            bond.setWire(la, i);
            Atom atom1 = bond.getAtom(0);
            Atom atom2 = bond.getAtom(1);
            atom1.getV3D(v1);
            atom2.getV3D(v2);
            a1[0] = (float)v1.x;
            a1[1] = (float)v1.y;
            a1[2] = (float)v1.z;
            a2[0] = (float)v2.x;
            a2[1] = (float)v2.y;
            a2[2] = (float)v2.z;
            bondmidpoint.add((Tuple3d)v1, (Tuple3d)v2);
            bondmidpoint.scale(0.5);
            bondmidpoint.get(mid);
            Atom.AtomColor.get(atom1.getAtomicNumber()).get(col);
            this.atomLookUp[i] = atom1;
            la.setCoordinate(i, a1);
            la.setColor(i, col);
            la.setNormal(i, a2);
            this.atomLookUp[++i] = atom1;
            la.setCoordinate(i, mid);
            la.setColor(i, col);
            la.setNormal(i, a2);
            Atom.AtomColor.get(atom2.getAtomicNumber()).get(col);
            this.atomLookUp[++i] = atom2;
            la.setCoordinate(i, a2);
            la.setColor(i, col);
            la.setNormal(i, a1);
            this.atomLookUp[++i] = atom2;
            la.setCoordinate(i, mid);
            la.setColor(i, col);
            la.setNormal(i, a1);
            ++i;
        }
        ColoringAttributes cola = new ColoringAttributes(new Color3f(), 3);
        Appearance app = new Appearance();
        this.lineAttributes = new LineAttributes();
        this.lineAttributes.setLineWidth((float)RendererCache.bondwidth);
        this.lineAttributes.setCapability(1);
        this.lineAttributes.setLineAntialiasingEnable(true);
        app.setLineAttributes(this.lineAttributes);
        app.setCapability(16);
        app.setCapability(17);
        RenderingAttributes ra = new RenderingAttributes();
        ra.setAlphaTestValue(0.1f);
        ra.setAlphaTestFunction(6);
        ra.setDepthBufferEnable(true);
        ra.setDepthBufferWriteEnable(true);
        app.setRenderingAttributes(ra);
        app.setColoringAttributes(cola);
        Shape3D wireframe = new Shape3D((Geometry)la, app);
        wireframe.setUserData((Object)this);
        wireframe.setBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0));
        try {
            wireframe.setBoundsAutoCompute(false);
        }
        catch (Exception e) {
            logger.warning("Unable to set boundsAutoCompute to false.\n" + String.valueOf(e));
        }
        wireframe.setCapability(12);
        wireframe.setCapability(14);
        wireframe.setCapability(11);
        return wireframe;
    }

    public Residue getResidue(int polymerID, int resID) {
        Polymer[] polymers = this.getChains();
        if (polymers == null || polymers.length <= polymerID) {
            return null;
        }
        Polymer polymer = polymers[polymerID];
        List<Residue> residues = polymer.getResidues();
        if (residues == null || residues.size() <= resID) {
            return null;
        }
        return residues.get(resID);
    }

    private List<Molecule> getAllWaterInclMistyped() {
        Stream<Molecule> mistyped = this.getMolecules().parallelStream().map(m -> (Molecule)m).filter(m -> {
            List<Atom> atoms = m.getAtomList();
            if (atoms.size() != 3) {
                return false;
            }
            int nO = 0;
            int nH = 0;
            for (Atom atom : atoms) {
                int el = atom.getAtomicNumber();
                if (el == 1) {
                    ++nH;
                    continue;
                }
                if (nH != 8) continue;
                ++nO;
            }
            return nO == 1 && nH == 2;
        });
        return Stream.concat(mistyped, this.getWater().stream().map(m -> (Molecule)m)).distinct().collect(Collectors.toList());
    }

    void renameWaterProtons() {
        for (Molecule water : this.getAllWaterInclMistyped()) {
            Atom H1 = water.getAtomByName("H1", false);
            Atom H2 = water.getAtomByName("H2", false);
            if (H1 != null && H2 != null) continue;
            for (Atom a : water.getAtomList()) {
                if (a.getAtomicNumber() != 1) continue;
                if (H1 == null) {
                    H1 = a;
                    H1.setName("H1");
                    continue;
                }
                if (H2 != null) continue;
                H2 = a;
                H2.setName("H2");
            }
        }
    }

    private void moveIntoUnitCell(MSNode[] groups) {
        if (groups != null && groups.length > 0) {
            this.moveIntoUnitCell(Arrays.asList(groups));
        }
    }

    private void moveIntoUnitCell(List<MSNode> groups) {
        Crystal cryst = this.getCrystal().getUnitCell();
        if (cryst.aperiodic()) {
            return;
        }
        for (MSNode group : groups) {
            double[] com = new double[3];
            double[] xyz = new double[3];
            double[] translate = new double[3];
            List<Atom> atoms = group.getAtomList();
            double totMass = 0.0;
            for (Atom atom : atoms) {
                double mass = atom.getMass();
                totMass += mass;
                xyz = atom.getXYZ(xyz);
                com[0] = com[0] + mass * xyz[0];
                com[1] = com[1] + mass * xyz[1];
                com[2] = com[2] + mass * xyz[2];
            }
            com[0] = com[0] / totMass;
            com[1] = com[1] / totMass;
            com[2] = com[2] / totMass;
            cryst.toPrimaryCell(com, translate);
            translate[0] = translate[0] - com[0];
            translate[1] = translate[1] - com[1];
            translate[2] = translate[2] - com[2];
            for (Atom atom : atoms) {
                atom.move(translate);
            }
        }
    }

    public static enum FractionalMode {
        OFF,
        MOLECULE,
        ATOM;

    }
}

