/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential;

import ffx.numerics.Potential;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.parameters.ForceField;

public class FiniteDifferenceUtils {
    public static double computedEdL(Potential potential, LambdaInterface lambdaInterface, ForceField forceField) {
        double ePlus;
        double eMinus;
        int n = potential.getNumberOfVariables();
        double[] x = new double[n];
        potential.getCoordinates(x);
        double finiteDifferenceStepSize = forceField.getDouble("FD_DLAMBDA", 0.001);
        boolean twoSidedFiniteDifference = forceField.getBoolean("FD_TWO_SIDED", true);
        double currentLambda = lambdaInterface.getLambda();
        double width = finiteDifferenceStepSize;
        if (twoSidedFiniteDifference) {
            if (currentLambda + finiteDifferenceStepSize > 1.0) {
                lambdaInterface.setLambda(currentLambda - finiteDifferenceStepSize);
                eMinus = potential.energy(x);
                lambdaInterface.setLambda(currentLambda);
                ePlus = potential.energy(x);
            } else if (currentLambda - finiteDifferenceStepSize < 0.0) {
                lambdaInterface.setLambda(currentLambda + finiteDifferenceStepSize);
                ePlus = potential.energy(x);
                lambdaInterface.setLambda(currentLambda);
                eMinus = potential.energy(x);
            } else {
                lambdaInterface.setLambda(currentLambda + finiteDifferenceStepSize);
                ePlus = potential.energy(x);
                lambdaInterface.setLambda(currentLambda - finiteDifferenceStepSize);
                eMinus = potential.energy(x);
                width *= 2.0;
                lambdaInterface.setLambda(currentLambda);
            }
        } else if (currentLambda + finiteDifferenceStepSize > 1.0) {
            lambdaInterface.setLambda(currentLambda - finiteDifferenceStepSize);
            eMinus = potential.energy(x);
            lambdaInterface.setLambda(currentLambda);
            ePlus = potential.energy(x);
        } else {
            lambdaInterface.setLambda(currentLambda + finiteDifferenceStepSize);
            ePlus = potential.energy(x);
            lambdaInterface.setLambda(currentLambda);
            eMinus = potential.energy(x);
        }
        double dEdL = (ePlus - eMinus) / width;
        return dEdL;
    }
}

