/*
 * Decompiled with CFR 0.152.
 */
package ffx.utilities;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.util.FastMath;

public class Hybrid36 {
    private static final String digitsBase10 = "0123456789";
    private static final String digitsUpper = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String digitsLower = "0123456789abcdefghijklmnopqrstuvwxyz";
    private static final String valueOutOfRange = "value out of range.";
    private static final String invalidNumberLiteral = "invalid number literal.";
    private static final String unsupportedWidth = "unsupported width.";
    private static final int[] digitsValuesUpper = new int[128];
    private static final int[] digitsValuesLower = new int[128];
    private static boolean firstCall = true;

    private Hybrid36() {
    }

    public static int decode(int width, String s) {
        char di;
        String outOfRange = "Internal error Hybrid-36.decode: integer value out of range.";
        if (firstCall) {
            char di2;
            int i;
            firstCall = false;
            for (i = 0; i < 128; ++i) {
                Hybrid36.digitsValuesUpper[i] = -1;
            }
            for (i = 0; i < 128; ++i) {
                Hybrid36.digitsValuesLower[i] = -1;
            }
            i = 0;
            while (i < 36) {
                di2 = digitsUpper.charAt(i);
                if (di2 > '\u007f') {
                    throw new Error(outOfRange);
                }
                Hybrid36.digitsValuesUpper[di2] = i++;
            }
            i = 0;
            while (i < 36) {
                di2 = digitsLower.charAt(i);
                if (di2 > '\u007f') {
                    throw new Error(outOfRange);
                }
                Hybrid36.digitsValuesLower[di2] = i++;
            }
        }
        if (s.length() == width && (di = s.charAt(0)) <= '\u007f') {
            int result;
            if (digitsValuesUpper[di] >= 10) {
                result = Hybrid36.decodePure(digitsValuesUpper, 36, s);
                if (width == 4) {
                    result -= 456560;
                } else if (width == 5) {
                    result -= 16696160;
                } else {
                    throw new Error(unsupportedWidth);
                }
                return result;
            }
            if (digitsValuesLower[di] >= 10) {
                result = Hybrid36.decodePure(digitsValuesLower, 36, s);
                if (width == 4) {
                    result += 756496;
                } else if (width == 5) {
                    result += 26973856;
                } else {
                    throw new Error(unsupportedWidth);
                }
                return result;
            }
            result = Hybrid36.decodePure(digitsValuesUpper, 10, s);
            if (width != 4 && width != 5) {
                throw new Error(unsupportedWidth);
            }
            return result;
        }
        throw new Error(invalidNumberLiteral);
    }

    public static String encode(int width, int value) {
        int i = value;
        if (width == 4) {
            if (i >= -999) {
                if (i < 10000) {
                    return Hybrid36.encodePure(digitsBase10, 4, i);
                }
                if ((i -= 10000) < 1213056) {
                    return Hybrid36.encodePure(digitsUpper, 0, i += 466560);
                }
                if ((i -= 1213056) < 1213056) {
                    return Hybrid36.encodePure(digitsLower, 0, i += 466560);
                }
            }
        } else if (width == 5) {
            if (i >= -9999) {
                if (i < 100000) {
                    return Hybrid36.encodePure(digitsBase10, 5, i);
                }
                if ((i -= 100000) < 43670016) {
                    return Hybrid36.encodePure(digitsUpper, 0, i += 16796160);
                }
                if ((i -= 43670016) < 43670016) {
                    return Hybrid36.encodePure(digitsLower, 0, i += 16796160);
                }
            }
        } else {
            throw new Error(unsupportedWidth);
        }
        throw new Error(valueOutOfRange);
    }

    private static int decodePure(int[] digitsValues, int digitsSize, String s) {
        boolean haveMinus = false;
        boolean haveNonBlank = false;
        int value = 0;
        for (int i = 0; i < s.length(); ++i) {
            char si = s.charAt(i);
            if (si > '\u007f') {
                throw new Error(invalidNumberLiteral);
            }
            if (si == ' ') {
                if (!haveNonBlank) continue;
                value *= digitsSize;
                continue;
            }
            if (si == '-') {
                if (haveNonBlank) {
                    throw new Error(invalidNumberLiteral);
                }
                haveNonBlank = true;
                haveMinus = true;
                continue;
            }
            haveNonBlank = true;
            int dv = digitsValues[si];
            if (dv < 0 || dv >= digitsSize) {
                throw new Error(invalidNumberLiteral);
            }
            value *= digitsSize;
            value += dv;
        }
        if (haveMinus) {
            value = -value;
        }
        return value;
    }

    private static String encodePure(String digits, int width, int value) {
        boolean neg = false;
        if (value < 0) {
            neg = true;
            value = -value;
        }
        StringBuilder buf = new StringBuilder();
        while (true) {
            int rest = value / digits.length();
            buf.append(digits.charAt(value - rest * digits.length()));
            if (rest == 0) break;
            value = rest;
        }
        if (neg) {
            buf.append('-');
        }
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.repeat((String)" ", (int)FastMath.max((int)0, (int)(width - buf.length()))));
        for (int i = buf.length() - 1; i >= 0; --i) {
            result.append(buf.charAt(i));
        }
        return result.toString();
    }
}

