/*
 * Decompiled with CFR 0.152.
 */
package ffx.utilities;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileUtils {
    private static final Logger logger = Logger.getLogger(FileUtils.class.getName());

    private FileUtils() {
    }

    public static String copyInputStreamToTmpFile(InputStream input, String prefix, String name, String suffix) throws IOException {
        File tmpFile = null;
        name = prefix + "." + (String)name + ".";
        try {
            tmpFile = File.createTempFile((String)name, "." + suffix);
        }
        catch (IOException e) {
            System.out.printf(" Could not extract %s.%n", name);
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        tmpFile.deleteOnExit();
        try (InputStream inputStream = input;
             BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(tmpFile));){
            int size;
            byte[] buffer = new byte[8192];
            while ((size = input.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, size);
            }
        }
        return tmpFile.toString();
    }

    public static Path relativePathTo(File file) {
        File pwd = new File(".");
        Path pwdPath = Paths.get(pwd.getAbsolutePath(), new String[0]);
        Path otherPath = Paths.get(file.getAbsolutePath(), new String[0]);
        return pwdPath.relativize(otherPath);
    }

    public static List<File> traverseFiles(File directory, int maxDepth, String filePattern) {
        List<File> matchingFiles = new ArrayList<File>();
        Pattern pattern = Pattern.compile(filePattern);
        try (Stream<Path> paths = Files.walk(directory.toPath(), maxDepth, new FileVisitOption[0]);){
            matchingFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> pattern.matcher(path.getFileName().toString()).matches()).map(Path::toFile).collect(Collectors.toList());
        }
        catch (IOException e) {
            logger.warning(String.format("Error traversing directory %s: %s", directory.getAbsolutePath(), e.getMessage()));
        }
        return matchingFiles;
    }

    public static void append(File file, String content) {
        try (FileWriter fw = new FileWriter(file, true);){
            fw.write(content);
        }
        catch (IOException e) {
            logger.warning(String.format(" Error appending %s to file %s\n " + e.getMessage(), content, file.getAbsolutePath()));
        }
    }
}

