/*
 * Decompiled with CFR 0.152.
 */
package ffx.utilities;

import ffx.utilities.DirectoryUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class FFXTest {
    public static final boolean ffxCI;
    public static final boolean ffxOpenMM;
    protected static final Logger logger;
    private static final Level origLevel;
    private static final Level testLevel;
    private static Properties properties;
    private Path path = null;

    @AfterClass
    public static void afterClass() {
        Logger.getGlobal().setLevel(origLevel);
        Logger.getLogger("ffx").setLevel(origLevel);
        logger.setLevel(origLevel);
    }

    @BeforeClass
    public static void beforeClass() {
        Logger.getGlobal().setLevel(testLevel);
        Logger.getLogger("ffx").setLevel(testLevel);
        logger.setLevel(testLevel);
    }

    public Path registerTemporaryDirectory() {
        this.deleteTemporaryDirectory();
        try {
            this.path = Files.createTempDirectory("FFXTestDirectory", new FileAttribute[0]);
        }
        catch (IOException e) {
            Assert.fail((String)" Could not create a temporary directory.");
        }
        return this.path;
    }

    private void deleteTemporaryDirectory() {
        if (this.path != null) {
            try {
                DirectoryUtils.deleteDirectoryTree(this.path);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                Assert.fail((String)" Exception deleting files created by Frac2Cart.");
            }
            this.path = null;
        }
    }

    @After
    public void afterTest() {
        System.setProperties(properties);
        this.deleteTemporaryDirectory();
        System.gc();
    }

    @Before
    public void beforeTest() {
        properties = new Properties();
        Properties currentProperties = System.getProperties();
        currentProperties.stringPropertyNames().forEach(key -> properties.setProperty((String)key, currentProperties.getProperty((String)key)));
    }

    static {
        Level level;
        ffxCI = System.getProperty("ffx.ci", "false").equalsIgnoreCase("true");
        ffxOpenMM = System.getProperty("ffx.openMM", "false").equalsIgnoreCase("true");
        logger = Logger.getLogger(FFXTest.class.getName());
        try {
            level = Level.parse(System.getProperty("ffx.log", "INFO").toUpperCase());
        }
        catch (Exception ex) {
            logger.warning(String.format(" Exception %s in parsing value of ffx.log", ex));
            level = Level.INFO;
        }
        origLevel = level;
        try {
            level = Level.parse(System.getProperty("ffx.test.log", "WARNING").toUpperCase());
        }
        catch (Exception ex) {
            logger.warning(String.format(" Exception %s in parsing value of ffx.test.log", ex));
        }
        testLevel = level;
        System.setProperty("ffx.log", testLevel.toString());
    }
}

