/*
 * Decompiled with CFR 0.152.
 */
package ffx.utilities;

import ffx.utilities.FFXBinding;
import ffx.utilities.StringOutputStream;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import picocli.CommandLine;

public abstract class FFXCommand {
    public static final Logger logger = Logger.getLogger(FFXCommand.class.getName());
    public final CommandLine.Help.Ansi color;
    public String[] args;
    public CommandLine.ParseResult parseResult = null;
    @CommandLine.Option(names={"-V", "--version"}, versionHelp=true, defaultValue="false", description={"Print the Force Field X version and exit."})
    public boolean version;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, defaultValue="false", description={"Print command help and exit."})
    public boolean help;
    public FFXBinding binding;

    public FFXCommand() {
        this(new FFXBinding());
    }

    public FFXCommand(String[] args) {
        this(new FFXBinding());
        this.binding.setVariable("args", Arrays.asList(args));
    }

    public FFXCommand(FFXBinding binding) {
        this.binding = binding;
        this.color = GraphicsEnvironment.isHeadless() ? CommandLine.Help.Ansi.ON : CommandLine.Help.Ansi.OFF;
    }

    public void setBinding(FFXBinding binding) {
        this.binding = binding;
    }

    public static Class<? extends FFXCommand> getCommand(String name) {
        Class<?> command;
        ClassLoader loader = FFXCommand.class.getClassLoader();
        Object pathName = name;
        try {
            command = loader.loadClass((String)pathName);
        }
        catch (ClassNotFoundException e) {
            pathName = "ffx.potential.commands." + name;
            try {
                command = loader.loadClass((String)pathName);
            }
            catch (ClassNotFoundException e2) {
                pathName = "ffx.algorithms.commands." + name;
                try {
                    command = loader.loadClass((String)pathName);
                }
                catch (ClassNotFoundException e2b) {
                    pathName = name.startsWith("xray.") ? "ffx.xray.commands." + name.replaceAll("xray.", "") : (name.startsWith("realspace.") ? "ffx.realspace.commands." + name.replaceAll("realspace.", "") : "ffx." + name);
                    try {
                        command = loader.loadClass((String)pathName);
                    }
                    catch (ClassNotFoundException e4) {
                        logger.warning(String.format(" %s was not found.", name));
                        return null;
                    }
                }
            }
        }
        return command.asSubclass(FFXCommand.class);
    }

    public static void listCommands(boolean logCommands, boolean logTestCommands) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            logger.info("\n  Potential Package Commands:");
            URL url = classLoader.getResource("ffx/potential");
            FFXCommand.listCommandsForPackage(url, logCommands, logTestCommands);
            logger.info("\n  Algorithms Package Commands:");
            url = classLoader.getResource("ffx/algorithms");
            FFXCommand.listCommandsForPackage(url, logCommands, logTestCommands);
            logger.info("\n  Refinement Package Commands:");
            url = classLoader.getResource("ffx/xray");
            FFXCommand.listCommandsForPackage(url, logCommands, logTestCommands);
        }
        catch (Exception e) {
            logger.info(" The FFX resource could not be found by the classloader.");
        }
    }

    private static void listCommandsForPackage(URL commandURL, boolean logCommands, boolean logTestCommands) {
        String commandPath = commandURL.getPath();
        String ffx = commandPath.substring(5, commandURL.getPath().indexOf("!"));
        ArrayList<String> commands = new ArrayList<String>();
        ArrayList<String> testCommands = new ArrayList<String>();
        try (JarFile jar = new JarFile(URLDecoder.decode(ffx, StandardCharsets.UTF_8));){
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String className = zipEntry.getName();
                if (!className.startsWith("ffx") || !className.endsWith(".class") || className.contains("$") || !className.contains("commands")) continue;
                className = className.replace("/", ".");
                className = className.replace(".class", "");
                className = className.replace("ffx.potential.commands.", "");
                className = className.replace("ffx.algorithms.commands.", "");
                className = className.replace("ffx.realspace.commands", "realspace");
                if ((className = className.replace("ffx.xray.commands", "xray")).toUpperCase().contains("TEST")) {
                    testCommands.add(className);
                    continue;
                }
                commands.add(className);
            }
        }
        catch (Exception e) {
            logger.info(String.format(" The %s resource could not be decoded.", commandPath));
            return;
        }
        Collections.sort(commands);
        Collections.sort(testCommands);
        if (logTestCommands) {
            for (String command : testCommands) {
                logger.info("   " + command);
            }
        }
        if (logCommands) {
            for (String command : commands) {
                logger.info("   " + command);
            }
        }
    }

    public String helpString() {
        try {
            StringOutputStream sos = new StringOutputStream(new ByteArrayOutputStream());
            CommandLine.usage((Object)this, (PrintStream)sos, (CommandLine.Help.Ansi)this.color);
            return " " + String.valueOf(sos);
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.WARNING, e.toString());
            return null;
        }
    }

    public boolean init() {
        Object arguments = this.binding.getVariable("args");
        if (arguments instanceof List) {
            List list = (List)arguments;
            int numArgs = list.size();
            this.args = new String[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                this.args[i] = (String)list.get(i);
            }
        } else {
            this.args = arguments instanceof String[] ? (String[])arguments : (arguments instanceof String ? new String[]{(String)arguments} : new String[0]);
        }
        CommandLine commandLine = new CommandLine((Object)this);
        try {
            this.parseResult = commandLine.parseArgs(this.args);
        }
        catch (CommandLine.UnmatchedArgumentException uae) {
            logger.warning(" The usual source of this exception is when long-form arguments (such as --uaA) are only preceded by one dash (such as -uaA, which is an error).");
            throw uae;
        }
        if (this.help) {
            logger.info(this.helpString());
            return false;
        }
        return !this.version;
    }

    public FFXCommand run() {
        logger.info(this.helpString());
        return this;
    }
}

