/*
 * Decompiled with CFR 0.152.
 */
package ffx.utilities;

public class ByteSwap {
    private ByteSwap() {
    }

    public static short swap(short value) {
        int b1 = value & 0xFF;
        int b2 = value >> 8 & 0xFF;
        return (short)(b1 << 8 | b2);
    }

    public static int swap(int value) {
        int b1 = value & 0xFF;
        int b2 = value >> 8 & 0xFF;
        int b3 = value >> 16 & 0xFF;
        int b4 = value >> 24 & 0xFF;
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    public static long swap(long value) {
        long b1 = value & 0xFFL;
        long b2 = value >> 8 & 0xFFL;
        long b3 = value >> 16 & 0xFFL;
        long b4 = value >> 24 & 0xFFL;
        long b5 = value >> 32 & 0xFFL;
        long b6 = value >> 40 & 0xFFL;
        long b7 = value >> 48 & 0xFFL;
        long b8 = value >> 56 & 0xFFL;
        return b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8;
    }

    public static float swap(float value) {
        int intValue = Float.floatToIntBits(value);
        intValue = ByteSwap.swap(intValue);
        return Float.intBitsToFloat(intValue);
    }

    public static double swap(double value) {
        long longValue = Double.doubleToLongBits(value);
        longValue = ByteSwap.swap(longValue);
        return Double.longBitsToDouble(longValue);
    }

    public static void swap(short[] array) {
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = ByteSwap.swap(array[i]);
        }
    }

    public static void swap(int[] array) {
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = ByteSwap.swap(array[i]);
        }
    }

    public static void swap(long[] array) {
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = ByteSwap.swap(array[i]);
        }
    }

    public static void swap(float[] array) {
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = ByteSwap.swap(array[i]);
        }
    }

    public static void swap(double[] array) {
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = ByteSwap.swap(array[i]);
        }
    }
}

