/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.thermodynamics;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.pj.Comm;
import ffx.algorithms.thermodynamics.OrthogonalSpaceTempering;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SendSynchronous {
    private static final Logger logger = Logger.getLogger(SendSynchronous.class.getName());
    protected final Comm world = Comm.world();
    protected final int rank = this.world.rank();
    private final int numProc = this.world.size();
    private final double[][] counts = new double[this.numProc][3];
    private final double[] myCounts;
    private final DoubleBuf[] countsBuf = new DoubleBuf[this.numProc];
    private final DoubleBuf myCountsBuf;
    private OrthogonalSpaceTempering.Histogram[] histograms;
    private int[] rankToHistogramMap;

    public SendSynchronous(OrthogonalSpaceTempering.Histogram[] histograms, int[] rankToHistogramMap) {
        for (int i = 0; i < this.numProc; ++i) {
            this.countsBuf[i] = DoubleBuf.buffer((double[])this.counts[i]);
        }
        this.myCounts = this.counts[this.rank];
        this.myCountsBuf = this.countsBuf[this.rank];
        this.histograms = histograms;
        this.rankToHistogramMap = rankToHistogramMap;
    }

    public int getHistogramIndex() {
        return this.rankToHistogramMap[this.rank];
    }

    public void send(double lambda, double dUdL, double temperingWeight) {
        this.myCounts[0] = lambda;
        this.myCounts[1] = dUdL;
        this.myCounts[2] = temperingWeight;
        try {
            this.world.allGather((Buf)this.myCountsBuf, (Buf[])this.countsBuf);
        }
        catch (IOException ex) {
            String message = " Multi-walker OST allGather failed.";
            logger.log(Level.SEVERE, message, ex);
        }
        for (int i = 0; i < this.numProc; ++i) {
            int his = this.rankToHistogramMap[i];
            OrthogonalSpaceTempering.Histogram currentHistogram = this.histograms[his];
            if (currentHistogram.getIndependentWalkers() && i != this.rank) continue;
            double walkerLambda = this.counts[i][0];
            double walkerdUdL = this.counts[i][1];
            double weight = this.counts[i][2];
            currentHistogram.setLastReceivedLambda(walkerLambda);
            currentHistogram.setLastReceiveddUdL(walkerdUdL);
            boolean resetStatistics = currentHistogram.getResetStatistics();
            double lambdaResetValue = currentHistogram.getLambdaResetValue();
            if (resetStatistics && walkerLambda > lambdaResetValue) {
                currentHistogram.allocateRecursionKernel();
                logger.info(String.format(" Cleared OST histogram (Lambda = %6.4f).", walkerLambda));
            }
            currentHistogram.addToRecursionKernelValue(walkerLambda, walkerdUdL, weight);
        }
    }

    public void setHistograms(OrthogonalSpaceTempering.Histogram[] histograms, int[] rankToHistogramMap) {
        this.histograms = histograms;
        this.rankToHistogramMap = rankToHistogramMap;
    }

    public void updateRanks(int[] updatedRankToHisto) {
        assert (updatedRankToHisto.length == this.rankToHistogramMap.length);
        System.arraycopy(updatedRankToHisto, 0, this.rankToHistogramMap, 0, this.rankToHistogramMap.length);
    }
}

