/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.thermodynamics;

import ffx.utilities.FileUtils;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAccessOrder;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorOrder;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.File;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.math3.util.FastMath;

@XmlRootElement(name="LambdaData")
@XmlAccessorOrder(value=XmlAccessOrder.ALPHABETICAL)
@XmlAccessorType(value=XmlAccessType.NONE)
public class LambdaData {
    private static final Logger logger = Logger.getLogger(LambdaData.class.getName());
    @XmlElement(name="Lambda", defaultValue="0.0")
    double lambda = 0.0;
    @XmlElement(name="ThetaVelocity", defaultValue="0.0")
    double thetaVelocity = 0.0;
    @XmlElement(name="ThetaAcceleration", defaultValue="0.0")
    double thetaAcceleration = 0.0;
    @XmlElement(name="StepsTaken", defaultValue="0")
    long stepsTaken = 0L;
    @XmlElement(name="HistogramIndex", defaultValue="0")
    int histogramIndex = 0;
    private File lambdaFile = null;
    private String lambdaFileName = null;
    private boolean lambdaRead = false;
    double theta = 0.0;

    private void rectify() {
        this.theta = FastMath.asin((double)FastMath.sqrt((double)this.lambda));
    }

    public static void writeLambdaData(LambdaData lambdaData, File lambdaFile) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{LambdaData.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)lambdaData, lambdaFile);
        }
        catch (Exception e) {
            logger.warning(" Exception writing histogram:\n " + String.valueOf(e));
        }
    }

    public static LambdaData readLambdaData(@Nullable File file) {
        if (file != null && file.exists() && file.canRead()) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{LambdaData.class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                LambdaData lambdaData = (LambdaData)unmarshaller.unmarshal(file);
                lambdaData.setLambdaFile(file);
                lambdaData.setLambdaRead(true);
                lambdaData.rectify();
                return lambdaData;
            }
            catch (Exception e) {
                logger.warning(" Exception reading LambdaData:\n " + String.valueOf(e));
            }
        }
        LambdaData lambdaData = new LambdaData();
        lambdaData.setLambdaFile(file);
        lambdaData.rectify();
        return lambdaData;
    }

    public void writeLambdaData() {
        LambdaData.writeLambdaData(this, this.lambdaFile);
    }

    public File getLambdaFile() {
        return this.lambdaFile;
    }

    public void setLambdaFile(@Nullable File lambdaFile) {
        this.lambdaFile = lambdaFile;
        this.lambdaFileName = lambdaFile != null ? FileUtils.relativePathTo((File)lambdaFile).toString() : null;
    }

    public String getLambdaFileName() {
        return this.lambdaFileName;
    }

    public boolean wasLambdaRead() {
        return this.lambdaRead;
    }

    public void setLambdaRead(boolean lambdaRead) {
        this.lambdaRead = lambdaRead;
    }

    public void setHistogramIndex(int histogramIndex) {
        this.histogramIndex = histogramIndex;
    }

    public void setStepsTaken(int stepsTaken) {
        this.stepsTaken = stepsTaken;
    }
}

