/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize.manybody;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.WorkerIntegerForLoop;
import edu.rit.pj.WorkerRegion;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.algorithms.optimize.manybody.DistanceMatrix;
import ffx.algorithms.optimize.manybody.EliminatedRotamers;
import ffx.algorithms.optimize.manybody.EnergyExpansion;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.Rotamer;
import ffx.potential.utils.EnergyException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TwoBodyEnergyRegion
extends WorkerRegion {
    private static final Logger logger = Logger.getLogger(TwoBodyEnergyRegion.class.getName());
    private final Residue[] residues;
    private final RotamerOptimization rO;
    private final DistanceMatrix dM;
    private final EnergyExpansion eE;
    private final EliminatedRotamers eR;
    private final List<Residue> allResiduesList;
    private final Map<Integer, Integer[]> twoBodyEnergyMap;
    private final BufferedWriter energyWriter;
    private final Comm world;
    private final int numProc;
    private final boolean prunePairClashes;
    private final double superpositionThreshold;
    private final boolean master;
    private final int rank;
    private final boolean verbose;
    private final boolean writeEnergyRestart;
    private final boolean printFiles;
    private Set<Integer> keySet;

    public TwoBodyEnergyRegion(RotamerOptimization rotamerOptimization, DistanceMatrix dM, EnergyExpansion eE, EliminatedRotamers eR, Residue[] residues, List<Residue> allResiduesList, BufferedWriter energyWriter, Comm world, int numProc, boolean prunePairClashes, double superpositionThreshold, boolean master, int rank, boolean verbose, boolean writeEnergyRestart, boolean printFiles) {
        this.rO = rotamerOptimization;
        this.dM = dM;
        this.eE = eE;
        this.eR = eR;
        this.residues = residues;
        this.allResiduesList = allResiduesList;
        this.energyWriter = energyWriter;
        this.world = world;
        this.numProc = numProc;
        this.prunePairClashes = prunePairClashes;
        this.superpositionThreshold = superpositionThreshold;
        this.master = master;
        this.rank = rank;
        this.verbose = verbose;
        this.writeEnergyRestart = writeEnergyRestart;
        this.printFiles = printFiles;
        this.twoBodyEnergyMap = eE.getTwoBodyEnergyMap();
        logger.info(String.format(" Number of 2-body energies to calculate: %d", this.twoBodyEnergyMap.size()));
    }

    public void finish() {
        this.eR.prePrunePairs(this.residues);
        if (this.prunePairClashes) {
            this.eR.prunePairClashes(this.residues);
        }
        if (this.master && this.verbose) {
            for (int i = 0; i < this.residues.length; ++i) {
                Residue resI = this.residues[i];
                Rotamer[] rotI = resI.getRotamers();
                for (int ri = 0; ri < rotI.length; ++ri) {
                    if (this.eR.check(i, ri)) continue;
                    for (int j = i + 1; j < this.residues.length; ++j) {
                        Residue resJ = this.residues[j];
                        Rotamer[] rotJ = resJ.getRotamers();
                        for (int rj = 0; rj < rotJ.length; ++rj) {
                            if (this.eR.check(j, rj) || this.eR.check(i, ri, j, rj)) continue;
                            logger.info(String.format(" Pair energy %8s %-2d, %8s %-2d: %s", this.residues[i].toString(rotI[ri]), ri, this.residues[j].toString(rotJ[rj]), rj, this.rO.formatEnergy(this.eE.get2Body(i, ri, j, rj))));
                        }
                    }
                }
            }
        }
    }

    public void run() throws Exception {
        if (!this.keySet.isEmpty()) {
            this.execute(0, this.keySet.size() - 1, new TwoBodyEnergyLoop(this));
        }
    }

    public void start() {
        int numPair = this.twoBodyEnergyMap.size();
        int remainder = numPair % this.numProc;
        Integer[] padding = new Integer[]{-1, -1, -1, -1};
        int padKey = numPair;
        while (remainder != 0) {
            this.twoBodyEnergyMap.put(padKey++, padding);
            remainder = this.twoBodyEnergyMap.size() % this.numProc;
        }
        numPair = this.twoBodyEnergyMap.size();
        if (numPair % this.numProc != 0) {
            logger.severe(" Logic error padding pair energies.");
        }
        this.keySet = this.twoBodyEnergyMap.keySet();
    }

    private class TwoBodyEnergyLoop
    extends WorkerIntegerForLoop {
        final DoubleBuf[] resultBuffer;
        final DoubleBuf myBuffer;
        final /* synthetic */ TwoBodyEnergyRegion this$0;

        TwoBodyEnergyLoop(TwoBodyEnergyRegion twoBodyEnergyRegion) {
            TwoBodyEnergyRegion twoBodyEnergyRegion2 = twoBodyEnergyRegion;
            Objects.requireNonNull(twoBodyEnergyRegion2);
            this.this$0 = twoBodyEnergyRegion2;
            this.resultBuffer = new DoubleBuf[twoBodyEnergyRegion.numProc];
            for (int i = 0; i < twoBodyEnergyRegion.numProc; ++i) {
                this.resultBuffer[i] = DoubleBuf.buffer((double[])new double[5]);
            }
            this.myBuffer = this.resultBuffer[twoBodyEnergyRegion.rank];
        }

        public void run(int lb, int ub) {
            for (int key = lb; key <= ub; ++key) {
                long time = -System.nanoTime();
                Integer[] job = this.this$0.twoBodyEnergyMap.get(key);
                int i = job[0];
                int ri = job[1];
                int j = job[2];
                int rj = job[3];
                this.myBuffer.put(0, (double)i);
                this.myBuffer.put(1, (double)ri);
                this.myBuffer.put(2, (double)j);
                this.myBuffer.put(3, (double)rj);
                this.myBuffer.put(4, 0.0);
                if (!(i < 0 || ri < 0 || j < 0 || rj < 0 || this.this$0.eR.check(i, ri) && this.this$0.eR.check(j, rj) && this.this$0.eR.check(i, ri, j, rj))) {
                    double twoBodyEnergy;
                    Residue residueI = this.this$0.residues[i];
                    Residue residueJ = this.this$0.residues[j];
                    Rotamer[] rotI = this.this$0.residues[i].getRotamers();
                    Rotamer[] rotJ = this.this$0.residues[j].getRotamers();
                    int indexI = this.this$0.allResiduesList.indexOf(residueI);
                    int indexJ = this.this$0.allResiduesList.indexOf(residueJ);
                    double resDist = this.this$0.dM.getResidueDistance(indexI, ri, indexJ, rj);
                    String resDistString = "large";
                    if (resDist < Double.MAX_VALUE) {
                        resDistString = String.format("%5.3f", resDist);
                    }
                    double dist = this.this$0.dM.checkDistMatrix(indexI, ri, indexJ, rj);
                    String distString = "     large";
                    if (dist < Double.MAX_VALUE) {
                        distString = String.format("%10.3f", dist);
                    }
                    if (dist < this.this$0.superpositionThreshold) {
                        twoBodyEnergy = Double.NaN;
                        logger.info(String.format(" Pair %8s %-2d, %8s %-2d:\t    NaN at %10.3f A (%s A by res) < %5.3f Ang", residueI.toString(rotI[ri]), ri, residueJ.toString(rotJ[rj]), rj, dist, resDist, this.this$0.superpositionThreshold));
                    } else if (this.this$0.dM.checkPairDistThreshold(indexI, ri, indexJ, rj)) {
                        twoBodyEnergy = 0.0;
                        logger.info(String.format(" Pair %8s %-2d, %8s %-2d: %s at %s A (%s A by res) in %6.4f (sec).", residueI.toString(rotI[ri]), ri, residueJ.toString(rotJ[rj]), rj, this.this$0.rO.formatEnergy(twoBodyEnergy), distString, resDistString, (double)(time += System.nanoTime()) * 1.0E-9));
                    } else {
                        try {
                            twoBodyEnergy = this.this$0.eE.compute2BodyEnergy(this.this$0.residues, i, ri, j, rj);
                            logger.info(String.format(" Pair %8s %-2d, %8s %-2d: %s at %s A (%s A by res) in %6.4f (sec).", residueI.toString(rotI[ri]), ri, residueJ.toString(rotJ[rj]), rj, this.this$0.rO.formatEnergy(twoBodyEnergy), distString, resDistString, (double)(time += System.nanoTime()) * 1.0E-9));
                        }
                        catch (EnergyException ex) {
                            twoBodyEnergy = ex.getEnergy();
                            logger.info(String.format(" Pair %8s %-2d, %8s %-2d: %s at %s A (%s A by res) in %6.4f (sec).", residueI.toString(rotI[ri]), ri, residueJ.toString(rotJ[rj]), rj, this.this$0.rO.formatEnergy(twoBodyEnergy), distString, resDistString, (double)(time += System.nanoTime()) * 1.0E-9));
                        }
                    }
                    this.myBuffer.put(4, twoBodyEnergy);
                }
                if (this.this$0.numProc > 1) {
                    try {
                        this.this$0.world.allGather((Buf)this.myBuffer, (Buf[])this.resultBuffer);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, " Exception communicating pair energies.", e);
                    }
                }
                for (DoubleBuf doubleBuf : this.resultBuffer) {
                    int resI = (int)doubleBuf.get(0);
                    int rotI = (int)doubleBuf.get(1);
                    int resJ = (int)doubleBuf.get(2);
                    int rotJ = (int)doubleBuf.get(3);
                    double energy = doubleBuf.get(4);
                    if (resI < 0 || rotI < 0 || resJ < 0 || rotJ < 0) continue;
                    if (!Double.isFinite(energy)) {
                        logger.info(" Rotamer pair eliminated: " + resI + ", " + rotI + ", " + resJ + ", " + rotJ);
                        this.this$0.eR.eliminateRotamerPair(this.this$0.residues, resI, rotI, resJ, rotJ, false);
                    }
                    this.this$0.eE.set2Body(resI, rotI, resJ, rotJ, energy);
                    if (this.this$0.rank != 0 || !this.this$0.writeEnergyRestart || !this.this$0.printFiles) continue;
                    try {
                        this.this$0.energyWriter.append(String.format("Pair %d %d, %d %d: %16.8f", resI, rotI, resJ, rotJ, energy));
                        this.this$0.energyWriter.newLine();
                        this.this$0.energyWriter.flush();
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, " Exception writing energy restart file.", ex);
                    }
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }
    }
}

