/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize.manybody;

import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.WorkerIntegerForLoop;
import edu.rit.pj.WorkerRegion;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.algorithms.optimize.manybody.DistanceMatrix;
import ffx.algorithms.optimize.manybody.EliminatedRotamers;
import ffx.algorithms.optimize.manybody.EnergyExpansion;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Residue;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.DoubleStream;
import org.apache.commons.math3.util.FastMath;

public class FourBodyEnergyRegion
extends WorkerRegion {
    private static final Logger logger = Logger.getLogger(FourBodyEnergyRegion.class.getName());
    private final Residue[] residues;
    private final RotamerOptimization rO;
    private final DistanceMatrix dM;
    private final EnergyExpansion eE;
    private final EliminatedRotamers eR;
    private final List<Residue> allResiduesList;
    private final Map<Integer, Integer[]> fourBodyEnergyMap;
    private final double superpositionThreshold;
    private Set<Integer> keySet;

    public FourBodyEnergyRegion(RotamerOptimization rotamerOptimization, DistanceMatrix dM, EnergyExpansion eE, EliminatedRotamers eR, Residue[] residues, List<Residue> allResiduesList, double superpositionThreshold) {
        this.rO = rotamerOptimization;
        this.dM = dM;
        this.eE = eE;
        this.eR = eR;
        this.residues = residues;
        this.allResiduesList = allResiduesList;
        this.superpositionThreshold = superpositionThreshold;
        this.fourBodyEnergyMap = eE.getFourBodyEnergyMap();
        logger.info(String.format(" Running quads: %d jobs.", this.fourBodyEnergyMap.size()));
    }

    public void run() throws Exception {
        if (!this.keySet.isEmpty()) {
            this.execute(0, this.keySet.size() - 1, new QuadsEnergyLoop(this));
        }
    }

    public void start() {
        this.keySet = this.fourBodyEnergyMap.keySet();
    }

    private class QuadsEnergyLoop
    extends WorkerIntegerForLoop {
        final /* synthetic */ FourBodyEnergyRegion this$0;

        private QuadsEnergyLoop(FourBodyEnergyRegion fourBodyEnergyRegion) {
            FourBodyEnergyRegion fourBodyEnergyRegion2 = fourBodyEnergyRegion;
            Objects.requireNonNull(fourBodyEnergyRegion2);
            this.this$0 = fourBodyEnergyRegion2;
        }

        public void run(int lb, int ub) {
            for (int key = lb; key <= ub; ++key) {
                double fourBodyEnergy;
                if (!this.this$0.fourBodyEnergyMap.containsKey(key)) continue;
                Integer[] job = this.this$0.fourBodyEnergyMap.get(key);
                int i = job[0];
                int ri = job[1];
                int j = job[2];
                int rj = job[3];
                int k = job[4];
                int rk = job[5];
                int l = job[6];
                int rl = job[7];
                if (this.this$0.eR.check(i, ri) || this.this$0.eR.check(j, rj) || this.this$0.eR.check(k, rk) || this.this$0.eR.check(l, rl) || this.this$0.eR.check(i, ri, j, rj) || this.this$0.eR.check(i, ri, k, rk) || this.this$0.eR.check(i, ri, l, rl) || this.this$0.eR.check(j, rj, k, rk) || this.this$0.eR.check(j, rj, l, rl) || this.this$0.eR.check(k, rk, l, rl)) continue;
                Residue resI = this.this$0.residues[i];
                Residue resJ = this.this$0.residues[j];
                Residue resK = this.this$0.residues[k];
                Residue resL = this.this$0.residues[l];
                int indexI = this.this$0.allResiduesList.indexOf(this.this$0.residues[i]);
                int indexJ = this.this$0.allResiduesList.indexOf(this.this$0.residues[j]);
                int indexK = this.this$0.allResiduesList.indexOf(this.this$0.residues[k]);
                int indexL = this.this$0.allResiduesList.indexOf(this.this$0.residues[l]);
                double rawDist = this.this$0.dM.getRawNBodyDistance(indexI, ri, indexJ, rj, indexK, rk, indexL, rl);
                double dIJ = this.this$0.dM.checkDistMatrix(indexI, ri, indexJ, rj);
                double dIK = this.this$0.dM.checkDistMatrix(indexI, ri, indexK, rk);
                double dIL = this.this$0.dM.checkDistMatrix(indexI, ri, indexL, rl);
                double dJK = this.this$0.dM.checkDistMatrix(indexJ, rj, indexK, rk);
                double dJL = this.this$0.dM.checkDistMatrix(indexJ, rj, indexL, rl);
                double dKL = this.this$0.dM.checkDistMatrix(indexK, rk, indexL, rl);
                double minDist = DoubleStream.of(dIJ, dIK, dIL, dJK, dJL, dKL).min().getAsDouble();
                String distString = "     large";
                if (rawDist < Double.MAX_VALUE) {
                    distString = String.format("%10.3f", rawDist);
                }
                double resDist = this.this$0.dM.get4BodyResidueDistance(indexI, ri, indexJ, rj, indexK, rk, indexL, rl);
                String resDistString = "     large";
                if (resDist < Double.MAX_VALUE) {
                    resDistString = String.format("%5.3f", resDist);
                }
                if (minDist < this.this$0.superpositionThreshold) {
                    logger.info(String.format(" Quad %8s %-2d, %8s %-2d, %8s %-2d, %8s %-2d:   set to NaN at %13.6f Ang (%s Ang by residue)  < %5.3f Ang.", this.this$0.residues[i], ri, this.this$0.residues[j].toFormattedString(false, true), rj, this.this$0.residues[k].toFormattedString(false, true), rk, this.this$0.residues[l].toFormattedString(false, true), rl, minDist, resDistString, this.this$0.superpositionThreshold));
                    continue;
                }
                if (this.this$0.dM.checkQuadDistThreshold(indexI, ri, indexJ, rj, indexK, rk, indexL, rl)) {
                    fourBodyEnergy = 0.0;
                    logger.info(String.format(" Quad %8s %-2d, %8s %-2d, %8s %-2d, %8s %-2d: %s at %s Ang (%s Ang by residue).", resI.toFormattedString(false, true), ri, resJ.toFormattedString(false, true), rj, resK.toFormattedString(false, true), rk, resL.toFormattedString(false, true), rl, this.this$0.rO.formatEnergy(fourBodyEnergy), distString, resDistString));
                    continue;
                }
                try {
                    fourBodyEnergy = this.this$0.eE.compute4BodyEnergy(this.this$0.residues, i, ri, j, rj, k, rk, l, rl);
                    logger.info(String.format(" Quad %8s %-2d, %8s %-2d, %8s %-2d, %8s %-2d: %s at %s Ang (%s Ang by residue).", resI.toFormattedString(false, true), ri, resJ.toFormattedString(false, true), rj, resK.toFormattedString(false, true), rk, resL.toFormattedString(false, true), rl, this.this$0.rO.formatEnergy(fourBodyEnergy), distString, resDistString));
                    if (!(FastMath.abs((double)fourBodyEnergy) > 1.0)) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append(String.format(" Quad %8s %-2d, %8s %-2d, %8s %-2d, %8s %-2d: %s at %s Ang (%s Ang by residue).\n", resI.toFormattedString(false, true), ri, resJ.toFormattedString(false, true), rj, resK.toFormattedString(false, true), rk, resL.toFormattedString(false, true), rl, this.this$0.rO.formatEnergy(fourBodyEnergy), distString, resDistString));
                    sb.append(String.format("   Explain: (ref %d) \n", key));
                    sb.append(String.format("     Self %3d %3d:                  %.3f\n", i, ri, this.this$0.eE.getSelf(i, ri)));
                    sb.append(String.format("     Self %3d %3d:                  %.3f\n", j, rj, this.this$0.eE.getSelf(j, rj)));
                    sb.append(String.format("     Self %3d %3d:                  %.3f\n", k, rk, this.this$0.eE.getSelf(k, rk)));
                    sb.append(String.format("     Self %3d %3d:                  %.3f\n", l, rl, this.this$0.eE.getSelf(l, rl)));
                    sb.append(String.format("     Pair %3d %3d %3d %3d:          %.3f\n", i, ri, j, rj, this.this$0.eE.get2Body(i, ri, j, rj)));
                    sb.append(String.format("     Pair %3d %3d %3d %3d:          %.3f\n", i, ri, k, rk, this.this$0.eE.get2Body(i, ri, k, rk)));
                    sb.append(String.format("     Pair %3d %3d %3d %3d:          %.3f\n", i, ri, l, rl, this.this$0.eE.get2Body(i, ri, l, rl)));
                    sb.append(String.format("     Pair %3d %3d %3d %3d:          %.3f\n", j, rj, k, rk, this.this$0.eE.get2Body(j, rj, k, rk)));
                    sb.append(String.format("     Pair %3d %3d %3d %3d:          %.3f\n", j, rj, l, rl, this.this$0.eE.get2Body(j, rj, l, rl)));
                    sb.append(String.format("     Pair %3d %3d %3d %3d:          %.3f\n", k, rk, l, rl, this.this$0.eE.get2Body(k, rk, l, rl)));
                    sb.append(String.format("     Tri  %3d %3d %3d %3d %3d %3d:  %.3f\n", i, ri, j, rj, k, rk, this.this$0.eE.get3Body(this.this$0.residues, i, ri, j, rj, k, rk)));
                    sb.append(String.format("     Tri  %3d %3d %3d %3d %3d %3d:  %.3f\n", i, ri, j, rj, l, rl, this.this$0.eE.get3Body(this.this$0.residues, i, ri, j, rj, l, rl)));
                    sb.append(String.format("     Tri  %3d %3d %3d %3d %3d %3d:  %.3f\n", i, ri, k, rk, l, rl, this.this$0.eE.get3Body(this.this$0.residues, i, ri, k, rk, l, rl)));
                    sb.append(String.format("     Tri  %3d %3d %3d %3d %3d %3d:  %.3f\n", j, rj, k, rk, l, rl, this.this$0.eE.get3Body(this.this$0.residues, j, rj, k, rk, l, rl)));
                    sb.append(String.format("     backbone:                      %.3f\n", this.this$0.rO.getBackboneEnergy()));
                    sb.append(String.format("     quadEnergy:                 %.3f\n", fourBodyEnergy));
                    sb.append("     --s--\n");
                    sb.append("     Active residues:\n");
                    for (Residue residue : this.this$0.residues) {
                        if (!((Atom)residue.getSideChainAtoms().get(0)).getUse()) continue;
                        sb.append(String.format("       %s\n", residue));
                    }
                    sb.append("     --f--\n");
                    logger.info(sb.toString());
                    continue;
                }
                catch (ArithmeticException ex) {
                    logger.info(String.format(" Quad %8s %-2d, %8s %-2d, %8s %-2d, %8s %-2d: NaN at %s Ang (%s Ang by residue).", resI.toFormattedString(false, true), ri, resJ.toFormattedString(false, true), rj, resK.toFormattedString(false, true), rk, resL.toFormattedString(false, true), rl, distString, resDistString));
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }
    }
}

