/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize.manybody;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.reduction.SharedDouble;
import ffx.algorithms.optimize.manybody.EnergyExpansion;
import ffx.potential.bonded.Residue;
import java.util.Arrays;
import java.util.Objects;

public class EnergyRegion
extends ParallelRegion {
    private EnergyExpansion eE;
    private boolean threeBodyTerm;
    private final SharedDouble self = new SharedDouble();
    private final SharedDouble twoBody = new SharedDouble();
    private final SharedDouble threeBody = new SharedDouble();
    private final EnergyLoop[] energyLoops;
    private Residue[] residues;
    private int[] rotamers;
    private int nResidues;

    public EnergyRegion(int nThreads) {
        this.energyLoops = new EnergyLoop[nThreads];
    }

    public double getSelf() {
        return this.self.get();
    }

    public double getThreeBody() {
        return this.threeBody.get();
    }

    public double getTwoBody() {
        return this.twoBody.get();
    }

    public void init(EnergyExpansion eE, Residue[] residues, int[] rotamers, boolean threeBodyTerm) {
        this.eE = eE;
        this.rotamers = rotamers;
        this.nResidues = residues.length;
        this.residues = Arrays.copyOf(residues, this.nResidues);
        this.threeBodyTerm = threeBodyTerm;
    }

    public void run() throws Exception {
        int threadID = this.getThreadIndex();
        if (this.energyLoops[threadID] == null) {
            this.energyLoops[threadID] = new EnergyLoop(this);
        }
        this.execute(0, this.nResidues - 1, this.energyLoops[threadID]);
    }

    public void start() {
        this.self.set(0.0);
        this.twoBody.set(0.0);
        this.threeBody.set(0.0);
    }

    private class EnergyLoop
    extends IntegerForLoop {
        private double selfSum;
        private double pairSum;
        private double threeBodySum;
        final /* synthetic */ EnergyRegion this$0;

        private EnergyLoop(EnergyRegion energyRegion) {
            EnergyRegion energyRegion2 = energyRegion;
            Objects.requireNonNull(energyRegion2);
            this.this$0 = energyRegion2;
        }

        public void finish() {
            this.this$0.self.addAndGet(this.selfSum);
            this.this$0.twoBody.addAndGet(this.pairSum);
            this.this$0.threeBody.addAndGet(this.threeBodySum);
        }

        public void run(int lb, int ub) {
            for (int a = lb; a <= ub; ++a) {
                int ai = this.this$0.rotamers[a];
                this.selfSum += this.this$0.eE.getSelf(a, ai);
                for (int b = a + 1; b < this.this$0.nResidues; ++b) {
                    int bi = this.this$0.rotamers[b];
                    this.pairSum += this.this$0.eE.get2Body(a, ai, b, bi);
                    if (!this.this$0.threeBodyTerm) continue;
                    for (int c = b + 1; c < this.this$0.nResidues; ++c) {
                        int ci = this.this$0.rotamers[c];
                        this.threeBodySum += this.this$0.eE.get3Body(this.this$0.residues, a, ai, b, bi, c, ci);
                    }
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.dynamic();
        }

        public void start() {
            this.selfSum = 0.0;
            this.pairSum = 0.0;
            this.threeBodySum = 0.0;
        }
    }
}

