/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize.manybody;

import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.algorithms.optimize.manybody.DistanceRegion;
import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.MultiResidue;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.ResidueState;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.nonbonded.NeighborList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.commons.math3.util.FastMath;

public class DistanceMatrix {
    private static final Logger logger = Logger.getLogger(DistanceMatrix.class.getName());
    private final MolecularAssembly molecularAssembly;
    private final AlgorithmListener algorithmListener;
    private final Residue[] allResiduesArray;
    private final List<Residue> allResiduesList;
    private final int numResidues;
    private final RotamerOptimization.DistanceMethod distanceMethod;
    private final double distance;
    private final double twoBodyCutoffDist;
    private final double threeBodyCutoffDist;
    private NeighborDistances[][] distanceMatrix;

    public DistanceMatrix(MolecularAssembly molecularAssembly, AlgorithmListener algorithmListener, Residue[] allResiduesArray, List<Residue> allResiduesList, RotamerOptimization.DistanceMethod distanceMethod, double distance, double twoBodyCutoffDist, double threeBodyCutoffDist) {
        this.molecularAssembly = molecularAssembly;
        this.algorithmListener = algorithmListener;
        this.allResiduesArray = allResiduesArray;
        this.allResiduesList = allResiduesList;
        this.numResidues = allResiduesArray.length;
        this.distanceMethod = distanceMethod;
        this.distance = distance;
        this.twoBodyCutoffDist = twoBodyCutoffDist;
        this.threeBodyCutoffDist = threeBodyCutoffDist;
        this.distanceMatrix();
    }

    private static boolean areFiniteAndNotMax(double ... values) {
        return Arrays.stream(values).allMatch(val -> Double.isFinite(val) && val < Double.MAX_VALUE);
    }

    public double checkDistMatrix(int i, int ri, int j, int rj) {
        if (i > j) {
            int temp = i;
            i = j;
            j = temp;
            temp = ri;
            ri = rj;
            rj = temp;
        }
        return this.distanceMatrix[i][ri].getDistance(j, rj);
    }

    public boolean checkPairDistThreshold(int i, int ri, int j, int rj) {
        if (this.twoBodyCutoffDist <= 0.0 || !Double.isFinite(this.twoBodyCutoffDist)) {
            return false;
        }
        return this.get2BodyDistance(i, ri, j, rj) > this.twoBodyCutoffDist;
    }

    public boolean checkQuadDistThreshold(int i, int ri, int j, int rj, int k, int rk, int l, int rl) {
        if (this.checkTriDistThreshold(i, ri, j, rj, k, rk) || this.checkTriDistThreshold(i, ri, j, rj, l, rl) || this.checkTriDistThreshold(i, ri, k, rk, l, rl) || this.checkTriDistThreshold(j, rj, k, rk, l, rl)) {
            return true;
        }
        if (this.threeBodyCutoffDist <= 0.0 || !Double.isFinite(this.threeBodyCutoffDist)) {
            return false;
        }
        return this.get4BodyDistance(i, ri, j, rj, k, rk, l, rl) > this.threeBodyCutoffDist;
    }

    public boolean checkTriDistThreshold(int i, int ri, int j, int rj, int k, int rk) {
        if (this.checkPairDistThreshold(i, ri, j, rj) || this.checkPairDistThreshold(i, ri, k, rk) || this.checkPairDistThreshold(j, rj, k, rk)) {
            return true;
        }
        if (this.threeBodyCutoffDist <= 0.0 || !Double.isFinite(this.threeBodyCutoffDist)) {
            return false;
        }
        return this.get3BodyDistance(i, ri, j, rj, k, rk) > this.threeBodyCutoffDist;
    }

    public double get2BodyDistance(int i, int ri, int j, int rj) {
        if (i > j) {
            int temp = i;
            i = j;
            j = temp;
            temp = ri;
            ri = rj;
            rj = temp;
        }
        if (this.distanceMethod == RotamerOptimization.DistanceMethod.ROTAMER) {
            return this.checkDistMatrix(i, ri, j, rj);
        }
        return this.getResidueDistance(i, ri, j, rj);
    }

    public double get3BodyResidueDistance(int i, int ri, int j, int rj, int k, int rk) {
        double ij = this.getResidueDistance(i, ri, j, rj);
        double ik = this.getResidueDistance(i, ri, k, rk);
        double jk = this.getResidueDistance(j, rj, k, rk);
        if (DistanceMatrix.areFiniteAndNotMax(ij, ik, jk)) {
            return FastMath.sqrt((double)((ij * ij + ik * ik + jk * jk) / 3.0));
        }
        return Double.MAX_VALUE;
    }

    public double get4BodyResidueDistance(int i, int ri, int j, int rj, int k, int rk, int l, int rl) {
        double ij = this.getResidueDistance(i, ri, j, rj);
        double ik = this.getResidueDistance(i, ri, k, rk);
        double il = this.getResidueDistance(i, ri, l, rl);
        double jk = this.getResidueDistance(j, rj, k, rk);
        double jl = this.getResidueDistance(j, rj, l, rl);
        double kl = this.getResidueDistance(k, rk, l, rl);
        if (DistanceMatrix.areFiniteAndNotMax(ij, ik, il, jk, jl, kl)) {
            return FastMath.sqrt((double)((ij * ij + ik * ik + il * il + jk * jk + jl * jl + kl * kl) / 6.0));
        }
        return Double.MAX_VALUE;
    }

    public double getRawNBodyDistance(int ... resRot) {
        int nRes = resRot.length;
        if (nRes % 2 != 0) {
            throw new IllegalArgumentException(" Must have an even number of arguments; res-rot pairs!");
        }
        if ((nRes /= 2) < 2) {
            throw new IllegalArgumentException(" Must have >= 4 arguments; at least 2 res-rot pairs!");
        }
        int numDists = (int)CombinatoricsUtils.binomialCoefficient((int)nRes, (int)2);
        double mult = 1.0 / (double)numDists;
        double totDist2 = 0.0;
        for (int i = 0; i < nRes - 1; ++i) {
            int i2 = 2 * i;
            for (int j = i + 1; j < nRes; ++j) {
                int j2 = 2 * j;
                double rawDist = this.checkDistMatrix(resRot[i2], resRot[i2 + 1], resRot[j2], resRot[j2 + 1]);
                if (!Double.isFinite(rawDist) || rawDist == Double.MAX_VALUE) {
                    return Double.MAX_VALUE;
                }
                totDist2 += rawDist * mult;
            }
        }
        return FastMath.sqrt((double)totDist2);
    }

    public double getResidueDistance(int i, int ri, int j, int rj) {
        if (i > j) {
            int temp = i;
            i = j;
            j = temp;
            temp = ri;
            ri = rj;
            rj = temp;
        }
        double minDist = Double.MAX_VALUE;
        int lenri = this.distanceMatrix[i].length;
        int lenrj = this.allResiduesArray[j].getRotamers().length;
        for (int roti = 0; roti < lenri; ++roti) {
            for (int rotj = 0; rotj < lenrj; ++rotj) {
                minDist = Math.min(minDist, this.checkDistMatrix(i, roti, j, rotj));
            }
        }
        return minDist;
    }

    public double interResidueDistance(double[][] resi, double[][] resj, SymOp symOp) {
        double dist = Double.MAX_VALUE;
        Crystal crystal = this.molecularAssembly.getCrystal();
        for (double[] xi : resi) {
            for (double[] xj : resj) {
                double r;
                if (symOp != null) {
                    crystal.applySymOp(xj, xj, symOp);
                }
                if (!((r = crystal.image(xi[0] - xj[0], xi[1] - xj[1], xi[2] - xj[2])) < dist)) continue;
                dist = r;
            }
        }
        return FastMath.sqrt((double)dist);
    }

    private void distanceMatrix() {
        double sphere;
        this.distanceMatrix = new NeighborDistances[this.numResidues - 1][];
        for (int i = 0; i < this.numResidues - 1; ++i) {
            int lengthRi;
            Residue residuei = this.allResiduesArray[i];
            try {
                lengthRi = residuei.getRotamers().length;
            }
            catch (IndexOutOfBoundsException ex) {
                logger.warning(String.format(" Residue i %s has null rotamers.", residuei.toFormattedString(false, true)));
                continue;
            }
            this.distanceMatrix[i] = new NeighborDistances[lengthRi];
            for (int ri = 0; ri < lengthRi; ++ri) {
                this.distanceMatrix[i][ri] = new NeighborDistances(this, i, ri);
            }
        }
        ResidueState[] orig = ResidueState.storeAllCoordinates(this.allResiduesList);
        int nMultiRes = 0;
        Atom[] atoms = new Atom[this.numResidues];
        for (int i = 0; i < this.numResidues; ++i) {
            Residue residuei = this.allResiduesArray[i];
            atoms[i] = residuei.getReferenceAtom();
            if (!(residuei instanceof MultiResidue)) continue;
            ++nMultiRes;
        }
        ParallelTeam parallelTeam = this.getParallelTeam(nMultiRes);
        Crystal crystal = this.molecularAssembly.getCrystal();
        int nSymm = crystal.spaceGroup.getNumberOfSymOps();
        logger.info("\n Computing Residue Distance Matrix");
        double nlistCutoff = Math.max(Math.max(this.distance, this.twoBodyCutoffDist), this.threeBodyCutoffDist);
        double conservativeBuffer = 25.0;
        nlistCutoff += conservativeBuffer;
        if (!crystal.aperiodic() && nlistCutoff > (sphere = FastMath.min((double)FastMath.min((double)crystal.interfacialRadiusA, (double)crystal.interfacialRadiusB), (double)crystal.interfacialRadiusC))) {
            nlistCutoff = sphere;
        }
        NeighborList neighborList = new NeighborList(crystal, atoms, nlistCutoff, 0.0, parallelTeam);
        double[][] xyz = new double[nSymm][3 * this.numResidues];
        double[] in = new double[3];
        double[] out = new double[3];
        for (int iSymOp = 0; iSymOp < nSymm; ++iSymOp) {
            SymOp symOp = crystal.spaceGroup.getSymOp(iSymOp);
            for (int i = 0; i < this.numResidues; ++i) {
                Atom atom = atoms[i];
                in[0] = atom.getX();
                in[1] = atom.getY();
                in[2] = atom.getZ();
                crystal.applySymOp(in, out, symOp);
                int iX = i * 3;
                int iY = iX + 1;
                int iZ = iX + 2;
                xyz[iSymOp][iX] = out[0];
                xyz[iSymOp][iY] = out[1];
                xyz[iSymOp][iZ] = out[2];
            }
        }
        int[][][] lists = new int[nSymm][this.numResidues][];
        boolean forceRebuild = true;
        boolean printLists = false;
        long neighborTime = -System.nanoTime();
        neighborList.buildList(xyz, lists, null, forceRebuild, printLists);
        logger.info(String.format(" Built residue neighbor list:           %8.3f sec", (double)(neighborTime += System.nanoTime()) * 1.0E-9));
        DistanceRegion distanceRegion = new DistanceRegion(parallelTeam.getThreadCount(), this.numResidues, crystal, lists, (IntegerSchedule)neighborList.getPairwiseSchedule());
        long parallelTime = -System.nanoTime();
        try {
            distanceRegion.init(this, this.molecularAssembly, this.allResiduesArray, this.algorithmListener, this.distanceMatrix);
            parallelTeam.execute((ParallelRegion)distanceRegion);
        }
        catch (Exception e) {
            String message = " Exception computing residue distance matrix.";
            logger.log(Level.SEVERE, message, e);
        }
        logger.info(String.format(" Pairwise distance matrix:              %8.3f sec", (double)(parallelTime += System.nanoTime()) * 1.0E-9));
        ResidueState.revertAllCoordinates(this.allResiduesList, (ResidueState[])orig);
        try {
            parallelTeam.shutdown();
        }
        catch (Exception ex) {
            logger.warning(String.format(" Exception shutting down parallel team for the distance matrix: %s", ex));
        }
    }

    private ParallelTeam getParallelTeam(int nMultiRes) {
        int nThreads = this.molecularAssembly.getPotentialEnergy().getParallelTeam() != null ? (nMultiRes > 1 ? 1 : this.molecularAssembly.getPotentialEnergy().getParallelTeam().getThreadCount()) : 16;
        ParallelTeam parallelTeam = new ParallelTeam(nThreads);
        return parallelTeam;
    }

    private double get3BodyDistance(int i, int ri, int j, int rj, int k, int rk) {
        double ij = this.get2BodyDistance(i, ri, j, rj);
        double ik = this.get2BodyDistance(i, ri, k, rk);
        double jk = this.get2BodyDistance(j, rj, k, rk);
        if (DistanceMatrix.areFiniteAndNotMax(ij, ik, jk)) {
            return FastMath.sqrt((double)((ij * ij + ik * ik + jk * jk) / 3.0));
        }
        return Double.MAX_VALUE;
    }

    private double get4BodyDistance(int i, int ri, int j, int rj, int k, int rk, int l, int rl) {
        double ij = this.get2BodyDistance(i, ri, j, rj);
        double ik = this.get2BodyDistance(i, ri, k, rk);
        double il = this.get2BodyDistance(i, ri, l, rl);
        double jk = this.get2BodyDistance(j, rj, k, rk);
        double jl = this.get2BodyDistance(j, rj, l, rl);
        double kl = this.get2BodyDistance(k, rk, l, rl);
        if (DistanceMatrix.areFiniteAndNotMax(ij, ik, il, jk, jl, kl)) {
            return FastMath.sqrt((double)((ij * ij + ik * ik + il * il + jk * jk + jl * jl + kl * kl) / 6.0));
        }
        return Double.MAX_VALUE;
    }

    private double evaluateDistance(int i, int ri, int j, int rj) {
        double[][] xj;
        double[][] xi;
        Residue resi = this.allResiduesArray[i];
        Rotamer[] rotamersI = resi.getRotamers();
        Rotamer roti = rotamersI[ri];
        if (roti.equals(resi.getRotamer())) {
            xi = resi.storeCoordinateArray();
        } else {
            ResidueState origI = resi.storeState();
            RotamerLibrary.applyRotamer((Residue)resi, (Rotamer)roti);
            xi = resi.storeCoordinateArray();
            resi.revertState(origI);
        }
        Residue resj = this.allResiduesArray[j];
        Rotamer[] rotamersJ = resj.getRotamers();
        Rotamer rotj = rotamersJ[rj];
        if (rotj.equals(resj.getRotamer())) {
            xj = resj.storeCoordinateArray();
        } else {
            ResidueState origJ = resj.storeState();
            RotamerLibrary.applyRotamer((Residue)resj, (Rotamer)rotj);
            xj = resj.storeCoordinateArray();
            resj.revertState(origJ);
        }
        Crystal crystal = this.molecularAssembly.getCrystal();
        int nSymm = crystal.spaceGroup.getNumberOfSymOps();
        double minDist = Double.MAX_VALUE;
        for (int iSymOp = 0; iSymOp < nSymm; ++iSymOp) {
            SymOp symOp = crystal.spaceGroup.getSymOp(iSymOp);
            double dist = this.interResidueDistance(xi, xj, symOp);
            minDist = Math.min(dist, minDist);
        }
        return minDist;
    }

    public class NeighborDistances {
        private final int i;
        private final int ri;
        private final Map<Integer, double[]> distances;
        final /* synthetic */ DistanceMatrix this$0;

        public NeighborDistances(DistanceMatrix this$0, int i, int ri) {
            DistanceMatrix distanceMatrix = this$0;
            Objects.requireNonNull(distanceMatrix);
            this.this$0 = distanceMatrix;
            this.distances = new HashMap<Integer, double[]>();
            this.i = i;
            this.ri = ri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void storeDistance(int j, int rj, double distance) {
            Map<Integer, double[]> map = this.distances;
            synchronized (map) {
                if (this.distances.containsKey(j)) {
                    this.distances.get((Object)Integer.valueOf((int)j))[rj] = distance;
                } else {
                    double[] dists = new double[this.this$0.allResiduesArray[j].getRotamers().length];
                    Arrays.fill(dists, -1.0);
                    dists[rj] = distance;
                    this.distances.put(j, dists);
                }
            }
        }

        public double getDistance(int j, int rj) {
            if (this.distances.containsKey(j) && this.distances.get(j)[rj] >= 0.0) {
                return this.distances.get(j)[rj];
            }
            double distance = Double.POSITIVE_INFINITY;
            this.storeDistance(j, rj, distance);
            return distance;
        }
    }
}

