/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize.anneal;

import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.Terminatable;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.algorithms.dynamics.integrators.IntegratorEnum;
import ffx.algorithms.dynamics.thermostats.ThermostatEnum;
import ffx.algorithms.optimize.anneal.AnnealingSchedule;
import ffx.algorithms.optimize.anneal.ExpAnnealSchedule;
import ffx.algorithms.optimize.anneal.LinearAnnealSchedule;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimulatedAnnealing
implements Runnable,
Terminatable {
    private static final Logger logger = Logger.getLogger(SimulatedAnnealing.class.getName());
    private final MolecularDynamics molecularDynamics;
    private final AnnealingSchedule schedule;
    private final long mdSteps;
    private final double timeStep;
    private final boolean reInitVelocity;
    private final int trajSteps = 1;
    private double printInterval = 0.01;
    private boolean done = true;
    private boolean terminate;
    private double saveFrequency = 0.1;
    private File dynFile;

    public SimulatedAnnealing(MolecularAssembly molecularAssembly, Potential potentialEnergy, AlgorithmListener algorithmListener, ThermostatEnum requestedThermostat, IntegratorEnum requestedIntegrator, AnnealingSchedule annealingSchedule, long mdSteps, double timeStep, boolean reInitVelocity, File dynFile) {
        this.molecularDynamics = MolecularDynamics.dynamicsFactory(molecularAssembly, potentialEnergy, algorithmListener, requestedThermostat, requestedIntegrator);
        this.schedule = annealingSchedule;
        this.mdSteps = mdSteps;
        this.timeStep = timeStep;
        this.reInitVelocity = reInitVelocity;
        this.dynFile = dynFile;
    }

    public void anneal() {
        if (!this.done) {
            logger.warning(" Programming error - a thread invoked anneal when it was already running.");
            return;
        }
        this.done = false;
        logger.info(" Beginning simulated annealing");
        this.begin();
    }

    public double getKineticEnergy() {
        return this.molecularDynamics.getKineticEnergy();
    }

    public double getPotentialEnergy() {
        return this.molecularDynamics.getPotentialEnergy();
    }

    public double getTemperature() {
        return this.molecularDynamics.getTemperature();
    }

    public double getTotalEnergy() {
        return this.molecularDynamics.getTotalEnergy();
    }

    @Override
    public void run() {
        this.done = false;
        this.terminate = false;
        int minMdSteps = (int)((double)this.mdSteps * this.schedule.minWindowLength());
        if (minMdSteps < 1) {
            logger.warning(String.format(" Minimum number of MD steps per annealing cycle %d was less than steps per OpenMM MD cycle %d! Setting steps per MD cycle to %d", minMdSteps, 1, minMdSteps));
            this.setTrajectorySteps(minMdSteps);
        }
        int nWindows = this.schedule.getNumWindows();
        boolean forceFirstReinit = this.dynFile == null;
        for (int i = 0; i < nWindows; ++i) {
            double temperature = this.schedule.getTemperature(i);
            int nSteps = (int)(this.schedule.windowLength(i) * (double)this.mdSteps);
            logger.info(String.format(" Annealing window %d: %d steps at %9.4g K", i + 1, nSteps, temperature));
            this.molecularDynamics.dynamic(nSteps, this.timeStep, this.printInterval, this.saveFrequency, temperature, this.reInitVelocity || forceFirstReinit, this.dynFile);
            if (this.dynFile == null) {
                this.dynFile = this.molecularDynamics.getDynFile();
            }
            forceFirstReinit = false;
            if (!this.terminate) continue;
            logger.info(String.format("\n Terminating at temperature %8.3f.\n", temperature));
            break;
        }
        if (!this.terminate) {
            logger.info(String.format(" Completed %8d annealing steps\n", nWindows));
        }
        this.done = true;
        this.terminate = false;
    }

    public void setPrintInterval(double printInterval) {
        this.printInterval = printInterval;
    }

    public void setRestartFrequency(double restart) throws IllegalArgumentException {
        if (!Double.isFinite(restart) || !(restart > 0.0)) {
            throw new IllegalArgumentException(String.format(" Restart frequency must be positive finite, was %10.4g", restart));
        }
        this.molecularDynamics.setRestartFrequency(restart);
    }

    public void setSaveFrequency(double save) {
        this.saveFrequency = save;
    }

    public void setTrajectorySteps(int trajectorySteps) {
        this.molecularDynamics.setIntervalSteps(trajectorySteps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        this.terminate = true;
        while (!this.done) {
            SimulatedAnnealing simulatedAnnealing = this;
            synchronized (simulatedAnnealing) {
                try {
                    this.wait(1L);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception terminating annealing.\n", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void begin() {
        logger.info(String.format(" Initial temperature:    %8.3f (Kelvin)", this.schedule.getHighTemp()));
        logger.info(String.format(" Final temperature:      %8.3f (Kelvin)", this.schedule.getLowTemp()));
        logger.info(String.format(" Annealing steps:        %8d", this.schedule.getNumWindows()));
        logger.info(String.format(" MD steps/temperature:   %8d", this.mdSteps));
        logger.info(String.format(" MD time step:           %8.3f (fs)", this.timeStep));
        Thread annealingThread = new Thread(this);
        annealingThread.start();
        SimulatedAnnealing simulatedAnnealing = this;
        synchronized (simulatedAnnealing) {
            try {
                while (annealingThread.isAlive()) {
                    this.wait(100L);
                }
            }
            catch (Exception e) {
                String message = "Simulated annealing interrupted.";
                logger.log(Level.WARNING, message, e);
            }
        }
    }

    private static interface ScheduleConstructor {
        public AnnealingSchedule asConstruct(int var1, double var2, double var4);
    }

    public static enum Schedules {
        EXP(ExpAnnealSchedule::new, "EXP", "EXPONENTIAL"),
        LINEAR(LinearAnnealSchedule::new, "LINEAR");

        private final ScheduleConstructor sc;
        private final Set<String> aliases;

        private Schedules(ScheduleConstructor sc, String ... names) {
            this.sc = sc;
            this.aliases = Set.of(names);
        }

        public static Schedules parse(String name) {
            name = name.toUpperCase();
            for (Schedules s : Schedules.values()) {
                if (!s.aliases.contains(name)) continue;
                return s;
            }
            return Schedules.valueOf(name);
        }

        public AnnealingSchedule generate(int nWindows, double tLow, double tHigh) {
            return this.sc.asConstruct(nWindows, tLow, tHigh);
        }
    }
}

