/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize.anneal;

import ffx.algorithms.optimize.anneal.AnnealingSchedule;
import org.apache.commons.math3.util.FastMath;

public class ExpAnnealSchedule
implements AnnealingSchedule {
    private final int nWindows;
    private final double tHigh;
    private final double tLow;
    private final double gamma;
    private final String description;

    public ExpAnnealSchedule(int nWindows, double tLow, double tHigh) {
        assert (nWindows > 1);
        assert (tLow < tHigh);
        assert (tLow >= 0.0);
        assert (Double.isFinite(tHigh));
        this.nWindows = nWindows;
        this.tHigh = tHigh;
        this.tLow = tLow;
        this.gamma = StrictMath.pow(tLow / tHigh, 1.0 / (double)(nWindows - 1));
        this.description = String.format("Exponential annealing schedule with %d windows, initial temperature %12.7g K, final temperature %12.7g K, gamma %12.7g", nWindows, tHigh, tLow, this.gamma);
    }

    @Override
    public double getHighTemp() {
        return this.tHigh;
    }

    @Override
    public double getLowTemp() {
        return this.tLow;
    }

    @Override
    public int getNumWindows() {
        return this.nWindows;
    }

    @Override
    public double getTemperature(int i) {
        assert (i >= 0 && i < this.nWindows);
        return this.tHigh * FastMath.pow((double)this.gamma, (int)i);
    }

    @Override
    public double[] getTemperatures() {
        double[] temps = new double[this.nWindows];
        for (int i = 0; i < this.nWindows; ++i) {
            temps[i] = this.getTemperature(i);
        }
        return temps;
    }

    @Override
    public double maxWindowLength() {
        return 1.0;
    }

    @Override
    public double minWindowLength() {
        return 1.0;
    }

    public String toString() {
        return this.description;
    }

    @Override
    public double totalWindowLength() {
        return this.nWindows;
    }

    @Override
    public double windowLength(int window) {
        return 1.0;
    }
}

