/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize;

import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.Terminatable;
import ffx.numerics.OptimizationInterface;
import ffx.numerics.Potential;
import ffx.numerics.optimization.LBFGS;
import ffx.numerics.optimization.LineSearch;
import ffx.numerics.optimization.OptimizationListener;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.extended.ExtendedSystem;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhMinimize
implements OptimizationListener,
Terminatable {
    private static final Logger logger = Logger.getLogger(PhMinimize.class.getName());
    protected final MolecularAssembly molecularAssembly;
    protected final Potential potential;
    protected final ExtendedSystem esvSystem;
    protected final AlgorithmListener algorithmListener;
    protected final int n;
    protected final int nESV;
    protected final double[] x;
    protected double[] theta;
    protected final double[] grad;
    protected double[] gradESV;
    protected final double[] scaling;
    protected boolean done = false;
    protected boolean terminate = false;
    protected long time;
    protected double energy;
    protected int status;
    protected int nSteps;
    double rmsGradient;

    public PhMinimize(MolecularAssembly molecularAssembly, Potential potential, AlgorithmListener algorithmListener, ExtendedSystem esvSystem) {
        this.molecularAssembly = molecularAssembly;
        this.algorithmListener = algorithmListener;
        this.potential = potential;
        this.esvSystem = esvSystem;
        this.n = potential.getNumberOfVariables();
        this.nESV = esvSystem.getNumberOfVariables();
        this.x = new double[this.n];
        this.theta = new double[this.nESV];
        this.grad = new double[this.n];
        this.gradESV = new double[this.nESV];
        this.scaling = new double[this.n];
        Arrays.fill(this.scaling, 12.0);
    }

    public PhMinimize(MolecularAssembly molecularAssembly, AlgorithmListener algorithmListener, ExtendedSystem esvSystem) {
        this.molecularAssembly = molecularAssembly;
        this.algorithmListener = algorithmListener;
        this.esvSystem = esvSystem;
        if (molecularAssembly.getPotentialEnergy() == null) {
            molecularAssembly.setPotential(ForceFieldEnergy.energyFactory((MolecularAssembly)molecularAssembly));
        }
        this.potential = molecularAssembly.getPotentialEnergy();
        this.n = this.potential.getNumberOfVariables();
        this.nESV = esvSystem.getNumberOfVariables();
        this.x = new double[this.n];
        this.theta = new double[this.nESV];
        this.grad = new double[this.n];
        this.gradESV = new double[this.nESV];
        this.scaling = new double[this.n];
        Arrays.fill(this.scaling, 12.0);
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getRMSGradient() {
        return this.rmsGradient;
    }

    public int getStatus() {
        return this.status;
    }

    public Potential minimizeCoordinates() {
        return this.minimizeCoordinates(7, 1.0, Integer.MAX_VALUE);
    }

    public Potential minimizeCoordinates(double eps) {
        return this.minimizeCoordinates(7, eps, Integer.MAX_VALUE);
    }

    public Potential minimizeCoordinates(double eps, int maxIterations) {
        return this.minimizeCoordinates(7, eps, maxIterations);
    }

    public Potential minimizeCoordinates(int m, double eps, int maxIterations) {
        this.time = System.nanoTime();
        this.potential.getCoordinates(this.x);
        this.potential.setScaling(this.scaling);
        for (int i = 0; i < this.n; ++i) {
            int n = i;
            this.x[n] = this.x[n] * this.scaling[i];
        }
        this.done = false;
        this.energy = this.potential.energyAndGradient(this.x, this.grad);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format(" Minimize initial energy: %16.8f", this.energy));
        }
        this.status = LBFGS.minimize((int)this.n, (int)m, (double[])this.x, (double)this.energy, (double[])this.grad, (double)eps, (int)maxIterations, (OptimizationInterface)this.potential, (OptimizationListener)this);
        this.done = true;
        switch (this.status) {
            case 0: {
                logger.info(String.format("\n Optimization achieved convergence criteria: %8.5f", this.rmsGradient));
                break;
            }
            case 1: {
                logger.info(String.format("\n Optimization terminated at step %d.", this.nSteps));
                break;
            }
            default: {
                logger.warning("\n Optimization failed.");
            }
        }
        this.potential.setScaling(null);
        return this.potential;
    }

    public Potential minimizeTitration(double eps, int maxIterations) {
        return this.minimizeTitration(7, eps, maxIterations);
    }

    public Potential minimizeTitration(int m, double eps, int maxIterations) {
        this.time = System.nanoTime();
        this.theta = this.esvSystem.getThetaPosition();
        this.done = false;
        this.potential.getCoordinates(this.x);
        this.theta = this.esvSystem.getThetaPosition();
        this.energy = this.esvSystem.energyAndGradient(this.theta, this.gradESV);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format(" Minimize initial energy: %16.8f", this.energy));
        }
        this.status = LBFGS.minimize((int)this.nESV, (int)m, (double[])this.theta, (double)this.energy, (double[])this.gradESV, (double)eps, (int)maxIterations, (OptimizationInterface)this.esvSystem, (OptimizationListener)this);
        this.done = true;
        switch (this.status) {
            case 0: {
                logger.info(String.format("\n Optimization achieved convergence criteria: %8.5f", this.rmsGradient));
                for (Atom atom : this.molecularAssembly.getAtomList()) {
                    int atomIndex = atom.getIndex() - 1;
                    atom.setOccupancy(this.esvSystem.getTitrationLambda(atomIndex));
                    atom.setTempFactor(this.esvSystem.getTautomerLambda(atomIndex));
                }
                break;
            }
            case 1: {
                logger.info(String.format("\n Optimization terminated at step %d.", this.nSteps));
                break;
            }
            default: {
                logger.warning("\n Optimization failed.");
            }
        }
        this.potential.setScaling(null);
        return this.potential;
    }

    public boolean optimizationUpdate(int iteration, int nBFGS, int functionEvaluations, double rmsGradient, double rmsCoordinateChange, double energy, double energyChange, double angle, LineSearch.LineSearchResult lineSearchResult) {
        long currentTime = System.nanoTime();
        Double seconds = (double)(currentTime - this.time) * 1.0E-9;
        this.time = currentTime;
        this.rmsGradient = rmsGradient;
        this.nSteps = iteration;
        this.energy = energy;
        if (iteration == 0) {
            if (nBFGS > 0) {
                logger.info("\n Limited Memory BFGS Quasi-Newton Optimization: \n");
            } else {
                logger.info("\n Steepest Decent Optimization: \n");
            }
            logger.info(" Cycle       Energy      G RMS    Delta E   Delta X    Angle  Evals     Time\n");
        }
        if (lineSearchResult == null) {
            logger.info(String.format("%6d%13.4f%11.4f", iteration, energy, rmsGradient));
        } else if (lineSearchResult == LineSearch.LineSearchResult.Success) {
            logger.info(String.format("%6d%13.4f%11.4f%11.4f%10.4f%9.2f%7d %8.3f", iteration, energy, rmsGradient, energyChange, rmsCoordinateChange, angle, functionEvaluations, seconds));
        } else {
            logger.info(String.format("%6d%13.4f%11.4f%11.4f%10.4f%9.2f%7d %8s", iteration, energy, rmsGradient, energyChange, rmsCoordinateChange, angle, functionEvaluations, lineSearchResult));
        }
        if (this.algorithmListener != null) {
            this.algorithmListener.algorithmUpdate(this.molecularAssembly);
        }
        if (this.terminate) {
            logger.info(" The optimization recieved a termination request.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        this.terminate = true;
        while (!this.done) {
            PhMinimize phMinimize = this;
            synchronized (phMinimize) {
                try {
                    this.wait(1L);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception terminating minimization.\n", e);
                }
            }
        }
    }
}

