/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.mc;

import ffx.algorithms.mc.MCMove;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.ResidueState;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.bonded.Torsion;
import ffx.potential.parameters.AtomType;
import ffx.potential.parsers.PDBFilter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.util.FastMath;

public class RosenbluthChiAllMove
implements MCMove {
    private static final Logger logger = Logger.getLogger(RosenbluthChiAllMove.class.getName());
    private static int numAccepted = 0;
    private final MolecularAssembly molecularAssembly;
    private final Residue target;
    private final ResidueState origState;
    private final ForceFieldEnergy forceFieldEnergy;
    private final double beta;
    private final int testSetSize;
    private final ThreadLocalRandom rand = ThreadLocalRandom.current();
    private final StringBuilder report = new StringBuilder();
    private final boolean[] doChi = new boolean[4];
    private final MODE mode;
    private final boolean torsionSampling;
    private final double CATASTROPHE_THRESHOLD = -10000.0;
    private final double NS_TO_MS = 1.0E-6;
    double finalEnergy = 0.0;
    private Rotamer proposedMove;
    private PDBFilter writer;
    private SnapshotWriter snapshotWriter = null;
    private double Wn = 0.0;
    private double Wo = 0.0;
    private final int moveNumber;
    private double[] proposedChis = new double[4];
    private boolean accepted = false;
    private final double origEnergy;
    private final long startTime;
    private long endTime;
    private final boolean verbose;
    private final boolean randInts;
    private final boolean noSnaps;
    private final boolean printTestSets;
    private final boolean logTimings;
    private final boolean verboseEnergies;

    RosenbluthChiAllMove(MolecularAssembly molecularAssembly, Residue target, int testSetSize, ForceFieldEnergy forceFieldEnergy, double temperature, boolean writeSnapshots, int moveNumber, boolean verbose) {
        CompositeConfiguration properties = molecularAssembly.getProperties();
        if (properties.containsKey("cbmc-type")) {
            this.mode = MODE.valueOf(properties.getString("cbmc-type"));
        } else {
            logger.severe("CBMC: must specify a bias type.");
            this.mode = MODE.CHEAP;
        }
        this.startTime = System.nanoTime();
        this.molecularAssembly = molecularAssembly;
        this.target = target;
        this.testSetSize = testSetSize;
        this.forceFieldEnergy = forceFieldEnergy;
        this.beta = 1.0 / (0.0019872042586408316 * temperature);
        this.moveNumber = moveNumber;
        this.verbose = verbose;
        this.origState = target.storeState();
        this.randInts = properties.getBoolean("cbmc-randInts", false);
        this.noSnaps = properties.getBoolean("cbmc-noSnaps", false);
        this.printTestSets = properties.getBoolean("cbmc-printTestSets", false);
        this.logTimings = properties.getBoolean("cbmc-logTimings", false);
        this.verboseEnergies = properties.getBoolean("cbmc-verboseEnergies", false);
        if (writeSnapshots) {
            this.snapshotWriter = new SnapshotWriter(this, molecularAssembly, false);
        }
        this.doChi[0] = properties.getBoolean("cbmc-doChi0", false);
        this.doChi[1] = properties.getBoolean("cbmc-doChi1", false);
        this.doChi[2] = properties.getBoolean("cbmc-doChi2", false);
        this.doChi[3] = properties.getBoolean("cbmc-doChi3", false);
        if (!(this.doChi[0] || this.doChi[1] || this.doChi[2] || this.doChi[3])) {
            this.doChi[0] = true;
            this.doChi[1] = true;
            this.doChi[2] = true;
            this.doChi[3] = true;
        }
        this.updateAll();
        this.origEnergy = this.totalEnergy();
        this.torsionSampling = properties.getBoolean("cbmc-torsionSampler", false);
        if (this.torsionSampling) {
            logger.info(" Torsion Sampler engaged!");
            HashMap<Integer, BackBondedList> map = this.createBackBondedMap(AminoAcidUtils.AminoAcid3.valueOf((String)target.getName()));
            ArrayList<Torsion> allTors = new ArrayList<Torsion>();
            for (int i = 0; i < map.size(); ++i) {
                Torsion tors = map.get((Object)Integer.valueOf((int)i)).torsion;
                allTors.add(tors);
            }
            this.torsionSampler(allTors);
            System.exit(0);
        }
        try {
            switch (this.mode.ordinal()) {
                case 0: {
                    this.engageExpensive();
                    break;
                }
                case 1: {
                    this.engageCheap();
                    break;
                }
                case 2: {
                    this.engageControlAll();
                    break;
                }
                default: {
                    logger.severe("CBMC: Unknown biasing type requested.");
                    break;
                }
            }
        }
        catch (ArithmeticException ex) {
            target.revertState(this.origState);
            this.accepted = false;
        }
    }

    public MODE getMode() {
        return this.mode;
    }

    public double getWn() {
        return this.Wn;
    }

    @Override
    public void move() {
        RotamerLibrary.applyRotamer((Residue)this.target, (Rotamer)this.proposedMove);
        this.updateAll();
    }

    @Override
    public void revertMove() {
        this.target.revertState(this.origState);
        this.updateAll();
    }

    public String toString() {
        return String.format("Rosenbluth Rotamer Move:\n   Res:   %s\n   Rota: %s", this.target.toString(), this.proposedMove.toString());
    }

    private void write() {
        Object filename;
        if (this.noSnaps) {
            return;
        }
        if (this.writer == null) {
            this.writer = new PDBFilter(this.molecularAssembly.getFile(), this.molecularAssembly, null, null);
        }
        if (!((String)(filename = this.molecularAssembly.getFile().getAbsolutePath())).contains("_mc")) {
            filename = FilenameUtils.removeExtension((String)filename) + "_mc.pdb";
        }
        File file = new File((String)filename);
        this.writer.writeFile(file, false);
    }

    double getWo() {
        return this.Wo;
    }

    private TrialSet cheapTorsionSet(List<Torsion> allTors, int setSize, String snapSuffix) {
        if (this.printTestSets) {
            this.report.append("    TrialSet_Cheap (uDep uExt)\n");
        }
        TrialSet trialSet = new TrialSet(this, setSize);
        double[] origChi = RotamerLibrary.measureRotamer((Residue)this.target, (boolean)false);
        int i = 0;
        while (i < setSize) {
            double[] newChi = new double[origChi.length];
            System.arraycopy(origChi, 0, newChi, 0, origChi.length);
            for (int k = 0; k < origChi.length; ++k) {
                if (!this.doChi[k]) continue;
                newChi[k] = this.randInts ? (double)(this.rand.nextInt(360) - 180) : this.rand.nextDouble(360.0) - 180.0;
            }
            Rotamer newState = this.createRotamer(this.target, newChi);
            RotamerLibrary.applyRotamer((Residue)this.target, (Rotamer)newState);
            double uTors = 0.0;
            for (int j = 0; j < allTors.size(); ++j) {
                if (!this.doChi[j]) continue;
                uTors += allTors.get(j).energy(false);
                double offset = 0.0;
                try {
                    offset = TORSION_OFFSET_AMPRO13.valueOf((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0001"}, (String)this.target.getName(), (int)j))).offset;
                }
                catch (IllegalArgumentException ex) {
                    logger.warning(ex.getMessage());
                }
                uTors += offset;
            }
            double criterion = FastMath.exp((double)(-this.beta * uTors));
            double rng = this.rand.nextDouble();
            if (!(rng < criterion)) continue;
            trialSet.theta[i] = 0.0;
            trialSet.rotamer[i] = newState;
            trialSet.uDep[i] = uTors;
            trialSet.uExt[i] = this.totalEnergy() - uTors;
            ++i;
            this.writeSnapshot(snapSuffix, true);
            if (!this.printTestSets) continue;
            if (i < 5 || i > setSize - 1) {
                this.report.append(String.format("       %3s %d:      %5.2f\t%5.2f\n", snapSuffix, i, trialSet.uDep[i - 1], trialSet.uExt[i - 1]));
                continue;
            }
            if (i != 5) continue;
            this.report.append("       ...\n");
        }
        this.target.revertState(this.origState);
        this.updateAll();
        return trialSet;
    }

    private TrialSet expensiveTorsionSet(Torsion tors, int chiIndex, int setSize, String snapSuffix) {
        this.report.append(String.format("    TrialSet for Chi%d\t\t(Theta uDep uExt)\n", chiIndex));
        TrialSet trialSet = new TrialSet(this, setSize);
        double[] origChi = RotamerLibrary.measureRotamer((Residue)this.target, (boolean)false);
        int i = 0;
        while (i < setSize) {
            double theta = this.rand.nextDouble(360.0) - 180.0;
            double[] newChi = new double[origChi.length];
            System.arraycopy(origChi, 0, newChi, 0, origChi.length);
            newChi[chiIndex] = theta;
            Rotamer newState = this.createRotamer(this.target, newChi);
            RotamerLibrary.applyRotamer((Residue)this.target, (Rotamer)newState);
            double uTors = tors.energy(false);
            double offset = 0.0;
            try {
                offset = TORSION_OFFSET_AMPRO13.valueOf((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0001"}, (String)this.target.getName(), (int)chiIndex))).offset;
            }
            catch (IllegalArgumentException ex) {
                logger.warning(ex.getMessage());
            }
            double criterion = FastMath.exp((double)(-this.beta * (uTors += offset)));
            double rng = this.rand.nextDouble();
            this.report.append(String.format("    prop: %5.1f %.2g %.2g %.2g\n", theta, uTors, criterion, rng));
            if (!(rng < criterion)) continue;
            this.report.append("    ^ Accepted!\n");
            this.writeSnapshot(snapSuffix, false);
            trialSet.theta[i] = theta;
            trialSet.rotamer[i] = newState;
            trialSet.uDep[i] = uTors;
            trialSet.uExt[i] = this.totalEnergy() - uTors;
            this.writeSnapshot(snapSuffix, true);
            if (++i < 4 || i > setSize - 1) {
                this.report.append(String.format("       %3s %d:      %5.2f\t%5.2f\t%5.2f\n", snapSuffix, i, theta, trialSet.uDep[i - 1], trialSet.uExt[i - 1]));
                continue;
            }
            if (i != 4) continue;
            this.report.append("       ...\n");
        }
        this.target.revertState(this.origState);
        this.updateAll();
        return trialSet;
    }

    private void engageCheap() {
        this.report.append(String.format(" Rosenbluth CBMC Move: %4d  (%s)\n", this.moveNumber, this.target));
        AminoAcidUtils.AminoAcid3 name = AminoAcidUtils.AminoAcid3.valueOf((String)this.target.getName());
        double[] chi = RotamerLibrary.measureRotamer((Residue)this.target, (boolean)false);
        HashMap<Integer, BackBondedList> map = this.createBackBondedMap(name);
        ArrayList<Torsion> allTors = new ArrayList<Torsion>();
        for (int i = 0; i < chi.length; ++i) {
            Torsion tors = map.get((Object)Integer.valueOf((int)i)).torsion;
            allTors.add(tors);
        }
        TrialSet newTrialSet = this.cheapTorsionSet(allTors, this.testSetSize, "bkn");
        this.Wn = newTrialSet.sumExtBolt();
        if (this.Wn <= 0.0) {
            this.report.append("WARNING: Numerical instability in CMBC.");
            this.report.append("  Test set uExt values:  ");
            for (int i = 0; i < newTrialSet.uExt.length; ++i) {
                this.report.append(String.format("%5.2f,  ", newTrialSet.uExt[i]));
            }
            this.report.append("  Discarding move.\n");
            this.target.revertState(this.origState);
            this.Wn = -1.0;
            this.Wo = 1000.0;
            logger.info(this.report.toString());
        }
        double rng = this.rand.nextDouble(this.Wn);
        double running = 0.0;
        for (int j = 0; j < newTrialSet.uExt.length; ++j) {
            double uExtBolt = FastMath.exp((double)(-this.beta * newTrialSet.uExt[j]));
            if (!(rng < (running += uExtBolt))) continue;
            this.proposedMove = newTrialSet.rotamer[j];
            this.proposedChis = newTrialSet.theta;
            double prob = uExtBolt / this.Wn * 100.0;
            if (!this.printTestSets) break;
            this.report.append(String.format("       Chose %d   %7.4f\t  %4.1f%%\n", j + 1, newTrialSet.uExt[j], prob));
            break;
        }
        this.report.append(String.format("    Wn Total:  %g\n", this.Wn));
        double ouDep = 0.0;
        for (Torsion tors : allTors) {
            ouDep += tors.energy(false);
        }
        double ouExt = this.totalEnergy() - ouDep;
        double ouExtBolt = FastMath.exp((double)(-this.beta * ouExt));
        if (this.printTestSets) {
            this.report.append(String.format("       %3s %d:  %9.5g  %9.5g  %9.5g\n", "bko", 0, ouDep, ouExt, ouExtBolt));
        }
        this.writeSnapshot("bko", true);
        TrialSet oldTrialSet = this.cheapTorsionSet(allTors, this.testSetSize - 1, "bko");
        this.Wo = ouExtBolt + oldTrialSet.sumExtBolt();
        this.report.append(String.format("    Wo Total:  %11.4g\n", this.Wo));
        this.report.append(String.format("    Wn/Wo:     %11.4g", this.Wn / this.Wo));
        RotamerLibrary.applyRotamer((Residue)this.target, (Rotamer)this.proposedMove);
        this.proposedChis = RotamerLibrary.measureRotamer((Residue)this.target, (boolean)false);
        this.finalEnergy = this.totalEnergy();
        if (this.finalEnergy < -10000.0) {
            this.report.append("\nWARNING: Multipole catastrophe in CMBC.\n");
            this.report.append("  Discarding move.\n");
            this.target.revertState(this.origState);
            this.updateAll();
            this.Wn = -1.0;
            this.Wo = 1000.0;
            logger.info(this.report.toString());
        }
        double criterion = Math.min(1.0, this.Wn / this.Wo);
        rng = ThreadLocalRandom.current().nextDouble();
        this.report.append(String.format("    rng:    %5.2f\n", rng));
        if (rng < criterion) {
            this.accepted = true;
            this.updateAll();
            this.write();
            this.report.append(String.format(" Accepted! %5d    NewEnergy: %.4f    Chi:", ++numAccepted, this.finalEnergy));
            for (double proposedChi : this.proposedChis) {
                this.report.append(String.format(" %7.2f", proposedChi));
            }
            this.report.append("\n");
        } else {
            this.accepted = false;
            this.target.revertState(this.origState);
            this.updateAll();
            this.report.append(String.format(" Denied.   %5d    OldEnergy: %.4f    Chi:", numAccepted, this.origEnergy));
            for (double v : chi) {
                this.report.append(String.format(" %7.2f", v));
            }
            this.report.append("\n");
        }
        this.endTime = System.nanoTime();
        double took = (double)(this.endTime - this.startTime) * 1.0E-6;
        if (this.logTimings) {
            this.report.append(String.format("   Timing (ms): %.2f", took));
        }
        logger.info(this.report.toString());
    }

    private void engageExpensive() {
        this.report.append(String.format(" Rosenbluth CBMC Move: %4d  %s\n", this.moveNumber, this.target));
        AminoAcidUtils.AminoAcid3 name = AminoAcidUtils.AminoAcid3.valueOf((String)this.target.getName());
        double[] chi = RotamerLibrary.measureRotamer((Residue)this.target, (boolean)false);
        HashMap<Integer, BackBondedList> map = this.createBackBondedMap(name);
        double[] wn = new double[chi.length];
        double[] finalChi = new double[chi.length];
        block0: for (int i = 0; i < chi.length; ++i) {
            Torsion tors = map.get((Object)Integer.valueOf((int)i)).torsion;
            TrialSet trialSet = this.expensiveTorsionSet(tors, i, this.testSetSize, "bkn");
            wn[i] = trialSet.sumExtBolt();
            this.Wn = i == 0 ? wn[i] : (this.Wn *= wn[i]);
            this.report.append(String.format(" wn,W running: %.2g %.2g", wn[i], this.Wn));
            logger.info(this.report.toString());
            double rng = this.rand.nextDouble(wn[i]);
            double running = 0.0;
            for (int j = 0; j < trialSet.uExt.length; ++j) {
                double uExtBolt = FastMath.exp((double)(-this.beta * trialSet.uExt[j]));
                if (!(rng < (running += uExtBolt))) continue;
                finalChi[i] = trialSet.theta[j];
                double prob = uExtBolt / wn[i] * 100.0;
                this.report.append(String.format("       Chose %d   %7.4f\t%7.4f\t  %4.1f%%\n", j, trialSet.uExt[j], uExtBolt, prob));
                continue block0;
            }
        }
        this.report.append(String.format("    Wn Total:  %g\n", this.Wn));
        this.proposedMove = this.createRotamer(name, finalChi);
        double[] wo = new double[chi.length];
        for (int i = 0; i < chi.length; ++i) {
            Torsion tors = map.get((Object)Integer.valueOf((int)i)).torsion;
            double ouDep = tors.energy(false);
            double ouExt = this.totalEnergy() - ouDep;
            double ouExtBolt = FastMath.exp((double)(-this.beta * ouExt));
            TrialSet trialSet = this.expensiveTorsionSet(tors, i, this.testSetSize - 1, "bko");
            wo[i] = ouExtBolt + trialSet.sumExtBolt();
            if (i == 0) {
                this.Wo = wo[i];
                continue;
            }
            this.Wo *= wo[i];
        }
        this.report.append(String.format("    Wo Total:  %g\n", this.Wo));
        this.report.append(String.format("    Wn/Wo:     %g\n", this.Wn / this.Wo));
        this.target.revertState(this.origState);
        this.updateAll();
        if (this.verbose) {
            logger.info(this.report.toString());
        }
    }

    private void engageControlAll() {
        this.report.append(String.format(" Rosenbluth Control Move: %4d  %s\n", this.moveNumber, this.target));
        double origEnergy = this.totalEnergy();
        double[] origChi = RotamerLibrary.measureRotamer((Residue)this.target, (boolean)false);
        double[] newChi = new double[origChi.length];
        System.arraycopy(origChi, 0, newChi, 0, origChi.length);
        for (int i = 0; i < origChi.length; ++i) {
            double theta;
            if (!this.doChi[i]) continue;
            newChi[i] = theta = this.rand.nextDouble(360.0) - 180.0;
        }
        this.proposedChis = newChi;
        Rotamer newState = this.createRotamer(this.target, newChi);
        RotamerLibrary.applyRotamer((Residue)this.target, (Rotamer)newState);
        this.finalEnergy = this.totalEnergy();
        if (this.finalEnergy < -10000.0) {
            this.report.append("\nWARNING: Multipole catastrophe in CBMC.\n");
            this.report.append("  Discarding move.\n");
            this.target.revertState(this.origState);
            this.updateAll();
            this.Wn = -1.0;
            this.Wo = 1000.0;
            logger.info(this.report.toString());
        }
        double dU = this.finalEnergy - origEnergy;
        double criterion = FastMath.exp((double)(-this.beta * dU));
        double rng = this.rand.nextDouble();
        this.report.append("    move (thetas):    ");
        for (double value : newChi) {
            this.report.append(String.format("%7.2f ", value));
        }
        this.report.append("\n");
        this.report.append(String.format("    orig, final, dU:  %.2g %.2g %.2g\n", origEnergy, this.finalEnergy, dU));
        this.report.append(String.format("    crit, rng:        %.2g %.2g\n", criterion, rng));
        if (rng < criterion) {
            this.accepted = true;
            this.report.append(String.format(" Accepted! %5d    NewEnergy: %.4f    Chi:", ++numAccepted, this.finalEnergy));
            for (double proposedChi : this.proposedChis) {
                this.report.append(String.format(" %7.2f", proposedChi));
            }
            this.report.append("\n");
            this.updateAll();
            if (!this.noSnaps) {
                PDBFilter pDBFilter = new PDBFilter(this.molecularAssembly.getFile(), this.molecularAssembly, null, null);
                Object filename = this.molecularAssembly.getFile().getAbsolutePath();
                if (!((String)filename).contains("_mc")) {
                    filename = FilenameUtils.removeExtension((String)filename) + "_mc.pdb";
                }
                File file = new File((String)filename);
                pDBFilter.writeFile(file, false);
            }
        } else {
            this.accepted = false;
            this.report.append(String.format(" Denied.   %5d    NewEnergy: %.4f    Chi:", numAccepted, origEnergy));
            for (double v : origChi) {
                this.report.append(String.format(" %7.2f", v));
            }
            this.report.append("\n");
            this.target.revertState(this.origState);
        }
        this.updateAll();
        this.endTime = System.nanoTime();
        double d = (double)(this.endTime - this.startTime) * 1.0E-6;
        if (this.logTimings) {
            this.report.append(String.format("   Timing (ms): %.2f", d));
        }
        logger.info(this.report.toString());
    }

    boolean wasAccepted() {
        return this.accepted;
    }

    private Rotamer createRotamer(AminoAcidUtils.AminoAcid3 name, double[] chi) {
        double[] values = new double[chi.length * 2];
        for (int k = 0; k < chi.length; ++k) {
            int kk = 2 * k;
            values[kk] = chi[k];
            values[kk + 1] = 0.0;
        }
        return new Rotamer(name, values);
    }

    private Rotamer createRotamer(Residue res, double[] chi) {
        return this.createRotamer(AminoAcidUtils.AminoAcid3.valueOf((String)res.getName()), chi);
    }

    private void updateAll() {
        this.updateBonds();
        this.updateAngles();
        this.updateTorsions();
    }

    private void updateBonds() {
        for (Bond bond : this.target.getBondList()) {
            bond.update();
        }
    }

    private void updateAngles() {
        for (Angle angle : this.target.getAngleList()) {
            angle.update();
        }
    }

    private void updateTorsions() {
        for (Torsion torsion : this.target.getTorsionList()) {
            torsion.update();
        }
    }

    private double totalEnergy() {
        double[] x = new double[this.forceFieldEnergy.getNumberOfVariables() * 3];
        this.forceFieldEnergy.setEnergyTermState(Potential.STATE.BOTH);
        this.forceFieldEnergy.getCoordinates(x);
        return this.forceFieldEnergy.energy(false, this.verboseEnergies);
    }

    private HashMap<Integer, BackBondedList> createBackBondedMap(AminoAcidUtils.AminoAcid3 name) {
        HashMap<Integer, BackBondedList> map = new HashMap<Integer, BackBondedList>();
        ArrayList<Object> chain = new ArrayList<Object>();
        Atom N = (Atom)this.target.getAtomNode("N");
        Atom CA = (Atom)this.target.getAtomNode("CA");
        Atom CB = (Atom)this.target.getAtomNode("CB");
        ArrayList<Atom> keyAtoms = new ArrayList<Atom>();
        switch (name) {
            case VAL: {
                Atom CG1 = (Atom)this.target.getAtomNode("CG1");
                keyAtoms.add(CG1);
                keyAtoms.add(CB);
                break;
            }
            case LEU: {
                Atom CG = (Atom)this.target.getAtomNode("CG");
                Atom CD1 = (Atom)this.target.getAtomNode("CD1");
                keyAtoms.add(CG);
                keyAtoms.add(CD1);
                break;
            }
            case ILE: {
                Atom CD1 = (Atom)this.target.getAtomNode("CD1");
                Atom CG1 = (Atom)this.target.getAtomNode("CG1");
                keyAtoms.add(CD1);
                keyAtoms.add(CG1);
                break;
            }
            case SER: {
                Atom OG = (Atom)this.target.getAtomNode("OG");
                Atom HG = (Atom)this.target.getAtomNode("HG");
                keyAtoms.add(OG);
                keyAtoms.add(HG);
                break;
            }
            case THR: {
                Atom OG1 = (Atom)this.target.getAtomNode("OG1");
                Atom HG1 = (Atom)this.target.getAtomNode("HG1");
                keyAtoms.add(OG1);
                keyAtoms.add(HG1);
                break;
            }
            case CYX: 
            case CYD: {
                Atom SG = (Atom)this.target.getAtomNode("SG");
                keyAtoms.add(SG);
                break;
            }
            case PHE: {
                Atom CD1 = (Atom)this.target.getAtomNode("CD1");
                Atom CG = (Atom)this.target.getAtomNode("CG");
                keyAtoms.add(CG);
                break;
            }
            case PRO: {
                Atom CD = (Atom)this.target.getAtomNode("CD");
                Atom CG = (Atom)this.target.getAtomNode("CG");
                keyAtoms.add(CG);
                keyAtoms.add(CD);
                break;
            }
            case TYR: {
                Atom CD1 = (Atom)this.target.getAtomNode("CD1");
                Atom CE2 = (Atom)this.target.getAtomNode("CE2");
                Atom CG = (Atom)this.target.getAtomNode("CG");
                Atom CZ = (Atom)this.target.getAtomNode("CZ");
                Atom OH = (Atom)this.target.getAtomNode("OH");
                Atom HH = (Atom)this.target.getAtomNode("HH");
                Bond b1 = CG.getBond(CB);
                Angle a1 = CG.getAngle(CB, CA);
                Torsion t1 = CG.getTorsion(CB, CA, N);
                Bond b2 = CD1.getBond(CG);
                Angle a2 = CD1.getAngle(CG, CB);
                Torsion t2 = CD1.getTorsion(CG, CB, CA);
                Bond b3 = HH.getBond(OH);
                Angle a3 = HH.getAngle(OH, CZ);
                Torsion t3 = HH.getTorsion(OH, CZ, CE2);
                BackBondedList bbl1 = new BackBondedList(b1, a1, t1);
                BackBondedList bbl2 = new BackBondedList(b2, a2, t2);
                BackBondedList bbl3 = new BackBondedList(b3, a3, t3);
                map.put(0, bbl1);
                map.put(1, bbl2);
                map.put(2, bbl3);
                return map;
            }
            case TYD: 
            case TRP: {
                Atom CD1 = (Atom)this.target.getAtomNode("CD1");
                Atom CG = (Atom)this.target.getAtomNode("CG");
                keyAtoms.add(CG);
                keyAtoms.add(CD1);
                break;
            }
            case HIS: 
            case HID: 
            case HIE: {
                Atom CG = (Atom)this.target.getAtomNode("CG");
                Atom ND1 = (Atom)this.target.getAtomNode("ND1");
                keyAtoms.add(CG);
                keyAtoms.add(ND1);
                break;
            }
            case ASP: {
                Atom CG = (Atom)this.target.getAtomNode("CG");
                keyAtoms.add(CG);
                break;
            }
            case ASH: 
            case ASN: {
                Atom CG = (Atom)this.target.getAtomNode("CG");
                Atom OD1 = (Atom)this.target.getAtomNode("OD1");
                keyAtoms.add(CG);
                keyAtoms.add(OD1);
                break;
            }
            case GLU: 
            case GLH: 
            case GLN: {
                Atom CG = (Atom)this.target.getAtomNode("CG");
                Atom CD = (Atom)this.target.getAtomNode("CD");
                Atom OE1 = (Atom)this.target.getAtomNode("OE1");
                keyAtoms.add(CG);
                keyAtoms.add(CD);
                keyAtoms.add(OE1);
                break;
            }
            case MET: {
                Atom CG = (Atom)this.target.getAtomNode("CG");
                Atom CE = (Atom)this.target.getAtomNode("CE");
                Atom SD = (Atom)this.target.getAtomNode("SD");
                keyAtoms.add(CG);
                keyAtoms.add(SD);
                keyAtoms.add(CE);
                break;
            }
            case LYS: 
            case LYD: {
                Atom CD = (Atom)this.target.getAtomNode("CD");
                Atom CE = (Atom)this.target.getAtomNode("CE");
                Atom CG = (Atom)this.target.getAtomNode("CG");
                Atom NZ = (Atom)this.target.getAtomNode("NZ");
                keyAtoms.add(CG);
                keyAtoms.add(CD);
                keyAtoms.add(CE);
                keyAtoms.add(NZ);
                break;
            }
            case ARG: {
                Atom CD = (Atom)this.target.getAtomNode("CD");
                Atom CG = (Atom)this.target.getAtomNode("CG");
                Atom CZ = (Atom)this.target.getAtomNode("CZ");
                Atom NE = (Atom)this.target.getAtomNode("NE");
                keyAtoms.add(CG);
                keyAtoms.add(CD);
                keyAtoms.add(NE);
                keyAtoms.add(CZ);
                break;
            }
            default: {
                logger.severe(String.format("CBMC called on unsupported residue: %s", name));
            }
        }
        chain.add(N);
        chain.add(CA);
        chain.add(CB);
        chain.addAll(keyAtoms);
        for (int i = 3; i < chain.size(); ++i) {
            Atom key = (Atom)chain.get(i);
            Bond bond = key.getBond((Atom)chain.get(i - 1));
            Angle angle = key.getAngle((Atom)chain.get(i - 1), (Atom)chain.get(i - 2));
            Torsion torsion = key.getTorsion((Atom)chain.get(i - 1), (Atom)chain.get(i - 2), (Atom)chain.get(i - 3));
            BackBondedList bbl = new BackBondedList(bond, angle, torsion);
            map.put(i - 3, bbl);
        }
        return map;
    }

    private void writeSnapshot(String suffix, boolean append) {
        if (this.snapshotWriter != null && !this.noSnaps) {
            this.snapshotWriter.write(suffix, append);
        }
    }

    private void torsionSampler(List<Torsion> allTors) {
        this.updateAll();
        double[] origChi = this.measureLysine(this.target, false);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(" Torsion Sampling for %s\n", this.target.getName()));
        sb.append("   origChi:");
        for (double value : origChi) {
            sb.append(String.format(" %6.2f", value));
        }
        sb.append("\n");
        for (int k = 0; k < origChi.length; ++k) {
            Torsion tors = allTors.get(k);
            AtomType type1 = tors.getAtomArray()[0].getAtomType();
            AtomType type2 = tors.getAtomArray()[1].getAtomType();
            AtomType type3 = tors.getAtomArray()[2].getAtomType();
            AtomType type4 = tors.getAtomArray()[3].getAtomType();
            sb.append(String.format("   %d:    \"(%3d %3d %3s)  (%3d %3d %3s)  (%3d %3d %3s)  (%3d %3d %3s)\"\n", k, type1.type, type1.atomClass, type1.name, type2.type, type2.atomClass, type2.name, type3.type, type3.atomClass, type3.name, type4.type, type4.atomClass, type4.name));
        }
        logger.info(sb.toString());
        sb = new StringBuilder();
        sb.append(" Resi chi0 chi1 chi2 chi3 List<uTors> uTorsSum uTotal\n");
        logger.info(sb.toString());
        sb = new StringBuilder();
        boolean doChi0 = false;
        boolean doChi1 = false;
        boolean doChi2 = true;
        boolean doChi3 = true;
        double increment = 1.0;
        for (double chi0 = -180.0; chi0 < 180.0; chi0 += increment) {
            for (double chi1 = -180.0; chi1 <= 180.0; chi1 += increment) {
                for (double chi2 = -180.0; chi2 <= 180.0; chi2 += increment) {
                    for (double chi3 = -180.0; chi3 <= 180.0; chi3 += increment) {
                        sb.append(String.format(" %3s", this.target.getName()));
                        double[] newChi = new double[]{doChi0 ? chi0 : origChi[0], doChi1 ? chi1 : origChi[1], doChi2 ? chi2 : origChi[2], doChi3 ? chi3 : origChi[3]};
                        Rotamer newState = this.createRotamer(this.target, newChi);
                        RotamerLibrary.applyRotamer((Residue)this.target, (Rotamer)newState);
                        for (int wut = 0; wut < origChi.length; ++wut) {
                            sb.append(String.format(" %3.0f", newChi[wut]));
                        }
                        this.writeSnapshot(String.format("%.0f", chi1), false);
                        double uTorsSum = 0.0;
                        for (Torsion allTor : allTors) {
                            double uTors = allTor.energy(false);
                            sb.append(String.format(" %5.2f", uTors));
                            uTorsSum += uTors;
                        }
                        sb.append(String.format(" %5.2f", uTorsSum));
                        double totalE = 1000.0;
                        try {
                            totalE = this.totalEnergy();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (totalE > 1000.0) {
                            totalE = 1000.0;
                        }
                        sb.append(String.format(" %10.4f", totalE));
                        sb.append("\n");
                        logger.info(sb.toString());
                        sb = new StringBuilder();
                        if (!doChi3) break;
                    }
                    if (!doChi2) break;
                }
                if (!doChi1) break;
            }
            if (!doChi0) break;
        }
        if (this.torsionSampling) {
            try {
                File output = new File("torsionSampler.log");
                BufferedWriter bw = new BufferedWriter(new FileWriter(output));
                bw.write(sb.toString());
                bw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.exit(0);
    }

    private double[] measureLysine(Residue residue, boolean print) {
        if (!residue.getName().contains("LY") || residue.getAminoAcid3() != AminoAcidUtils.AminoAcid3.LYS && residue.getAminoAcid3() != AminoAcidUtils.AminoAcid3.LYD) {
            logger.severe("Yeah that ain't a lysine.");
        }
        double[] chi = new double[4];
        List torsions = residue.getTorsionList();
        Atom N = (Atom)residue.getAtomNode("N");
        Atom CA = (Atom)residue.getAtomNode("CA");
        Atom CB = (Atom)residue.getAtomNode("CB");
        Atom CD = (Atom)residue.getAtomNode("CD");
        Atom CE = (Atom)residue.getAtomNode("CE");
        Atom CG = (Atom)residue.getAtomNode("CG");
        Atom NZ = (Atom)residue.getAtomNode("NZ");
        logger.info(String.format(" Here's the atoms I found: \n%s\n%s\n%s\n%s\n%s\n%s\n%s", N, CA, CB, CD, CE, CG, NZ));
        logger.info(String.format(" Num torsions: %d", torsions.size()));
        int count = 0;
        for (Torsion torsion : torsions) {
            torsion.energy(false);
            logger.info(String.format(" Torsion numba %d: %s", count++, torsion));
            if (torsion.compare(N, CA, CB, CG)) {
                chi[0] = torsion.getValue();
                if (print) {
                    logger.info(torsion.toString());
                }
            }
            if (torsion.compare(CA, CB, CG, CD)) {
                chi[1] = torsion.getValue();
                if (print) {
                    logger.info(torsion.toString());
                }
            }
            if (torsion.compare(CB, CG, CD, CE)) {
                chi[2] = torsion.getValue();
                if (print) {
                    logger.info(torsion.toString());
                }
            }
            if (!torsion.compare(CG, CD, CE, NZ)) continue;
            chi[3] = torsion.getValue();
            if (!print) continue;
            logger.info(torsion.toString());
        }
        return chi;
    }

    private class SnapshotWriter {
        private final MolecularAssembly mola;
        private final PDBFilter filter;
        private final boolean interleaving;
        final /* synthetic */ RosenbluthChiAllMove this$0;

        private SnapshotWriter(RosenbluthChiAllMove rosenbluthChiAllMove, MolecularAssembly mola, boolean interleaving) {
            RosenbluthChiAllMove rosenbluthChiAllMove2 = rosenbluthChiAllMove;
            Objects.requireNonNull(rosenbluthChiAllMove2);
            this.this$0 = rosenbluthChiAllMove2;
            this.mola = mola;
            this.interleaving = interleaving;
            this.filter = new PDBFilter(mola.getFile(), mola, null, null);
            this.filter.setLogWrites(false);
        }

        private void write(String suffix, boolean append) {
            Object filename = FilenameUtils.removeExtension((String)this.mola.getFile().toString()) + "." + suffix + "-" + this.this$0.moveNumber;
            if (this.interleaving && !((String)(filename = this.mola.getFile().getAbsolutePath())).contains("dyn")) {
                filename = FilenameUtils.removeExtension((String)filename) + "_dyn.pdb";
            }
            File file = new File((String)filename);
            this.filter.setLogWrites(false);
            this.filter.writeFile(file, append);
        }
    }

    public static enum MODE {
        EXPENSIVE,
        CHEAP,
        CTRL_ALL;

    }

    private static class BackBondedList {
        public final Bond bond;
        public final Angle angle;
        public final Torsion torsion;

        public BackBondedList(Bond bond, Angle angle, Torsion tors) {
            this.bond = bond;
            this.angle = angle;
            this.torsion = tors;
        }
    }

    private class TrialSet {
        public final Rotamer[] rotamer;
        public final double[] uDep;
        public final double[] uExt;
        public final double[] theta;
        final /* synthetic */ RosenbluthChiAllMove this$0;

        public TrialSet(RosenbluthChiAllMove rosenbluthChiAllMove, int setSize) {
            RosenbluthChiAllMove rosenbluthChiAllMove2 = rosenbluthChiAllMove;
            Objects.requireNonNull(rosenbluthChiAllMove2);
            this.this$0 = rosenbluthChiAllMove2;
            this.rotamer = new Rotamer[setSize];
            this.uDep = new double[setSize];
            this.uExt = new double[setSize];
            this.theta = new double[setSize];
        }

        public double prodExtBolt() {
            double prod = 0.0;
            for (double v : this.uExt) {
                prod *= FastMath.exp((double)(-this.this$0.beta * v));
            }
            return prod;
        }

        public double sumExtBolt() {
            double sum = 0.0;
            for (double v : this.uExt) {
                sum += FastMath.exp((double)(-this.this$0.beta * v));
            }
            return sum;
        }
    }

    private static enum TORSION_OFFSET_AMPRO13 {
        LYS0(1.61),
        LYD0(1.61),
        LYS1(0.939033),
        LYD1(0.939033),
        LYS2(1.0),
        LYD2(1.0),
        LYS3(0.8),
        LYD3(0.8);

        public final double offset;

        private TORSION_OFFSET_AMPRO13(double offset) {
            this.offset = offset;
        }
    }
}

