/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.mc;

import ffx.algorithms.mc.MCMove;
import ffx.algorithms.mc.MetropolisMC;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public abstract class BoltzmannMC
implements MetropolisMC {
    private static final Logger logger = Logger.getLogger(BoltzmannMC.class.getName());
    protected final Random random = new Random();
    private double temperature = 298.15;
    private double invKBT = 1.0 / (0.0019872042586408316 * this.temperature);
    private boolean print = true;
    private double e1 = 0.0;
    private double e2 = 0.0;
    private double lastE = 0.0;
    private boolean lastAccept = false;

    public static double acceptChance(double invKT, double e1, double e2) {
        double dE = e2 - e1;
        return FastMath.min((double)FastMath.exp((double)(-invKT * dE)), (double)1.0);
    }

    public static boolean evaluateMove(Random random, double invKT, double e1, double e2) {
        boolean e1Finite = Double.isFinite(e1);
        boolean e2Finite = Double.isFinite(e2);
        if (!e1Finite && !e2Finite) {
            throw new IllegalArgumentException(String.format(" Attempting to evaluate move with non-finite energies %f and %f!", e1, e2));
        }
        if (!e1Finite) {
            throw new IllegalArgumentException(String.format(" Attempting to evaluate move from non-finite %f to finite %.4f!", e1, e2));
        }
        if (!e2Finite) {
            throw new IllegalArgumentException(String.format(" Attempting to evaluate move from finite %.4f to non-finite %.4f!", e1, e2));
        }
        if (e2 <= e1) {
            return true;
        }
        double prob = BoltzmannMC.acceptChance(invKT, e1, e2);
        assert (prob >= 0.0 && prob <= 1.0) : "The probability of an MC move up in energy should be between [0 ..1].";
        double trial = random.nextDouble();
        return trial <= prob;
    }

    @Override
    public boolean evaluateMove(double e1, double e2) {
        return BoltzmannMC.evaluateMove(this.random, this.invKBT, e1, e2);
    }

    @Override
    public boolean getAccept() {
        return this.lastAccept;
    }

    @Override
    public double getE1() {
        return this.e1;
    }

    @Override
    public double getE2() {
        return this.e2;
    }

    @Override
    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(double temp) {
        this.temperature = temp;
        this.invKBT = 1.0 / (0.0019872042586408316 * this.temperature);
    }

    @Override
    public double lastEnergy() {
        return this.lastE;
    }

    @Override
    public boolean mcStep(MCMove move) {
        return this.mcStep(move, this.currentEnergy());
    }

    @Override
    public boolean mcStep(MCMove move, double en1) {
        ArrayList<MCMove> moveList = new ArrayList<MCMove>(1);
        moveList.add(move);
        return this.mcStep(moveList, en1);
    }

    @Override
    public boolean mcStep(List<MCMove> moves) {
        return this.mcStep(moves, this.currentEnergy());
    }

    @Override
    public boolean mcStep(List<MCMove> moves, double en1) {
        this.storeState();
        this.e1 = en1;
        int nMoves = moves.size();
        for (MCMove move : moves) {
            move.move();
        }
        this.e2 = this.lastE = this.currentEnergy();
        if (this.evaluateMove(this.e1, this.e2)) {
            this.lastAccept = true;
            if (this.print) {
                logger.info(String.format(" Monte Carlo step accepted: e1 -> e2 %10.6f -> %10.6f", this.e1, this.e2));
            }
            return true;
        }
        this.lastAccept = false;
        for (int i = nMoves - 1; i >= 0; --i) {
            moves.get(i).revertMove();
        }
        this.lastE = this.e1;
        if (this.print) {
            logger.info(String.format(" Monte Carlo step rejected: e1 -> e2 %10.6f -> %10.6f", this.e1, this.e2));
        }
        return false;
    }

    @Override
    public void setPrint(boolean print) {
        this.print = print;
    }

    protected void setRandomSeed(int randomSeed) {
        this.random.setSeed(randomSeed);
    }

    protected abstract double currentEnergy();

    protected abstract void storeState();
}

