/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.dynamics;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.pj.Comm;
import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.Terminatable;
import ffx.algorithms.dynamics.MolecularDynamics;
import java.io.IOException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class ReplicaExchange
implements Terminatable {
    private static final Logger logger = Logger.getLogger(ReplicaExchange.class.getName());
    private final int nReplicas;
    private final Random random;
    private final Comm world;
    private final int rank;
    private final double[][] parameters;
    private final DoubleBuf[] parametersBuf;
    private final MolecularDynamics replica;
    private boolean done = false;
    private boolean terminate = false;
    private final double[] myParameters;
    private final DoubleBuf myParametersBuf;
    private final int[] temp2Rank;
    private final int[] rank2Temp;
    private double[] temperatures;
    private final int[] tempAcceptedCount;
    private final int[] rankAcceptedCount;
    private final int[] tempTrialCount;
    boolean monteCarlo;

    public ReplicaExchange(MolecularDynamics molecularDynamics, AlgorithmListener listener, double temperature, double exponent, boolean monteCarlo) {
        this.replica = molecularDynamics;
        this.monteCarlo = monteCarlo;
        this.world = Comm.world();
        int numProc = this.world.size();
        this.rank = this.world.rank();
        this.nReplicas = numProc;
        this.temperatures = new double[this.nReplicas];
        this.temp2Rank = new int[this.nReplicas];
        this.rank2Temp = new int[this.nReplicas];
        this.tempAcceptedCount = new int[this.nReplicas];
        this.rankAcceptedCount = new int[this.nReplicas];
        this.tempTrialCount = new int[this.nReplicas];
        this.setExponentialTemperatureLadder(temperature, exponent);
        this.random = new Random();
        this.random.setSeed(0L);
        this.parameters = new double[this.nReplicas][2];
        this.parametersBuf = new DoubleBuf[this.nReplicas];
        for (int i = 0; i < this.nReplicas; ++i) {
            this.parametersBuf[i] = DoubleBuf.buffer((double[])this.parameters[i]);
        }
        this.myParameters = this.parameters[this.rank];
        this.myParametersBuf = this.parametersBuf[this.rank];
    }

    public void sample(int cycles, long nSteps, double timeStep, double printInterval, double saveInterval) {
        this.done = false;
        this.terminate = false;
        for (int i = 0; i < cycles; ++i) {
            if (this.terminate) {
                this.done = true;
                break;
            }
            this.dynamic(nSteps, timeStep, printInterval, saveInterval);
            logger.info(String.format(" Applying exchange condition for cycle %d.", i));
            this.exchange(i);
        }
    }

    public void setExponentialTemperatureLadder(double lowTemperature, double exponent) {
        for (int i = 0; i < this.nReplicas; ++i) {
            this.temperatures[i] = lowTemperature * FastMath.exp((double)(exponent * (double)i));
            this.temp2Rank[i] = i;
            this.rank2Temp[i] = i;
        }
    }

    public void setTemperatures(double[] temperatures) {
        assert (temperatures.length == this.nReplicas);
        this.temperatures = temperatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        this.terminate = true;
        while (!this.done) {
            ReplicaExchange replicaExchange = this;
            synchronized (replicaExchange) {
                try {
                    this.wait(1L);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Exception terminating replica exchange.\n", e);
                }
            }
        }
    }

    private void exchange(int cycle) {
        int increment;
        if (this.monteCarlo) {
            start = cycle % 2;
            increment = 2;
        } else {
            start = 0;
            increment = 1;
        }
        for (int temperature = start; temperature < this.nReplicas - 1; temperature += increment) {
            double rankAcceptance;
            double tempAcceptance;
            int rankA = this.temp2Rank[temperature];
            int rankB = this.temp2Rank[temperature + 1];
            double tempA = this.parameters[rankA][0];
            double tempB = this.parameters[rankB][0];
            double betaA = 418.4 / (tempA * 0.831446261815324);
            double betaB = 418.4 / (tempB * 0.831446261815324);
            double energyA = this.parameters[rankA][1];
            double energyB = this.parameters[rankB][1];
            double deltaE = (energyA - energyB) * (betaB - betaA);
            int n = temperature;
            this.tempTrialCount[n] = this.tempTrialCount[n] + 1;
            if (deltaE < 0.0 || this.random.nextDouble() < FastMath.exp((double)(-deltaE))) {
                int n2 = temperature;
                this.tempAcceptedCount[n2] = this.tempAcceptedCount[n2] + 1;
                tempAcceptance = (double)this.tempAcceptedCount[temperature] * 100.0 / (double)this.tempTrialCount[temperature];
                if (tempA < tempB) {
                    int n3 = rankA;
                    this.rankAcceptedCount[n3] = this.rankAcceptedCount[n3] + 1;
                    rankAcceptance = (double)this.rankAcceptedCount[rankA] * 100.0 / (double)this.tempTrialCount[temperature];
                } else {
                    int n4 = rankB;
                    this.rankAcceptedCount[n4] = this.rankAcceptedCount[n4] + 1;
                    rankAcceptance = (double)this.rankAcceptedCount[rankB] * 100.0 / (double)this.tempTrialCount[temperature + 1];
                }
                this.parameters[rankA][0] = tempB;
                this.parameters[rankB][0] = tempA;
                this.parameters[rankA][1] = energyB;
                this.parameters[rankB][1] = energyA;
                this.temp2Rank[temperature] = rankB;
                this.temp2Rank[temperature + 1] = rankA;
                this.rank2Temp[rankA] = temperature + 1;
                this.rank2Temp[rankB] = temperature;
                logger.info(String.format(" RepEx accepted (%5.1f%%) (%5.1f%%) for %6.2f (%d) and %6.2f (%d) for dE=%10.4f.", tempAcceptance, rankAcceptance, tempA, rankA, tempB, rankB, deltaE));
                continue;
            }
            tempAcceptance = (double)this.tempAcceptedCount[temperature] * 100.0 / (double)this.tempTrialCount[temperature];
            rankAcceptance = (double)this.rankAcceptedCount[temperature] * 100.0 / (double)this.tempTrialCount[temperature];
            logger.info(String.format(" RepEx rejected (%5.1f%%) (f%5.1f%%) for %6.2f (%d) and %6.2f (%d) for dE=%10.4f.", tempAcceptance, rankAcceptance, tempA, rankA, tempB, rankB, deltaE));
        }
    }

    private void dynamic(long nSteps, double timeStep, double printInterval, double saveInterval) {
        int i = this.rank2Temp[this.rank];
        boolean initVelocities = true;
        this.replica.dynamic(nSteps, timeStep, printInterval, saveInterval, this.temperatures[i], initVelocities, null);
        this.myParameters[0] = this.temperatures[i];
        this.myParameters[1] = this.replica.state.getPotentialEnergy();
        try {
            this.world.allGather((Buf)this.myParametersBuf, (Buf[])this.parametersBuf);
        }
        catch (IOException ex) {
            String message = " Replica Exchange allGather failed.";
            logger.log(Level.SEVERE, message, ex);
        }
    }
}

