/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands.test;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.cli.LambdaParticleOptions;
import ffx.algorithms.cli.MultiDynamicsOptions;
import ffx.algorithms.cli.OSTOptions;
import ffx.algorithms.cli.ThermodynamicsOptions;
import ffx.algorithms.thermodynamics.OrthogonalSpaceTempering;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.cli.AlchemicalOptions;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.cli.GradientOptions;
import ffx.potential.utils.GradientUtils;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" OSTGradient script tests the Orthogonal Space Tempering Potential."}, name="test.OSTGradient")
public class OSTGradient
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Mixin
    private GradientOptions gradientOptions;
    @CommandLine.Mixin
    private AlchemicalOptions alchemicalOptions;
    @CommandLine.Option(names={"--meta", "--metaDynamics"}, defaultValue="false", description={"Use a 1D metadynamics style bias."})
    private boolean metaDynamics;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"XYZ or PDB input file."})
    private String filename;
    private OrthogonalSpaceTempering orthogonalSpaceTempering;
    private File saveDir = null;
    public double dUdLError = 0.0;
    public int nFailures = 0;

    public OSTGradient() {
    }

    public OSTGradient(FFXBinding binding) {
        super(binding);
    }

    public OSTGradient(String[] args) {
        super(args);
    }

    public OSTGradient run() {
        if (!this.init()) {
            return this;
        }
        System.setProperty("lambdaterm", "true");
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        File structureFile = this.activeAssembly.getFile();
        this.filename = structureFile.getAbsolutePath();
        logger.info("\n Evaluating OST Gradient for " + this.filename);
        String baseFilename = FilenameUtils.removeExtension((String)this.filename);
        File histogramRestart = new File(baseFilename + ".his");
        File lambdaRestart = null;
        if (!histogramRestart.exists()) {
            logger.warning("\n Histogram restart file does not exist: " + histogramRestart.toString());
        } else if (!histogramRestart.canRead()) {
            logger.warning("\n Histogram restart file can not be read." + histogramRestart.toString());
        }
        ForceFieldEnergy energy = this.activeAssembly.getPotentialEnergy();
        if (!(this.saveDir != null && this.saveDir.exists() && this.saveDir.isDirectory() && this.saveDir.canWrite())) {
            this.saveDir = new File(FilenameUtils.getFullPath((String)this.filename));
        }
        DynamicsOptions dynamicsOptions = new DynamicsOptions();
        LambdaParticleOptions lambdaParticleOptions = new LambdaParticleOptions();
        MultiDynamicsOptions multiDynamicsOptions = new MultiDynamicsOptions();
        ThermodynamicsOptions thermodynamicsOptions = new ThermodynamicsOptions();
        OSTOptions ostOptions = new OSTOptions();
        ostOptions.setMetaDynamics(this.metaDynamics);
        this.orthogonalSpaceTempering = ostOptions.constructOST((CrystalPotential)energy, lambdaRestart, histogramRestart, this.activeAssembly, null, dynamicsOptions, thermodynamicsOptions, lambdaParticleOptions, null, !multiDynamicsOptions.isSynchronous());
        double lambda = this.alchemicalOptions.getInitialLambda(false);
        logger.info("\n Lambda value: " + lambda);
        this.alchemicalOptions.setFirstSystemAlchemistry(this.activeAssembly);
        this.alchemicalOptions.setFirstSystemUnchargedAtoms(this.activeAssembly);
        this.atomSelectionOptions.setActiveAtoms(this.activeAssembly);
        this.orthogonalSpaceTempering.setPropagateLambda(false);
        this.orthogonalSpaceTempering.setLambda(lambda);
        int n = this.orthogonalSpaceTempering.getNumberOfVariables();
        if (n % 3 != 0) {
            throw new IllegalStateException("Number of variables must be divisible by 3, got: " + n);
        }
        double[] x = new double[3 * (n /= 3)];
        this.orthogonalSpaceTempering.getCoordinates(x);
        double[] g = new double[3 * n];
        double e = this.orthogonalSpaceTempering.energyAndGradient(x, g);
        double dEdLambda = this.orthogonalSpaceTempering.getTotaldEdLambda();
        double step = this.gradientOptions.getDx();
        this.orthogonalSpaceTempering.setLambda(lambda + step);
        double lp = this.orthogonalSpaceTempering.energy(x);
        this.orthogonalSpaceTempering.setLambda(lambda - step);
        double lm = this.orthogonalSpaceTempering.energy(x);
        double dedl = (lp - lm) / (2.0 * step);
        logger.info(String.format(" Analytic dE/dL:   %15.8f", dEdLambda));
        logger.info(String.format(" Numeric  dE/dL:   %15.8f\n", dedl));
        this.dUdLError = Math.abs(dEdLambda - dedl);
        this.orthogonalSpaceTempering.setLambda(lambda);
        GradientUtils gradientUtils = new GradientUtils((Potential)this.orthogonalSpaceTempering);
        this.nFailures = gradientUtils.testGradient(this.gradientOptions);
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        List<Object> potentials = this.orthogonalSpaceTempering == null ? Collections.emptyList() : Collections.singletonList(this.orthogonalSpaceTempering);
        return potentials;
    }
}

