/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands.test;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.BarostatOptions;
import ffx.algorithms.thermodynamics.HistogramData;
import ffx.crystal.CrystalPotential;
import ffx.numerics.estimator.BennettAcceptanceRatio;
import ffx.numerics.estimator.BootstrappableEstimator;
import ffx.numerics.estimator.EstimateBootstrapper;
import ffx.numerics.estimator.Zwanzig;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.cli.AlchemicalOptions;
import ffx.potential.cli.TopologyOptions;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.utils.PotentialsFunctions;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import java.util.logging.Level;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.util.FastMath;
import picocli.CommandLine;

@CommandLine.Command(description={" Evaluates free energy of an M-OST run using the BAR estimator."}, name="test.MostBar")
public class MostBar
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private AlchemicalOptions alchemicalOptions;
    @CommandLine.Mixin
    private TopologyOptions topologyOptions;
    @CommandLine.Mixin
    private BarostatOptions barostat;
    @CommandLine.Option(names={"-t", "--temperature"}, paramLabel="298.15", defaultValue="298.15", description={"Temperature in Kelvins"})
    private double temp;
    @CommandLine.Option(names={"--his", "--histogram"}, paramLabel="file.his", defaultValue="", description={"Manually provided path to a histogram file (otherwise, attempts to autodetect from same directory as input files)."})
    private String histogramName;
    @CommandLine.Option(names={"--lb", "--lambdaBins"}, paramLabel="autodetected", defaultValue="-1", description={"Manually specified number of lambda bins (else auto-detected from histogram"})
    private int lamBins;
    @CommandLine.Option(names={"-s", "--start"}, paramLabel="1", defaultValue="1", description={"First snapshot to evaluate (1-indexed, inclusive)."})
    private int startFrame;
    @CommandLine.Option(names={"--fi", "--final"}, paramLabel="-1", defaultValue="-1", description={"Last snapshot to evaluate (1-indexed, inclusive); leave negative to analyze to end of trajectory."})
    private int finalFrame;
    @CommandLine.Option(names={"--st", "--stride"}, paramLabel="1", defaultValue="1", description={"First snapshot to evaluate (1-indexed)."})
    private int stride;
    @CommandLine.Option(names={"--bo", "--bootstrap"}, paramLabel="AUTO", defaultValue="-1", description={"Use this many bootstrap trials to estimate dG and uncertainty; default is 200-100000 (depending on number of frames)."})
    private long bootstrap;
    @CommandLine.Option(names={"--lambdaSorted"}, paramLabel="false", defaultValue="false", description={"Input is sorted by lambda rather than simulation progress (sets -s to skip N-1 frames at each lambda value rather than N-1 of all frames)."})
    private boolean lambdaSorted;
    @CommandLine.Option(names={"-v", "--verbose"}, paramLabel="false", defaultValue="false", description={"Print out extra information (e.g. collection of potential energies)."})
    private boolean verbose;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"Trajectory files for the first end of the window, followed by trajectories for the other end"})
    private List<String> filenames;
    private MolecularAssembly[] topologies;
    private SystemFilter[] openers;
    private CrystalPotential potential;
    private LambdaInterface linter;
    private Configuration additionalProperties;
    private List<List<Double>> energiesL;
    private List<List<Double>> energiesUp;
    private List<List<Double>> energiesDown;
    private double[] lamPoints;
    private int[] observations;
    private double lamSep;
    private double halfLamSep;
    private double[] x;
    private final double[] lastEntries = new double[3];
    private static final String energyFormat = "%11.4f kcal/mol";
    private static final String nanFormat = String.format("%20s", "N/A");
    private int start;
    private int end;
    private Level standardLogging = Level.FINE;
    private static final long BOOTSTRAP_PRINT = 50L;
    private static final long MIN_BOOTSTRAP_TRIALS = 200L;
    private static final long MAX_BOOTSTRAP_TRIALS = 50000L;
    private static final long AUTO_BOOTSTRAP_NUMERATOR = 10000000L;

    public void setProperties(CompositeConfiguration addedProperties) {
        this.additionalProperties = addedProperties;
    }

    public MostBar() {
    }

    public MostBar(FFXBinding binding) {
        super(binding);
    }

    public MostBar(String[] args) {
        super(args);
    }

    public MostBar run() {
        int i;
        if (!this.init()) {
            return this;
        }
        int numTopologies = this.topologyOptions.getNumberOfTopologies(this.filenames);
        int threadsPerTopology = this.topologyOptions.getThreadsPerTopology(numTopologies);
        this.topologies = new MolecularAssembly[numTopologies];
        this.openers = new SystemFilter[numTopologies];
        this.alchemicalOptions.setAlchemicalProperties();
        this.topologyOptions.setAlchemicalProperties(numTopologies);
        this.standardLogging = this.verbose ? Level.INFO : Level.FINE;
        logger.info(String.format(" Initializing %d topologies", numTopologies));
        if (this.filenames == null || this.filenames.isEmpty()) {
            this.activeAssembly = this.getActiveAssembly(null);
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.filenames = new ArrayList<String>();
            this.filenames.add(this.activeAssembly.getFile().getName());
            this.topologies[0] = this.alchemicalOptions.processFile(this.topologyOptions, this.activeAssembly, 0);
        } else {
            logger.info(String.format(" Initializing %d topologies...", numTopologies));
            for (int i2 = 0; i2 < numTopologies; ++i2) {
                this.topologies[i2] = this.alchemicalOptions.openFile((PotentialsFunctions)this.algorithmFunctions, this.topologyOptions, threadsPerTopology, this.filenames.get(i2), i2);
                this.openers[i2] = this.algorithmFunctions.getFilter();
            }
        }
        StringBuilder sb = new StringBuilder("\n Using BAR to analyze an M-OST free energy change for systems ");
        this.potential = (CrystalPotential)this.topologyOptions.assemblePotential(this.topologies, sb);
        this.potential = this.barostat.checkNPT(this.topologies[0], this.potential);
        this.linter = (LambdaInterface)this.potential;
        logger.info(sb.toString());
        int nSnapshots = this.openers[0].countNumModels();
        if (this.histogramName.isEmpty()) {
            this.histogramName = FilenameUtils.removeExtension((String)this.filenames.get(0)) + ".his";
        }
        if (this.lamBins < 1) {
            File histogramFile = new File(this.histogramName);
            HistogramData histogramData = HistogramData.readHistogram(histogramFile);
            this.lamBins = histogramData.getLambdaBins();
            if (histogramData.wasHistogramRead()) {
                logger.info(String.format(" Autodetected %d from histogram file.", this.lamBins));
            }
        }
        this.energiesL = new ArrayList<List<Double>>(this.lamBins);
        this.energiesUp = new ArrayList<List<Double>>(this.lamBins);
        this.energiesDown = new ArrayList<List<Double>>(this.lamBins);
        for (i = 0; i < this.lamBins; ++i) {
            this.energiesL.add(new ArrayList());
            this.energiesUp.add(new ArrayList());
            this.energiesDown.add(new ArrayList());
        }
        this.lamSep = 1.0 / (double)(this.lamBins - 1);
        this.halfLamSep = 0.5 * this.lamSep;
        this.lamPoints = new double[this.lamBins];
        for (i = 0; i < this.lamBins - 1; ++i) {
            this.lamPoints[i] = (double)i * this.lamSep;
        }
        this.lamPoints[this.lamBins - 1] = 1.0;
        OptionalDouble optLam = this.openers[0].getLastReadLambda();
        if (!optLam.isPresent()) {
            throw new IllegalArgumentException(String.format(" No lambda records found in the first header of archive file %s", this.filenames.get(0)));
        }
        this.start = this.startFrame - 1;
        this.end = this.finalFrame < 1 ? nSnapshots : FastMath.min((int)nSnapshots, (int)this.finalFrame);
        this.end -= this.startFrame;
        double lambda = optLam.getAsDouble();
        int nVar = this.potential.getNumberOfVariables();
        this.x = new double[nVar];
        this.observations = new int[this.lamBins];
        if (this.lambdaSorted) {
            Arrays.fill(this.observations, -this.startFrame);
        } else {
            Arrays.fill(this.observations, 0);
        }
        logger.info(" Reading snapshots.");
        this.addEntries(lambda, 0);
        for (int i3 = 1; i3 < this.end; ++i3) {
            for (int j = 0; j < numTopologies; ++j) {
                this.openers[j].readNext(false, false);
            }
            lambda = this.openers[0].getLastReadLambda().getAsDouble();
            this.addEntries(lambda, i3);
        }
        for (SystemFilter opener : this.openers) {
            opener.closeReader();
        }
        double[][] eLow = new double[this.lamBins][];
        double[][] eAt = new double[this.lamBins][];
        double[][] eHigh = new double[this.lamBins][];
        for (int i4 = 0; i4 < this.lamBins; ++i4) {
            eLow[i4] = this.energiesDown.get(i4).stream().mapToDouble(Double::doubleValue).toArray();
            eAt[i4] = this.energiesL.get(i4).stream().mapToDouble(Double::doubleValue).toArray();
            eHigh[i4] = this.energiesUp.get(i4).stream().mapToDouble(Double::doubleValue).toArray();
        }
        logger.info("\n Initial estimate via the iteration method.");
        BennettAcceptanceRatio bar = new BennettAcceptanceRatio(this.lamPoints, (double[][])eLow, (double[][])eAt, (double[][])eHigh, new double[]{this.temp});
        Zwanzig forwards = bar.getInitialForwardsGuess();
        Zwanzig backwards = bar.getInitialBackwardsGuess();
        logger.info(String.format(" Free energy via BAR:           %15.9f +/- %.9f kcal/mol.", bar.getTotalFreeEnergyDifference(), bar.getTotalFEDifferenceUncertainty()));
        logger.info(String.format(" Free energy via forwards FEP:  %15.9f +/- %.9f kcal/mol.", forwards.getTotalFreeEnergyDifference(), forwards.getTotalFEDifferenceUncertainty()));
        logger.info(String.format(" Free energy via backwards FEP: %15.9f +/- %.9f kcal/mol.", backwards.getTotalFreeEnergyDifference(), backwards.getTotalFEDifferenceUncertainty()));
        logger.info(" Note - non-bootstrap FEP uncertainties are currently unreliable.");
        double[] barFE = bar.getFreeEnergyDifferences();
        double[] barVar = bar.getFEDifferenceUncertainties();
        double[] forwardsFE = forwards.getFreeEnergyDifferences();
        double[] forwardsVar = forwards.getFEDifferenceUncertainties();
        double[] backwardsFE = backwards.getFreeEnergyDifferences();
        double[] backwardsVar = backwards.getFEDifferenceUncertainties();
        sb = new StringBuilder("\n Free Energy Profile Per Window\n Min_Lambda Counts Max_Lambda Counts         BAR_dG      BAR_Var          FEP_dG      FEP_Var     FEP_Back_dG FEP_Back_Var\n");
        for (int i5 = 0; i5 < this.lamBins - 1; ++i5) {
            sb.append(String.format(" %-10.8f %6d %-10.8f %6d %15.9f %12.9f %15.9f %12.9f %15.9f %12.9f\n", this.lamPoints[i5], eAt[i5].length, this.lamPoints[i5 + 1], eAt[i5 + 1].length, barFE[i5], barVar[i5], forwardsFE[i5], forwardsVar[i5], backwardsFE[i5], backwardsVar[i5]));
        }
        logger.info(sb.toString());
        if (this.bootstrap == -1L) {
            int totalRead = Arrays.stream(this.observations).min().getAsInt();
            if ((long)totalRead >= 200L) {
                this.bootstrap = 10000000L / (long)totalRead;
                this.bootstrap = FastMath.max((long)200L, (long)FastMath.min((long)50000L, (long)this.bootstrap));
            } else {
                logger.info(String.format(" At least one lambda window had only %d snapshots read; defaulting to %d bootstrap cycles!", totalRead, 200L));
                this.bootstrap = 200L;
            }
        }
        long bootPrint = 50L;
        if (!this.verbose) {
            bootPrint *= 10L;
        }
        if (this.bootstrap > 0L) {
            logger.info(String.format(" Re-estimate free energy and uncertainty from %d bootstrap trials.", this.bootstrap));
            EstimateBootstrapper barBS = new EstimateBootstrapper((BootstrappableEstimator)bar);
            EstimateBootstrapper forBS = new EstimateBootstrapper((BootstrappableEstimator)forwards);
            EstimateBootstrapper backBS = new EstimateBootstrapper((BootstrappableEstimator)backwards);
            long time = -System.nanoTime();
            barBS.bootstrap(this.bootstrap, bootPrint);
            logger.info(String.format(" BAR bootstrapping complete in %.4f sec", (double)(time += System.nanoTime()) * 1.0E-9));
            time = -System.nanoTime();
            forBS.bootstrap(this.bootstrap, bootPrint);
            logger.info(String.format(" Forwards FEP bootstrapping complete in %.4f sec", (double)(time += System.nanoTime()) * 1.0E-9));
            time = -System.nanoTime();
            backBS.bootstrap(this.bootstrap, bootPrint);
            logger.info(String.format(" Reverse FEP bootstrapping complete in %.4f sec", (double)(time += System.nanoTime()) * 1.0E-9));
            barFE = barBS.getFreeEnergyDifferences();
            barVar = barBS.getFEDifferenceStdDevs();
            forwardsFE = forBS.getFreeEnergyDifferences();
            forwardsVar = forBS.getFEDifferenceStdDevs();
            backwardsFE = backBS.getFreeEnergyDifferences();
            backwardsVar = backBS.getFEDifferenceStdDevs();
            double sumFE = barBS.getTotalFreeEnergyDifference(barFE);
            double varFE = barBS.getTotalFEDifferenceUncertainty(barVar);
            logger.info(String.format(" Free energy via BAR:           %15.9f +/- %.9f kcal/mol.", sumFE, varFE));
            sumFE = forBS.getTotalFreeEnergyDifference(forwardsFE);
            varFE = forBS.getTotalFEDifferenceUncertainty();
            logger.info(String.format(" Free energy via forwards FEP:  %15.9f +/- %.9f kcal/mol.", sumFE, varFE));
            sumFE = backBS.getTotalFreeEnergyDifference(backwardsFE);
            varFE = backBS.getTotalFEDifferenceUncertainty();
            logger.info(String.format(" Free energy via backwards FEP:  %15.9f +/- %.9f kcal/mol.", sumFE, varFE));
            sb = new StringBuilder(" Free Energy Profile\n Min_Lambda Counts Max_Lambda Counts         BAR_dG      BAR_Var          FEP_dG      FEP_Var     FEP_Back_dG FEP_Back_Var\n");
            for (int i6 = 0; i6 < this.lamBins - 1; ++i6) {
                sb.append(String.format(" %-10.8f %6d %-10.8f %6d %15.9f %12.9f %15.9f %12.9f %15.9f %12.9f\n", this.lamPoints[i6], eAt[i6].length, this.lamPoints[i6 + 1], eAt[i6 + 1].length, barFE[i6], barVar[i6], forwardsFE[i6], forwardsVar[i6], backwardsFE[i6], backwardsVar[i6]));
            }
            logger.info(sb.toString());
        } else {
            logger.info(" Bootstrap resampling disabled.");
        }
        return this;
    }

    private void addEntries(double lambda, int index) {
        boolean onStride;
        int offsetIndex;
        int bin;
        int n = bin = this.binForLambda(lambda);
        this.observations[n] = this.observations[n] + 1;
        int n2 = offsetIndex = this.lambdaSorted ? this.observations[bin] : index - this.start;
        assert (offsetIndex <= this.end);
        boolean inRange = offsetIndex >= 0 && offsetIndex <= this.end;
        boolean bl = onStride = offsetIndex % this.stride == 0;
        if (inRange && onStride) {
            this.x = this.potential.getCoordinates(this.x);
            this.lastEntries[0] = this.addLambdaDown(lambda, bin);
            this.lastEntries[1] = this.addAtLambda(lambda, bin);
            this.lastEntries[2] = this.addLambdaUp(lambda, bin);
            String low = Double.isNaN(this.lastEntries[0]) ? nanFormat : String.format(energyFormat, this.lastEntries[0]);
            String high = Double.isNaN(this.lastEntries[2]) ? nanFormat : String.format(energyFormat, this.lastEntries[2]);
            logger.log(this.standardLogging, String.format(" Energies for snapshot %5d at lambda %.4f: %s, %s, %s", index + 1, lambda, low, String.format(energyFormat, this.lastEntries[1]), high));
        } else {
            logger.log(this.standardLogging, " Skipping frame " + index);
        }
    }

    private double addAtLambda(double lambda, int bin) {
        assert (lambda >= 0.0 && lambda <= 1.0);
        this.linter.setLambda(lambda);
        double e = this.potential.energy(this.x, false);
        this.energiesL.get(bin).add(e);
        return e;
    }

    private double addLambdaUp(double lambda, int bin) {
        double modLambda = lambda + this.lamSep;
        modLambda = FastMath.min((double)1.0, (double)modLambda);
        if (bin == this.lamBins - 1) {
            this.energiesUp.get(bin).add(Double.NaN);
            return Double.NaN;
        }
        this.linter.setLambda(modLambda);
        double e = this.potential.energy(this.x, false);
        this.energiesUp.get(bin).add(e);
        this.linter.setLambda(lambda);
        return e;
    }

    private double addLambdaDown(double lambda, int bin) {
        double modLambda = lambda - this.lamSep;
        modLambda = FastMath.max((double)0.0, (double)modLambda);
        if (bin == 0) {
            this.energiesDown.get(0).add(Double.NaN);
            return Double.NaN;
        }
        this.linter.setLambda(modLambda);
        double e = this.potential.energy(this.x, false);
        this.energiesDown.get(bin).add(e);
        this.linter.setLambda(lambda);
        return e;
    }

    private int binForLambda(double lambda) {
        return (int)FastMath.round((double)(lambda / this.lamSep));
    }
}

