/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands.test;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.optimize.Minimize;
import ffx.crystal.Crystal;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import picocli.CommandLine;

@CommandLine.Command(description={" Search for minimum energy polymoprhs for a given space group."}, name="test.CrystalSearch")
public class CrystalSearch
extends AlgorithmsCommand {
    @CommandLine.Option(names={"-e", "--eps"}, paramLabel="1.0", defaultValue="1.0", description={"Minimization convergence criteria (Kcal/mol/Ang)."})
    private double eps;
    @CommandLine.Option(names={"-t", "--trials"}, paramLabel="10", defaultValue="10", description={"Number of random trials."})
    private int nTrials;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"A PDB or XYZ input file."})
    private String filename;

    public CrystalSearch() {
    }

    public CrystalSearch(FFXBinding binding) {
        super(binding);
    }

    public CrystalSearch(String[] args) {
        super(args);
    }

    private static double getRandomNumber(double maxShift, double minShift, Random rando) {
        return minShift + (maxShift - minShift) * rando.nextDouble();
    }

    private static double[][] getAtomicCoordinates(Atom[] atoms, int numberOfAtoms) {
        double[] coords = new double[3];
        double[][] atomCoords = new double[numberOfAtoms][3];
        for (int j = 0; j < numberOfAtoms; ++j) {
            coords[0] = atoms[j].getX();
            coords[1] = atoms[j].getY();
            coords[2] = atoms[j].getZ();
            for (int k = 0; k < 3; ++k) {
                atomCoords[j][k] = coords[k];
            }
        }
        return atomCoords;
    }

    private static double density(double mass, int nSymm, Crystal unitCell) {
        return mass * (double)nSymm / 6.02214076E23 * (1.0E24 / unitCell.volume);
    }

    public CrystalSearch run() {
        if (!this.init()) {
            return this;
        }
        MolecularAssembly molecularAssembly = this.getActiveAssembly(this.filename);
        if (molecularAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        Crystal crystal = molecularAssembly.getCrystal().getUnitCell();
        logger.info("\n Searching for " + this.filename);
        logger.info(" RMS gradient convergence criteria: " + this.eps);
        ForceFieldEnergy forceFieldEnergy = molecularAssembly.getPotentialEnergy();
        Minimize minimize = new Minimize(molecularAssembly, null);
        Atom[] atoms = molecularAssembly.getAtomArray();
        int nSymm = 4;
        double[] translate = new double[3];
        double[] com = new double[3];
        int counter = 1;
        double avogadro = 6.02214076E23;
        int nAtoms = atoms.length;
        double mass = 0.0;
        Random random = new Random();
        double[][] newAtoms = new double[nAtoms][3];
        double[] finalCoords = new double[3];
        double[][] bestAtoms = new double[nAtoms][3];
        double[][] originalAtoms = new double[nAtoms][3];
        double[] bestCrystalParameters = new double[6];
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        double max = 0.5;
        double min = -max;
        double minDensity = 0.8;
        double maxDensity = 1.3;
        boolean likelyDensity = false;
        com[0] = 0.0;
        com[1] = 0.0;
        com[2] = 0.0;
        for (Atom atom : atoms) {
            com[0] = com[0] + atom.getX();
            com[1] = com[1] + atom.getY();
            com[2] = com[2] + atom.getZ();
        }
        com[0] = com[0] / (double)nAtoms;
        com[1] = com[1] / (double)nAtoms;
        com[2] = com[2] / (double)nAtoms;
        crystal.toPrimaryCell(com, translate);
        translate[0] = translate[0] - com[0];
        translate[1] = translate[1] - com[1];
        translate[2] = translate[2] - com[2];
        for (Atom atom : atoms) {
            atom.move(translate);
            mass += atom.getMass();
        }
        double energy2 = Double.MAX_VALUE;
        for (int i = 0; i < this.nTrials; ++i) {
            int n;
            while (!likelyDensity) {
                a = CrystalSearch.getRandomNumber(14.0, 8.0, random);
                b = CrystalSearch.getRandomNumber(14.0, 8.0, random);
                c = CrystalSearch.getRandomNumber(14.0, 8.0, random);
                alpha = 90.0;
                beta = CrystalSearch.getRandomNumber(150.0, 140.0, random);
                gamma = 90.0;
                crystal.changeUnitCellParameters(a, b, c, alpha, beta, gamma);
                double den = CrystalSearch.density(mass, nSymm, crystal);
                if (!(den > minDensity) || !(den < maxDensity)) continue;
                likelyDensity = true;
            }
            logger.info("---------------------- Trial Number: " + counter + " ----------------------");
            ++counter;
            logger.info("Cell parameters: " + a + " " + b + " " + c + " " + beta);
            likelyDensity = false;
            forceFieldEnergy.setCrystal(crystal);
            double s = random.nextDouble();
            double \u03c31 = Math.sqrt(1.0 - s);
            double \u03c32 = Math.sqrt(s);
            double \u03b81 = Math.PI * 2 * random.nextDouble();
            double \u03b82 = Math.PI * 2 * random.nextDouble();
            double w = Math.cos(\u03b82) * \u03c32;
            double x = Math.sin(\u03b81) * \u03c31;
            double y = Math.cos(\u03b81) * \u03c31;
            double z = Math.sin(\u03b82) * \u03c32;
            Rotation rotation = new Rotation(w, x, y, z, true);
            for (int j = 0; j < nAtoms; ++j) {
                atoms[j].rotate(rotation.getMatrix());
            }
            double d = CrystalSearch.getRandomNumber(max, min, random);
            double e = CrystalSearch.getRandomNumber(max, min, random);
            double f = CrystalSearch.getRandomNumber(max, min, random);
            double[] translation = new double[]{d, e, f};
            logger.info(" Translation vector: " + Arrays.toString(translation));
            for (int k = 0; k < nAtoms; ++k) {
                atoms[k].move(translation);
            }
            Potential g = minimize.minimize(this.eps);
            newAtoms = CrystalSearch.getAtomicCoordinates(atoms, nAtoms);
            double energy = forceFieldEnergy.energy(false, true);
            if (i == 0) {
                energy2 = energy;
                for (l = 0; l < nAtoms; ++l) {
                    for (m = 0; m < 3; ++m) {
                        originalAtoms[l][m] = newAtoms[l][m];
                    }
                }
            } else if (energy < energy2) {
                energy2 = energy;
                for (l = 0; l < nAtoms; ++l) {
                    for (m = 0; m < 3; ++m) {
                        bestAtoms[l][m] = newAtoms[l][m];
                    }
                }
                bestCrystalParameters = new double[]{a, b, c, alpha, beta, gamma};
            }
            for (n = 0; n < nAtoms; ++n) {
                finalCoords[0] = originalAtoms[n][0];
                finalCoords[1] = originalAtoms[n][1];
                finalCoords[2] = originalAtoms[n][2];
                atoms[n].moveTo(finalCoords[0], finalCoords[1], finalCoords[2]);
            }
            if (i != this.nTrials - 1) continue;
            for (n = 0; n < nAtoms; ++n) {
                finalCoords[0] = bestAtoms[n][0];
                finalCoords[1] = bestAtoms[n][1];
                finalCoords[2] = bestAtoms[n][2];
                atoms[n].moveTo(finalCoords[0], finalCoords[1], finalCoords[2]);
            }
            crystal.changeUnitCellParameters(bestCrystalParameters[0], bestCrystalParameters[1], bestCrystalParameters[2], bestCrystalParameters[3], bestCrystalParameters[4], bestCrystalParameters[5]);
            forceFieldEnergy.setCrystal(crystal);
            logger.info("Final energy is " + energy2);
        }
        String ext = FilenameUtils.getExtension((String)this.filename);
        this.filename = FilenameUtils.removeExtension((String)this.filename);
        if (ext.toUpperCase().contains("XYZ")) {
            this.algorithmFunctions.saveAsXYZ(molecularAssembly, new File(this.filename + ".xyz"));
        } else {
            this.algorithmFunctions.saveAsPDB(molecularAssembly, new File(this.filename + ".pdb"));
        }
        return this;
    }
}

