/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands.test;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.optimize.ConformationScan;
import ffx.algorithms.optimize.Minimize;
import ffx.algorithms.optimize.TorsionSearch;
import ffx.numerics.Potential;
import ffx.potential.AssemblyState;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.Molecule;
import ffx.potential.utils.PotentialsUtils;
import ffx.utilities.FFXBinding;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Calculates interaction energies of different molecular orientations and saves low energy orientations."}, name="test.CoformerBindingSearch")
public class CoformerBindingSearch
extends AlgorithmsCommand {
    private static final Logger logger = Logger.getLogger(CoformerBindingSearch.class.getName());
    @CommandLine.Option(names={"--eps"}, paramLabel=".01", description={"Gradient cutoff for minimization."})
    private double eps = 0.01;
    @CommandLine.Option(names={"--maxIter"}, paramLabel="10000", description={"Max iterations for minimization."})
    private int maxIter = 10000;
    @CommandLine.Option(names={"--solventDielectric"}, paramLabel="78.4", description={"Sets the gk solvent dielectric constant."})
    private double gkSolventDielec = 78.4;
    @CommandLine.Option(names={"--skipHomodimerNumber"}, paramLabel="-1", description={"Skip conformation search on input dimer one or two."})
    private int skipHomodimerNumber = -1;
    @CommandLine.Option(names={"--torsionScan", "--tscan"}, paramLabel="false", defaultValue="false", description={"During sampling, statically scan torsions after direct minimization to find the lowest energy conformation."})
    private boolean tscan = false;
    @CommandLine.Option(names={"--noMinimize", "--noMin"}, paramLabel="false", defaultValue="false", description={"Don't minimize or torsion scan after conformations are generated. Useful for testing."})
    private boolean noMinimize = false;
    @CommandLine.Option(names={"--excludeH", "--eh"}, paramLabel="false", defaultValue="false", description={"Only include H bonded to electronegative atoms in conformations."})
    private boolean excludeH = false;
    @CommandLine.Option(names={"--coformerOnly"}, paramLabel="false", defaultValue="false", description={"Only conformation search the coformer."})
    private boolean coformerOnly = false;
    @CommandLine.Option(names={"--gk"}, paramLabel="false", defaultValue="false", description={"Use generalized kirkwood solvent."})
    private boolean gk = false;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"XYZ input file."})
    private List<String> filenames = null;
    private Boolean minimize = null;

    public CoformerBindingSearch() {
    }

    public CoformerBindingSearch(FFXBinding binding) {
        super(binding);
    }

    public CoformerBindingSearch(String[] args) {
        super(args);
    }

    public CoformerBindingSearch run() {
        System.setProperty("direct-scf-fallback", "true");
        if (!this.init()) {
            return this;
        }
        try {
            CoformerBindingSearch.setKeyAndPatchFiles(this.gk, this.gkSolventDielec, this.filenames);
        }
        catch (IOException e) {
            logger.severe("Error creating key/patch files: " + e.getMessage());
            return this;
        }
        if (this.filenames.size() != 1 && this.filenames.size() != 2) {
            logger.severe("Must provide one or two filenames.");
            return this;
        }
        this.minimize = !this.noMinimize;
        boolean skipMoleculeOne = this.skipHomodimerNumber == 1;
        boolean skipMoleculeTwo = this.skipHomodimerNumber == 2;
        ConformationScan systemOneScan = null;
        ConformationScan systemTwoScan = null;
        if (!this.coformerOnly) {
            if (!skipMoleculeOne) {
                systemOneScan = this.runScan(this.filenames.get(0), this.filenames.get(0));
            } else {
                logger.info(" Skipping monomer one scan.");
            }
            if (!skipMoleculeTwo && this.filenames.size() == 2) {
                systemTwoScan = this.runScan(this.filenames.get(1), this.filenames.get(1));
            } else if (!skipMoleculeTwo && this.filenames.size() == 1) {
                logger.info(" Only one file provided, skipping second homodimer scan.");
            }
        } else {
            logger.info(" Skipping monomer one and two scan.");
        }
        if (this.filenames.size() == 2) {
            ConformationScan bothSystems = this.runScan(this.filenames.get(0), this.filenames.get(1));
            if (systemOneScan != null && systemTwoScan != null) {
                logger.info("\n System one (" + FilenameUtils.removeExtension((String)this.filenames.get(0)) + ") self scan energy information:");
                systemOneScan.logAllEnergyInformation();
                logger.info("\n System two (" + FilenameUtils.removeExtension((String)this.filenames.get(1)) + ") self scan energy information:");
                systemTwoScan.logAllEnergyInformation();
                ConformationScan.logBindingEnergyCalculation(systemOneScan, systemTwoScan, bothSystems);
            }
        } else {
            logger.info(" Only one file provided, skipping coformer scan.");
        }
        return this;
    }

    private ConformationScan runScan(String fileOne, String fileTwo) {
        boolean coformer = !fileOne.equals(fileTwo);
        PotentialsUtils potentialsUtils = new PotentialsUtils();
        MolecularAssembly[] molecularAssemblies = potentialsUtils.openAll(new String[]{fileOne, fileTwo});
        this.minimizeMolecularAssemblies(molecularAssemblies);
        int secondSystemStartIndex = molecularAssemblies[0].getMoleculeArray().length;
        MolecularAssembly combined = CoformerBindingSearch.combineTwoMolecularAssemblies(molecularAssemblies[0], molecularAssemblies[1]);
        ArrayList<Molecule> setOne = new ArrayList<Molecule>();
        ArrayList<Molecule> setTwo = new ArrayList<Molecule>();
        for (int i = 0; i < combined.getMoleculeArray().length; ++i) {
            if (i < secondSystemStartIndex) {
                setOne.add(combined.getMoleculeArray()[i]);
                continue;
            }
            setTwo.add(combined.getMoleculeArray()[i]);
        }
        Molecule[] systemOne = setOne.toArray(new Molecule[0]);
        Molecule[] systemTwo = setTwo.toArray(new Molecule[0]);
        ConformationScan scan = new ConformationScan(combined, systemOne, systemTwo, this.eps, this.maxIter, this.tscan, this.excludeH, this.minimize);
        scan.scan();
        String fileName = coformer ? "coformerScan.arc" : FilenameUtils.removeExtension((String)fileOne) + ".arc";
        File file = new File(fileName);
        if (!scan.writeStructuresToXYZ(file)) {
            logger.warning(" No structures saved from scan.");
            scan = null;
        } else if (!coformer) {
            logger.info("\n System (" + FilenameUtils.removeExtension((String)fileOne) + ") self scan energy information:");
            scan.logAllEnergyInformation();
        } else {
            logger.info("\n System (" + FilenameUtils.removeExtension((String)fileOne) + ") and system (" + FilenameUtils.removeExtension((String)fileTwo) + ") scan energy information:");
            scan.logAllEnergyInformation();
        }
        return scan;
    }

    private static MolecularAssembly combineTwoMolecularAssemblies(MolecularAssembly mola1, MolecularAssembly mola2) {
        MolecularAssembly mainMonomerAssembly = mola1;
        MolecularAssembly feederAssembly = mola2;
        Molecule[] assemblyTwoMolecules = feederAssembly.getMoleculeArray();
        int molNum = mainMonomerAssembly.getMoleculeArray().length;
        for (Molecule m : assemblyTwoMolecules) {
            for (Atom a : m.getAtomList()) {
                a.setMoleculeNumber(molNum);
            }
            m.setName("AddedMol" + molNum);
            mainMonomerAssembly.addMSNode((MSNode)m);
            ++molNum;
        }
        mainMonomerAssembly.update();
        mainMonomerAssembly.setPotential(null);
        ForceFieldEnergy forceFieldEnergy = ForceFieldEnergy.energyFactory((MolecularAssembly)mainMonomerAssembly);
        return mainMonomerAssembly;
    }

    private static void setKeyAndPatchFiles(boolean gk, double gkSolventDielec, List<String> filenames) throws IOException {
        String key = "coformerScan.key";
        String patch = "coformerScan.patch";
        File keyFile = new File(key);
        File patchFile = new File(patch);
        logger.info(" Creating key file: " + key);
        keyFile.createNewFile();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(keyFile));){
            bw.write("patch " + FilenameUtils.removeExtension((String)key) + ".patch\n\n");
            if (gk) {
                bw.write("gkterm true\n");
                bw.write("solvent-dielectric " + gkSolventDielec + "\n");
                bw.write("gk-radius solute\n");
                bw.write("cavmodel gauss-disp\n");
            }
        }
        logger.info(" Creating patch file: " + patch);
        patchFile.createNewFile();
        String patchOne = FilenameUtils.removeExtension((String)filenames.get(0)) + ".patch";
        String patchTwo = filenames.size() > 1 ? FilenameUtils.removeExtension((String)filenames.get(1)) + ".patch" : patchOne;
        String[] files = new String[]{patchOne, patchTwo};
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(patchFile));){
            for (String file : files) {
                try (BufferedReader br = new BufferedReader(new FileReader(file));){
                    String line = br.readLine();
                    while (line != null) {
                        bw.write(line + "\n");
                        line = br.readLine();
                    }
                }
            }
        }
        System.setProperty("key", key);
    }

    private void minimizeMolecularAssemblies(MolecularAssembly[] molecularAssemblies) {
        if (!this.noMinimize) {
            logger.info(" Minimizing molecular assemblies.");
            for (MolecularAssembly molecularAssembly : molecularAssemblies) {
                for (Molecule m : molecularAssembly.getMoleculeArray()) {
                    if (!this.tscan) continue;
                    TorsionSearch ts = new TorsionSearch(molecularAssembly, m, 32, 1);
                    ts.staticAnalysis(0, 100.0);
                    if (ts.getStates().isEmpty()) continue;
                    AssemblyState minState = ts.getStates().get(0);
                    minState.revertState();
                }
                Minimize minimizer = new Minimize(molecularAssembly, (Potential)molecularAssembly.getPotentialEnergy(), this.algorithmListener);
                minimizer.minimize(this.eps, this.maxIter);
            }
            logger.info(" Done minimizing molecular assemblies.");
        }
    }
}

