/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import edu.rit.pj.Comm;
import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.BarostatOptions;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.cli.LambdaParticleOptions;
import ffx.algorithms.cli.MultiDynamicsOptions;
import ffx.algorithms.cli.OSTOptions;
import ffx.algorithms.cli.RandomUnitCellOptions;
import ffx.algorithms.cli.ThermodynamicsOptions;
import ffx.algorithms.thermodynamics.MonteCarloOST;
import ffx.algorithms.thermodynamics.OrthogonalSpaceTempering;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.cli.AlchemicalOptions;
import ffx.potential.cli.TopologyOptions;
import ffx.potential.cli.WriteoutOptions;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Use the Transition-Tempered Orthogonal Space Random Walk algorithm to estimate a free energy."}, name="Thermodynamics")
public class Thermodynamics
extends AlgorithmsCommand {
    @CommandLine.Mixin
    public DynamicsOptions dynamicsOptions;
    @CommandLine.Mixin
    public BarostatOptions barostatOptions;
    @CommandLine.Mixin
    public RandomUnitCellOptions randomSymopOptions;
    @CommandLine.Mixin
    public AlchemicalOptions alchemicalOptions;
    @CommandLine.Mixin
    public TopologyOptions topologyOptions;
    @CommandLine.Mixin
    public WriteoutOptions writeoutOptions;
    @CommandLine.Mixin
    public ThermodynamicsOptions thermodynamicsOptions;
    @CommandLine.Mixin
    public OSTOptions ostOptions;
    @CommandLine.Mixin
    public LambdaParticleOptions lambdaParticleOptions;
    @CommandLine.Mixin
    public MultiDynamicsOptions multiDynamicsOptions;
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Log additional information (primarily for MC-OST)."})
    public boolean verbose = false;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"The atomic coordinate file in PDB or XYZ format."})
    public List<String> filenames = null;
    public MolecularAssembly[] topologies;
    public CrystalPotential potential;
    public OrthogonalSpaceTempering orthogonalSpaceTempering = null;
    public Configuration additionalProperties;

    public void setProperties(Configuration additionalProps) {
        this.additionalProperties = additionalProps;
    }

    public Thermodynamics() {
    }

    public Thermodynamics(FFXBinding binding) {
        super(binding);
    }

    public Thermodynamics(String[] args) {
        super(args);
    }

    public Thermodynamics run() {
        if (!this.init()) {
            return this;
        }
        int numTopologies = this.topologyOptions.getNumberOfTopologies(this.filenames);
        int threadsPerTopology = this.topologyOptions.getThreadsPerTopology(numTopologies);
        this.topologies = new MolecularAssembly[numTopologies];
        this.alchemicalOptions.setAlchemicalProperties();
        this.topologyOptions.setAlchemicalProperties(numTopologies);
        Comm world = Comm.world();
        int size = world.size();
        int rank = size > 1 ? world.rank() : 0;
        ArrayList<File> structureFiles = new ArrayList<File>();
        for (String filename : this.filenames) {
            File file = new File(FilenameUtils.normalize((String)filename));
            structureFiles.add(file);
        }
        File firstStructure = (File)structureFiles.get(0);
        String filePathNoExtension = firstStructure.getAbsolutePath().replaceFirst("\\.[^.]+$", "");
        File histogramRestart = new File(filePathNoExtension + ".his");
        String withRankName = filePathNoExtension;
        if (size > 1) {
            ArrayList<File> rankedFiles = new ArrayList<File>(numTopologies);
            Object rankDirName = FilenameUtils.getFullPath((String)filePathNoExtension);
            File rankDirectory = new File((String)(rankDirName = String.format("%s%d", rankDirName, rank + this.multiDynamicsOptions.getFirstDir())));
            if (!rankDirectory.exists()) {
                rankDirectory.mkdir();
            }
            rankDirName = (String)rankDirName + File.separator;
            withRankName = String.format("%s%s", rankDirName, FilenameUtils.getName((String)filePathNoExtension));
            for (File structureFile : structureFiles) {
                rankedFiles.add(new File(String.format("%s%s", rankDirName, FilenameUtils.getName((String)structureFile.getName()))));
            }
            structureFiles = rankedFiles;
        }
        File lambdaRestart = new File(withRankName + ".lam");
        File dyn = new File(withRankName + ".dyn");
        if (this.ostOptions.getIndependentWalkers()) {
            histogramRestart = new File(withRankName + ".his");
        }
        if (this.filenames == null || this.filenames.isEmpty()) {
            this.activeAssembly = this.getActiveAssembly(null);
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.filenames = new ArrayList<String>();
            this.filenames.add(this.activeAssembly.getFile().getName());
            this.topologies[0] = this.alchemicalOptions.processFile(this.topologyOptions, this.activeAssembly, 0);
        } else {
            logger.info(String.format(" Initializing %d topologies...", numTopologies));
            for (int i = 0; i < numTopologies; ++i) {
                this.topologies[i] = this.multiDynamicsOptions.openFile(this.algorithmFunctions, this.topologyOptions, threadsPerTopology, this.filenames.get(i), i, this.alchemicalOptions, (File)structureFiles.get(i), rank);
            }
        }
        StringBuilder sb = new StringBuilder("\n Running ");
        ThermodynamicsOptions.ThermodynamicsAlgorithm algorithm = this.thermodynamicsOptions.getAlgorithm();
        double initLambda = this.alchemicalOptions.getInitialLambda(size, rank, true);
        if (algorithm == ThermodynamicsOptions.ThermodynamicsAlgorithm.OST) {
            sb.append("Orthogonal Space Tempering");
        } else if (algorithm == ThermodynamicsOptions.ThermodynamicsAlgorithm.FIXED) {
            sb.append("Fixed Lambda Sampling at Window L=").append(String.format("%5.3f ", initLambda));
        } else if (algorithm == ThermodynamicsOptions.ThermodynamicsAlgorithm.NEQ) {
            sb.append("Non-Equilibrium Sampling");
        } else {
            logger.severe(" Unknown Thermodynamics Algorithm " + String.valueOf((Object)algorithm));
        }
        sb.append(" for ");
        this.potential = (CrystalPotential)this.topologyOptions.assemblePotential(this.topologies, sb);
        logger.info(sb.toString());
        LambdaInterface lambdaInterface = (LambdaInterface)this.potential;
        boolean lamExists = lambdaRestart.exists();
        double[] x = new double[this.potential.getNumberOfVariables()];
        this.potential.getCoordinates(x);
        lambdaInterface.setLambda(initLambda);
        this.potential.energy(x, true);
        if (numTopologies == 1) {
            this.randomSymopOptions.randomize(this.topologies[0]);
        }
        this.multiDynamicsOptions.distribute(this.topologies, this.potential, this.algorithmFunctions, rank, size);
        if (algorithm == ThermodynamicsOptions.ThermodynamicsAlgorithm.OST) {
            this.orthogonalSpaceTempering = this.ostOptions.constructOST(this.potential, lambdaRestart, histogramRestart, this.topologies[0], this.additionalProperties, this.dynamicsOptions, this.thermodynamicsOptions, this.lambdaParticleOptions, this.algorithmListener, !this.multiDynamicsOptions.isSynchronous());
            if (!lamExists) {
                this.orthogonalSpaceTempering.setLambda(initLambda);
            }
            CrystalPotential ostPotential = this.ostOptions.applyAllOSTOptions(this.orthogonalSpaceTempering, this.topologies[0], this.dynamicsOptions, this.barostatOptions);
            if (this.ostOptions.isMonteCarlo()) {
                MonteCarloOST mcOST = this.ostOptions.setupMCOST(this.orthogonalSpaceTempering, this.topologies, ostPotential, this.dynamicsOptions, this.thermodynamicsOptions, this.verbose, dyn, this.algorithmListener);
                this.ostOptions.beginMCOST(mcOST, this.dynamicsOptions, this.thermodynamicsOptions);
            } else {
                this.ostOptions.beginMDOST(this.orthogonalSpaceTempering, this.topologies, ostPotential, this.dynamicsOptions, this.writeoutOptions, this.thermodynamicsOptions, dyn, this.algorithmListener);
            }
            logger.info(" Done running OST sampling.");
        } else if (algorithm == ThermodynamicsOptions.ThermodynamicsAlgorithm.FIXED) {
            this.orthogonalSpaceTempering = null;
            this.potential = this.barostatOptions.checkNPT(this.topologies[0], this.potential);
            this.thermodynamicsOptions.runFixedAlchemy(this.topologies, this.potential, this.dynamicsOptions, this.writeoutOptions, dyn, this.algorithmListener);
            logger.info(" Done running fixed lambda sampling.");
        } else if (algorithm == ThermodynamicsOptions.ThermodynamicsAlgorithm.NEQ) {
            this.orthogonalSpaceTempering = null;
            this.potential = this.barostatOptions.checkNPT(this.topologies[0], this.potential);
            this.thermodynamicsOptions.runNEQ(this.topologies, this.potential, this.dynamicsOptions, this.writeoutOptions, dyn, this.algorithmListener);
            logger.info(" Done running non-equilibrium sampling.");
        } else {
            logger.severe(" Unknown Thermodynamics Algorithm " + String.valueOf((Object)algorithm));
        }
        return this;
    }

    public OrthogonalSpaceTempering getOST() {
        return this.orthogonalSpaceTempering;
    }

    public CrystalPotential getPotential() {
        return this.potential;
    }

    @Override
    public List<Potential> getPotentials() {
        List<Object> potentials = this.orthogonalSpaceTempering == null ? (this.potential == null ? Collections.emptyList() : Collections.singletonList(this.potential)) : Collections.singletonList(this.orthogonalSpaceTempering);
        return potentials;
    }

    @Override
    public boolean destroyPotentials() {
        return this.getPotentials().stream().allMatch(potential -> potential.destroy());
    }
}

