/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.optimize.TitrationManyBody;
import ffx.numerics.Potential;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.parameters.TitrationUtils;
import ffx.potential.parsers.PDBFilter;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Save out rotamers."}, name="SaveRotamers")
public class SaveRotamers
extends AlgorithmsCommand {
    @CommandLine.Option(names={"--chain", "-c"}, paramLabel=" ", description={"Single character chain name."})
    private char c = (char)32;
    @CommandLine.Option(names={"--library", "-l"}, paramLabel="1", defaultValue="1", description={"Available rotamer libraries are (1) Ponder and Richards or (2) Richardson."})
    private int library;
    @CommandLine.Option(names={"--resid", "-r"}, paramLabel="1", defaultValue="1", description={"Residue number."})
    private int resID;
    @CommandLine.Option(names={"--independent", "-i"}, paramLabel="false", defaultValue="false", description={"Independent draws nucleic acid rotamers independently of chain context."})
    private boolean independent;
    @CommandLine.Option(names={"--start", "-s"}, paramLabel="0", defaultValue="0", description={"First rotamer to draw (indexed from rotamer 0)."})
    private int start;
    @CommandLine.Option(names={"--finish", "-f"}, paramLabel="-1", defaultValue="-1", description={"Last rotamer to draw (indexed from rotamer 0)."})
    private int finish;
    @CommandLine.Option(names={"--all", "-x"}, paramLabel="-1", defaultValue="-1", description={"Draw all rotamers beginning from the passed index (overrides other options)."})
    private int all;
    @CommandLine.Option(names={"--upstreamPucker", "-u"}, paramLabel="false", defaultValue="false", description={"Adjusts the pucker of the 5' residue to match the rotamer."})
    private boolean upstreamPucker;
    @CommandLine.Option(names={"--tR", "--titrateResidue"}, paramLabel="false", defaultValue="false", description={"Titrate residues."})
    private boolean titrateResidue;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file in XYZ or PDB format."})
    private String filename = null;
    private TitrationManyBody titrationManyBody;
    private TitrationUtils titrationUtils;

    public SaveRotamers() {
    }

    public SaveRotamers(FFXBinding binding) {
        super(binding);
    }

    public SaveRotamers(String[] args) {
        super(args);
    }

    public SaveRotamers run() {
        if (!this.init()) {
            return this;
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        CompositeConfiguration properties = this.activeAssembly.getProperties();
        if (this.titrateResidue) {
            List residues = this.activeAssembly.getResidueList();
            ArrayList<Integer> resNumberList = new ArrayList<Integer>();
            for (Residue residue : residues) {
                resNumberList.add(residue.getResidueNumber());
            }
            this.titrationManyBody = new TitrationManyBody(this.filename, this.activeAssembly.getForceField(), resNumberList, 7.0);
            this.activeAssembly = this.titrationManyBody.getProtonatedAssembly();
        }
        RotamerLibrary rLib = new RotamerLibrary(RotamerLibrary.ProteinLibrary.intToProteinLibrary((int)this.library), true);
        String chain = String.valueOf(this.c);
        boolean saveAllRotamers = false;
        int allStart = 0;
        if (this.all > -1) {
            allStart = this.all;
            saveAllRotamers = true;
        }
        logger.info("\n Saving rotamers for residue number " + this.resID + " of chain " + chain + ".");
        RotamerLibrary.initializeDefaultAtomicCoordinates((Polymer[])this.activeAssembly.getChains());
        Polymer polymer = this.activeAssembly.getChain(chain);
        if (polymer == null) {
            logger.info(" Polymer + " + chain + " does not exist.");
            return this;
        }
        Residue residue = polymer.getResidue(this.resID);
        if (residue == null) {
            logger.info(" Residue + " + this.resID + " does not exist.");
            return this;
        }
        residue.setRotamers(rLib);
        Rotamer[] rotamers = residue.getRotamers();
        if (rotamers == null) {
            logger.severe(" There are no rotamers for residue + " + residue.toString());
        }
        int nrotamers = rotamers.length;
        boolean isDeoxy = false;
        Residue prevResidue = null;
        if (this.upstreamPucker) {
            try {
                if (residue.getResidueType() == Residue.ResidueType.NA) {
                    prevResidue = residue.getPreviousResidue();
                    if (prevResidue == null) {
                        this.upstreamPucker = false;
                    } else {
                        Atom HOs = (Atom)prevResidue.getAtomNode("HO'");
                        if (HOs == null) {
                            isDeoxy = true;
                        }
                    }
                } else {
                    this.upstreamPucker = false;
                }
            }
            catch (Exception e) {
                this.upstreamPucker = false;
            }
        }
        String ext = FilenameUtils.getExtension((String)this.filename);
        this.filename = FilenameUtils.removeExtension((String)this.filename);
        HashSet<Atom> excludeAtoms = new HashSet<Atom>();
        ArrayList<Residue> removeAtomList = new ArrayList<Residue>();
        if (saveAllRotamers) {
            if (allStart >= nrotamers) {
                logger.info(" Specified start range is outside of rotamer range. No action taken.");
            } else {
                for (int i = allStart; i < nrotamers; ++i) {
                    RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamers[i], (boolean)this.independent);
                    logger.info(rotamers[i].getName());
                    if (this.upstreamPucker) {
                        double prevDelta = rotamers[i].chi1;
                        RotamerLibrary.NucleicSugarPucker sugarPucker = RotamerLibrary.NucleicSugarPucker.checkPucker((double)prevDelta, (boolean)isDeoxy);
                        RotamerLibrary.applySugarPucker((Residue)prevResidue, (RotamerLibrary.NucleicSugarPucker)sugarPucker, (boolean)isDeoxy, (boolean)true);
                    }
                    if (ext.toUpperCase().contains("XYZ")) {
                        logger.info(String.format(" Saving rotamer %d", i));
                        this.algorithmFunctions.saveAsXYZ(this.activeAssembly, new File(this.filename + ".xyz"));
                        continue;
                    }
                    if (this.titrateResidue) {
                        excludeAtoms.clear();
                        removeAtomList.clear();
                        removeAtomList.add(residue);
                        int[] currentRot = new int[]{i};
                        this.titrationManyBody.excludeExcessAtoms(excludeAtoms, currentRot, removeAtomList);
                        File modelFile = new File(this.filename + ".pdb");
                        PDBFilter pdbFilter = new PDBFilter(modelFile, this.activeAssembly, this.activeAssembly.getForceField(), properties);
                        if (pdbFilter.writeFile(modelFile, false, excludeAtoms, true, true)) continue;
                        logger.info(String.format(" Save failed for %s", this.activeAssembly));
                        continue;
                    }
                    logger.info(String.format(" Saving rotamer %d", i));
                    this.algorithmFunctions.saveAsPDB(this.activeAssembly, new File(this.filename + ".pdb"));
                }
            }
        } else if (this.start >= nrotamers) {
            logger.info(" Specified start range is outside of rotamer range. No action taken.");
        } else {
            if (this.finish >= nrotamers) {
                this.finish = nrotamers - 1;
            } else if (this.finish < this.start) {
                logger.info(" Specified finish point is before the start point drawing only rotamer " + this.start);
                this.finish = this.start;
            }
            for (int i = this.start; i <= this.finish; ++i) {
                RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamers[i], (boolean)this.independent);
                if (this.upstreamPucker) {
                    double prevDelta = rotamers[i].chi1;
                    RotamerLibrary.NucleicSugarPucker sugarPucker = RotamerLibrary.NucleicSugarPucker.checkPucker((double)prevDelta, (boolean)isDeoxy);
                    RotamerLibrary.applySugarPucker((Residue)prevResidue, (RotamerLibrary.NucleicSugarPucker)sugarPucker, (boolean)isDeoxy, (boolean)true);
                }
                if (ext.toUpperCase().contains("XYZ")) {
                    logger.info(String.format(" Saving rotamer %d", i));
                    this.algorithmFunctions.saveAsXYZ(this.activeAssembly, new File(this.filename + ".xyz"));
                    continue;
                }
                logger.info(String.format(" Saving rotamer %d", i));
                this.algorithmFunctions.saveAsPDB(this.activeAssembly, new File(this.filename + ".pdb"));
            }
        }
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        return Collections.emptyList();
    }
}

