/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import edu.rit.pj.Comm;
import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.cli.RepExOptions;
import ffx.algorithms.dynamics.MDEngine;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.algorithms.dynamics.MolecularDynamicsOpenMM;
import ffx.algorithms.dynamics.PhReplicaExchange;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.cli.WriteoutOptions;
import ffx.potential.extended.ExtendedSystem;
import ffx.potential.parsers.XPHFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.utilities.FFXBinding;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Run constant pH dynamics on a system."}, name="PhDynamics")
public class PhDynamics
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Mixin
    private DynamicsOptions dynamicsOptions;
    @CommandLine.Mixin
    private WriteoutOptions writeOutOptions;
    @CommandLine.Mixin
    private RepExOptions repEx;
    @CommandLine.Option(names={"--pH", "--constantPH"}, paramLabel="7.4", defaultValue="7.4", description={"Constant pH value for molecular dynamics"})
    private double pH;
    @CommandLine.Option(names={"--titrationSteps"}, paramLabel="10", defaultValue="10", description={"Number of steps done titrating protons on CPU in one cycle"})
    private int titrSteps;
    @CommandLine.Option(names={"--coordinateSteps"}, paramLabel="100", defaultValue="100", description={"Number of steps done propagating coordinates only on GPU in one cycle"})
    private int coordSteps;
    @CommandLine.Option(names={"--cycles", "--OMMcycles"}, paramLabel="5", defaultValue="5", description={"Number of times to cycle between titrating protons on CPU and propagating coordinates only on GPU"})
    private int cycles;
    @CommandLine.Option(names={"--titrationReport", "--esvLog"}, paramLabel="0.25 (psec)", defaultValue="0.25", description={"Interval in psec to report ESV energy and lambdas when cycling between GPU and CPU."})
    private double titrReport;
    @CommandLine.Option(names={"--pHGaps"}, paramLabel="1", defaultValue="1", description={"pH gap between replica exchange windows."})
    private double pHGap;
    @CommandLine.Option(names={"--initDynamics"}, paramLabel="10000", defaultValue="10000", description={"Number of initialization steps to take before replica exchange windows start."})
    private int initDynamics;
    @CommandLine.Option(names={"--sort"}, paramLabel="false", defaultValue="false", description={"Sort archive files by pH"})
    private boolean sort;
    @CommandLine.Option(names={"--printRatioData"}, paramLabel="false", defaultValue="false", description={"Print out the protonation ratios from throughout the simulation at the end"})
    private boolean printRatio;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"XYZ or PDB input files."})
    private String filename;
    private Potential potential;
    public MolecularDynamics molecularDynamics = null;

    public PhDynamics() {
    }

    public PhDynamics(FFXBinding binding) {
        super(binding);
    }

    public PhDynamics(String[] args) {
        super(args);
    }

    public MolecularDynamics getMolecularDynamics() {
        return this.molecularDynamics;
    }

    public Potential getPotentialObject() {
        return this.potential;
    }

    /*
     * Unable to fully structure code
     */
    public PhDynamics run() {
        if (!this.init()) {
            return this;
        }
        this.dynamicsOptions.init();
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            PhDynamics.logger.info(this.helpString());
            return this;
        }
        filename = this.activeAssembly.getFile().getAbsolutePath();
        this.atomSelectionOptions.setActiveAtoms(this.activeAssembly);
        this.potential = this.activeAssembly.getPotentialEnergy();
        esv = new File(FilenameUtils.removeExtension((String)filename) + ".esv");
        if (!esv.exists()) {
            esv = null;
        }
        esvSystem = new ExtendedSystem(this.activeAssembly, this.pH, esv);
        esvSystem.setConstantPh(this.pH);
        if (this.potential instanceof ForceFieldEnergy) {
            ((ForceFieldEnergy)this.potential).attachExtendedSystem(esvSystem);
        }
        numESVs = esvSystem.getExtendedResidueList().size();
        PhDynamics.logger.info(String.format(" Attached extended system with %d residues.", new Object[]{numESVs}));
        x = new double[this.potential.getNumberOfVariables()];
        this.potential.getCoordinates(x);
        this.potential.energy(x, true);
        systemFilter = this.algorithmFunctions.getFilter();
        if (systemFilter instanceof XYZFilter) {
            xphFilter = new XPHFilter(this.activeAssembly.getFile(), this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties(), esvSystem);
            xphFilter.readFile();
            PhDynamics.logger.info("Reading ESV lambdas from XPH file");
            this.potential.getCoordinates(x);
            this.potential.energy(x, true);
        }
        PhDynamics.logger.info("\n Running molecular dynamics on " + filename);
        this.molecularDynamics = this.dynamicsOptions.getDynamics(this.writeOutOptions, this.potential, this.activeAssembly, this.algorithmListener);
        this.molecularDynamics.attachExtendedSystem(esvSystem, this.titrReport);
        dyn = new File(FilenameUtils.removeExtension((String)filename) + ".dyn");
        if (!dyn.exists()) {
            dyn = null;
        }
        if (!(this.molecularDynamics instanceof MolecularDynamicsOpenMM)) {
            if (this.repEx.getRepEx()) {
                world = Comm.world();
                size = world.size();
                if (size == 1) {
                    System.exit(0);
                }
                pHWindows = Arrays.toString(PhReplicaExchange.setEvenSpacePhLadder(this.pHGap, this.pH, size));
                pHWindows = pHWindows.replace("[", "").replace("]", "").replace(",", " ");
                properties = this.activeAssembly.getProperties();
                pHWindows = properties.getString("pH.Windows", pHWindows);
                temp = pHWindows.split(" +");
                if (temp.length != size) {
                    PhDynamics.logger.severe("pHLadder specified in properties/key file has incorrect number of windows given world.size()");
                }
                pHLadder = new double[size];
                for (i = 0; i < temp.length; ++i) {
                    pHLadder[i] = Double.parseDouble(temp[i]);
                }
                PhDynamics.logger.info("\n Running replica exchange molecular dynamics on " + filename);
                rank = world.rank();
                structureFile = new File(filename);
                newMolAssemblyFile = structureFile.getParent() + File.separator + rank + File.separator + structureFile.getName();
                PhDynamics.logger.info(" Set activeAssembly filename: " + newMolAssemblyFile);
                this.activeAssembly.setFile(new File(newMolAssemblyFile));
                try {
                    pHReplicaExchange = new PhReplicaExchange(this.molecularDynamics, structureFile, this.pH, pHLadder, this.dynamicsOptions.getTemperature(), esvSystem, x, world.size());
                    totalSteps = this.dynamicsOptions.getNumSteps();
                    nSteps = this.repEx.getReplicaSteps();
                    exchangeCycles = (int)(totalSteps / (long)nSteps);
                    if (exchangeCycles <= 0) {
                        exchangeCycles = 1;
                    }
                    pHReplicaExchange.sample(exchangeCycles, nSteps, this.dynamicsOptions.getDt(), this.dynamicsOptions.getReport(), this.dynamicsOptions.getDt() * (double)this.titrSteps - 1.0, this.initDynamics);
                    if (!this.sort) ** GOTO lbl128
                    PhDynamics.sortMyArc(structureFile, size, pHReplicaExchange.getPhScale()[world.rank()], world.rank());
                }
                catch (Exception e) {
                    PhDynamics.logger.severe(" Error during pH replica exchange: " + e.getMessage());
                    return this;
                }
            } else {
                this.molecularDynamics.dynamic(this.dynamicsOptions.getSteps(), this.dynamicsOptions.getDt(), this.dynamicsOptions.getReport(), this.dynamicsOptions.getWrite(), this.dynamicsOptions.getTemperature(), true, dyn);
                esvSystem.writeLambdaHistogram(true);
            }
        } else {
            molecularDynamicsOpenMM = (MolecularDynamicsOpenMM)this.molecularDynamics;
            this.molecularDynamics = this.dynamicsOptions.getDynamics(this.writeOutOptions, this.potential, this.activeAssembly, this.algorithmListener, MDEngine.FFX);
            this.molecularDynamics.attachExtendedSystem(esvSystem, this.titrReport);
            if (this.repEx.getRepEx()) {
                world = Comm.world();
                size = world.size();
                PhDynamics.logger.info("\n Running replica exchange molecular dynamics on " + filename);
                rank = size > 1 ? world.rank() : 0;
                PhDynamics.logger.info(" Rank: " + rank);
                pHWindows = Arrays.toString(PhReplicaExchange.setEvenSpacePhLadder(this.pHGap, this.pH, size));
                pHWindows = pHWindows.replace("[", "").replace("]", "").replace(",", " ");
                properties = this.activeAssembly.getProperties();
                pHWindows = properties.getString("pH.Windows", pHWindows);
                temp = pHWindows.split(" +");
                if (temp.length != size) {
                    PhDynamics.logger.severe("pHLadder specified in properties/key file has incorrect number of windows given world.size()");
                }
                pHLadder = new double[size];
                for (i = 0; i < temp.length; ++i) {
                    pHLadder[i] = Double.parseDouble(temp[i]);
                }
                structureFile = new File(filename);
                rankDirectory = new File(structureFile.getParent() + File.separator + Integer.toString(rank));
                newMolAssemblyFile = rankDirectory.getPath() + File.separator + structureFile.getName();
                PhDynamics.logger.info(" Set activeAssembly filename: " + newMolAssemblyFile);
                this.activeAssembly.setFile(new File(newMolAssemblyFile));
                try {
                    pHReplicaExchange = new PhReplicaExchange(this.molecularDynamics, structureFile, this.pH, pHLadder, this.dynamicsOptions.getTemperature(), esvSystem, x, molecularDynamicsOpenMM, this.potential, world.size());
                    pHReplicaExchange.sample(this.cycles, this.titrSteps, this.coordSteps, this.dynamicsOptions.getDt(), this.dynamicsOptions.getReport(), this.dynamicsOptions.getDt() * (double)this.titrSteps, this.initDynamics);
                    if (!this.sort) ** GOTO lbl128
                    PhDynamics.sortMyArc(structureFile, world.size(), pHReplicaExchange.getPhScale()[world.rank()], world.rank());
                }
                catch (Exception e) {
                    PhDynamics.logger.severe("Error during pH replica exchange with OpenMM: " + e.getMessage());
                    return this;
                }
            } else {
                for (i = 0; i < this.cycles; ++i) {
                    this.molecularDynamics.setCoordinates(x);
                    forceWriteInterval = (double)this.titrSteps * 0.001;
                    this.molecularDynamics.dynamic(this.titrSteps, this.dynamicsOptions.getDt(), this.titrReport, forceWriteInterval, this.dynamicsOptions.getTemperature(), true, dyn);
                    x = this.molecularDynamics.getCoordinates();
                    esvSystem.writeLambdaHistogram(true);
                    this.potential.energy(x);
                    molecularDynamicsOpenMM.setCoordinates(x);
                    if (this.coordSteps == 0) continue;
                    molecularDynamicsOpenMM.dynamic(this.coordSteps, this.dynamicsOptions.getDt(), this.dynamicsOptions.getReport(), this.dynamicsOptions.getWrite(), this.dynamicsOptions.getTemperature(), true, dyn);
                    x = molecularDynamicsOpenMM.getCoordinates();
                }
            }
        }
lbl128:
        // 6 sources

        if (this.printRatio) {
            esvSystem.printProtonationRatios();
        }
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        List<Potential> potentials = this.potential == null ? Collections.emptyList() : Collections.singletonList(this.potential);
        return potentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sortMyArc(File structureFile, int nReplicas, double pH, int myRank) {
        logger.info(" Sorting archive for rank " + myRank);
        String parent = structureFile.getParent();
        String arcName = FilenameUtils.removeExtension((String)structureFile.getName()) + ".arc";
        BufferedReader[] bufferedReaders = new BufferedReader[nReplicas];
        File output = new File(parent + File.separator + myRank + File.separator + arcName + "_sorted");
        try (BufferedWriter out = new BufferedWriter(new FileWriter(output));){
            int i;
            File temp = new File(parent + File.separator + "0" + File.separator + arcName);
            int snapLength = 0;
            int totalLines = 0;
            try (BufferedReader brTemp = new BufferedReader(new FileReader(temp));){
                String data = brTemp.readLine();
                boolean startSnap = false;
                while (data != null) {
                    if (data.contains("pH:")) {
                        boolean bl = startSnap = !startSnap;
                        if (!startSnap) break;
                    }
                    data = brTemp.readLine();
                    ++snapLength;
                }
                totalLines = snapLength;
                while (data != null) {
                    ++totalLines;
                    data = brTemp.readLine();
                }
            }
            int numSnaps = totalLines / snapLength;
            for (i = 0; i < nReplicas; ++i) {
                File file = new File(parent + File.separator + i + File.separator + arcName);
                bufferedReaders[i] = new BufferedReader(new FileReader(file));
            }
            try {
                for (i = 0; i < numSnaps; ++i) {
                    for (int j = 0; j < nReplicas; ++j) {
                        String data = bufferedReaders[j].readLine();
                        while (data != null && !data.contains("pH:")) {
                            data = bufferedReaders[j].readLine();
                        }
                        String[] tokens = data.split(" +");
                        double snapPh = Double.parseDouble(tokens[tokens.length - 3]);
                        for (int k = 0; k < snapLength - 1; ++k) {
                            if (snapPh == pH) {
                                out.write(data + "\n");
                            }
                            data = bufferedReaders[j].readLine();
                        }
                        if (snapPh != pH) continue;
                        out.write("\n");
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                for (int i2 = 0; i2 < nReplicas; ++i2) {
                    if (bufferedReaders[i2] == null) continue;
                    try {
                        bufferedReaders[i2].close();
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

