/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.MinimizeOptions;
import ffx.algorithms.optimize.CrystalMinimize;
import ffx.algorithms.optimize.Minimize;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.XtalEnergy;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.parsers.PDBFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.utilities.FFXBinding;
import ffx.utilities.FileUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.util.FastMath;
import picocli.CommandLine;

@CommandLine.Command(description={" Minimize crystal unit cell parameters."}, name="MinimizeCrystals")
public class MinimizeCrystals
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private MinimizeOptions minimizeOptions;
    @CommandLine.Mixin
    private AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Option(names={"-c", "--coords"}, paramLabel="false", defaultValue="false", description={"Cycle between lattice and coordinate optimization instead of optimizing both together."})
    private boolean coords;
    @CommandLine.Option(names={"-f", "--fractional"}, paramLabel="OFF", defaultValue="OFF", description={"Maintain fractional coordinates during lattice optimization [OFF/MOLECULE/ATOM]."})
    private String fractional;
    @CommandLine.Option(names={"-t", "--tensor"}, paramLabel="false", defaultValue="false", description={"Compute partial derivatives of the energy with respect to unit cell parameters."})
    private boolean tensor;
    @CommandLine.Option(names={"--et", "--energyTolerance"}, paramLabel="1.0e-10", defaultValue="1.0e-10", description={"End minimization if new energy deviates less than this tolerance."})
    private double tolerance;
    @CommandLine.Option(names={"--mi", "--minimumIterations"}, paramLabel="-1", defaultValue="-1", description={"End minimization if it starts to cycle between small coordinate and lattice parameter fluctuations."})
    private int minIterations;
    @CommandLine.Option(names={"--cy", "--cycles"}, paramLabel="-1", defaultValue="-1", description={"End minimization if it has cycled between lattice parameters and coordinates more than this value."})
    private int cycles;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"Atomic coordinate files in PDB or XYZ format."})
    private String filename = null;
    private XtalEnergy xtalEnergy;
    private CrystalMinimize crystalMinimize;

    public MinimizeCrystals() {
    }

    public MinimizeCrystals(FFXBinding binding) {
        super(binding);
    }

    public MinimizeCrystals(String[] args) {
        super(args);
    }

    public MinimizeCrystals run() {
        File saveFile;
        if (!this.init()) {
            return this;
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info("\n Running CrystalMinimize on " + this.filename);
        logger.info("\n RMS gradient convergence criteria: " + this.minimizeOptions.getEps());
        this.atomSelectionOptions.setActiveAtoms(this.activeAssembly);
        ForceFieldEnergy forceFieldEnergy = this.activeAssembly.getPotentialEnergy();
        this.xtalEnergy = new XtalEnergy(forceFieldEnergy, this.activeAssembly, this.coords);
        this.xtalEnergy.setFractionalCoordinateMode(MolecularAssembly.FractionalMode.MOLECULE);
        SystemFilter systemFilter = this.algorithmFunctions.getFilter();
        if (this.fractional != null && !this.fractional.isEmpty()) {
            try {
                MolecularAssembly.FractionalMode mode = MolecularAssembly.FractionalMode.valueOf((String)this.fractional.toUpperCase());
                this.xtalEnergy.setFractionalCoordinateMode(mode);
            }
            catch (Exception ignored) {
                logger.info(" Unrecognized fractional coordinate mode: " + this.fractional);
                logger.info(" Fractional coordinate mode is set to MOLECULE.");
            }
        }
        this.runMinimize();
        if (this.tensor) {
            this.crystalMinimize.printTensor();
        }
        if (!(this.baseDir != null && this.baseDir.exists() && this.baseDir.isDirectory() && this.baseDir.canWrite())) {
            this.baseDir = new File(FilenameUtils.getFullPath((String)this.filename));
        }
        String dirName = this.baseDir.toString() + File.separator;
        String name = FilenameUtils.getName((String)this.filename);
        String ext = FilenameUtils.getExtension((String)name);
        name = FilenameUtils.removeExtension((String)name);
        PDBFilter pdbFilter = null;
        XYZFilter xyzFilter = null;
        if (ext.toUpperCase().contains("XYZ")) {
            saveFile = new File(dirName + name + ".xyz");
            xyzFilter = new XYZFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
            this.algorithmFunctions.saveAsXYZ(this.activeAssembly, saveFile);
        } else if (ext.toUpperCase().contains("ARC")) {
            saveFile = new File(dirName + name + ".arc");
            saveFile = this.algorithmFunctions.versionFile(saveFile);
            xyzFilter = new XYZFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
            this.algorithmFunctions.saveAsXYZ(this.activeAssembly, saveFile);
        } else {
            saveFile = new File(dirName + name + ".pdb");
            saveFile = this.algorithmFunctions.versionFile(saveFile);
            pdbFilter = new PDBFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
            int numModels = systemFilter.countNumModels();
            if (numModels > 1) {
                pdbFilter.setModelNumbering(0);
            }
            pdbFilter.writeFile(saveFile, true, false, false);
        }
        if (systemFilter instanceof XYZFilter || systemFilter instanceof PDBFilter) {
            while (systemFilter.readNext()) {
                if (systemFilter instanceof PDBFilter) {
                    FileUtils.append((File)saveFile, (String)"ENDMDL\n");
                    this.runMinimize();
                    pdbFilter.writeFile(saveFile, true, false, false);
                    continue;
                }
                if (!(systemFilter instanceof XYZFilter)) continue;
                this.runMinimize();
                xyzFilter.writeFile(saveFile, true);
            }
            if (systemFilter instanceof PDBFilter) {
                FileUtils.append((File)saveFile, (String)"END\n");
            }
        }
        return this;
    }

    private void runMinimize() {
        double energy;
        block2: {
            logger.info("\n Crystal Minimizing " + this.activeAssembly.getName());
            this.crystalMinimize = new CrystalMinimize(this.activeAssembly, this.xtalEnergy, this.algorithmListener);
            this.crystalMinimize.minimize(this.minimizeOptions.getNBFGS(), this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
            logger.info("\n Crystal Minimization Complete.");
            energy = this.crystalMinimize.getEnergy();
            if (this.coords) {
                ForceFieldEnergy forceFieldEnergy = this.activeAssembly.getPotentialEnergy();
                Minimize minimize = new Minimize(this.activeAssembly, (Potential)forceFieldEnergy, this.algorithmListener);
                int numCycles = 0;
                do {
                    minimize.minimize(this.minimizeOptions.getNBFGS(), this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
                    double newEnergy = minimize.getEnergy();
                    int status = minimize.getStatus();
                    if (status != 0 || FastMath.abs((double)(newEnergy - energy)) <= this.tolerance) break block2;
                    energy = newEnergy;
                    this.crystalMinimize.minimize(this.minimizeOptions.getNBFGS(), this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
                    newEnergy = this.crystalMinimize.getEnergy();
                    status = this.crystalMinimize.getStatus();
                    if (status != 0 || FastMath.abs((double)(newEnergy - energy)) <= this.tolerance) break block2;
                    energy = newEnergy;
                    if (this.minIterations <= 0) continue;
                    int coordIters = minimize.getIterations();
                    int latticeIters = this.crystalMinimize.getIterations();
                    if (coordIters >= this.minIterations || latticeIters >= this.minIterations) continue;
                    logger.info(String.format(" Current iteration (coords: %3d, lattice: %3d) has exceeded maximum allowable iterations (%3d).", coordIters, latticeIters, this.minIterations));
                    break block2;
                } while (this.cycles <= 0 || ++numCycles < this.cycles);
                logger.info(String.format(" Current cycle (%3d) has exceeded maximum allowable cycles (%3d).", numCycles, this.cycles));
            }
        }
        this.updateTitle(energy);
    }

    @Override
    public List<Potential> getPotentials() {
        List<Object> potentials = this.xtalEnergy == null ? Collections.emptyList() : Collections.singletonList(this.xtalEnergy);
        return potentials;
    }
}

