/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.MinimizeOptions;
import ffx.crystal.Crystal;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.cli.AlchemicalOptions;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.cli.TopologyOptions;
import ffx.potential.parsers.PDBFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.potential.utils.PotentialsFunctions;
import ffx.utilities.FFXBinding;
import ffx.utilities.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Run L-BFGS minimization on a system."}, name="Minimize")
public class Minimize
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private MinimizeOptions minimizeOptions;
    @CommandLine.Mixin
    private AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Mixin
    private AlchemicalOptions alchemicalOptions;
    @CommandLine.Mixin
    private TopologyOptions topologyOptions;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"Atomic coordinate files in PDB or XYZ format."})
    private List<String> filenames = null;
    private MolecularAssembly[] topologies;
    private Potential potential;
    private ffx.algorithms.optimize.Minimize minimize;

    public Minimize() {
    }

    public Minimize(FFXBinding binding) {
        super(binding);
    }

    public Minimize(String[] args) {
        super(args);
    }

    public Minimize run() {
        LambdaInterface linter;
        if (!this.init()) {
            return this;
        }
        int numTopologies = this.topologyOptions.getNumberOfTopologies(this.filenames);
        int threadsPerTopology = this.topologyOptions.getThreadsPerTopology(numTopologies);
        this.topologies = new MolecularAssembly[numTopologies];
        this.alchemicalOptions.setAlchemicalProperties();
        this.topologyOptions.setAlchemicalProperties(numTopologies);
        if (this.filenames == null || this.filenames.isEmpty()) {
            this.activeAssembly = this.getActiveAssembly(null);
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.filenames = new ArrayList<String>();
            this.filenames.add(this.activeAssembly.getFile().getName());
            this.topologies[0] = this.alchemicalOptions.processFile(this.topologyOptions, this.activeAssembly, 0);
        } else {
            logger.info(String.format(" Initializing %d topologies...", numTopologies));
            for (int i = 0; i < numTopologies; ++i) {
                this.topologies[i] = this.alchemicalOptions.openFile((PotentialsFunctions)this.algorithmFunctions, this.topologyOptions, threadsPerTopology, this.filenames.get(i), i);
            }
            this.activeAssembly = this.topologies[0];
        }
        if (this.topologies.length == 1) {
            this.atomSelectionOptions.setActiveAtoms(this.topologies[0]);
        }
        StringBuilder sb = new StringBuilder("\n Minimizing energy of ");
        this.potential = this.topologyOptions.assemblePotential(this.topologies, sb);
        logger.info(sb.toString());
        LambdaInterface lambdaInterface = linter = this.potential instanceof LambdaInterface ? (LambdaInterface)this.potential : null;
        if (linter != null) {
            linter.setLambda(this.alchemicalOptions.getInitialLambda());
        }
        SystemFilter systemFilter = this.algorithmFunctions.getFilter();
        double[] x = new double[this.potential.getNumberOfVariables()];
        this.potential.getCoordinates(x);
        this.potential.energy(x, true);
        this.minimize = new ffx.algorithms.optimize.Minimize(this.topologies[0], this.potential, this.algorithmListener);
        this.minimize.minimize(this.minimizeOptions.getNBFGS(), this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
        this.potential.getCoordinates(x);
        this.activeAssembly = systemFilter.getActiveMolecularSystem();
        this.updateTitle(this.potential.energy(x, true));
        if (this.topologies.length > 1) {
            for (MolecularAssembly molecularAssembly : this.topologies) {
                String modelFilename = molecularAssembly.getFile().getAbsolutePath();
                if (!(this.baseDir != null && this.baseDir.exists() && this.baseDir.isDirectory() && this.baseDir.canWrite())) {
                    this.baseDir = new File(FilenameUtils.getFullPath((String)modelFilename));
                }
                String dirName = this.baseDir.toString() + File.separator;
                String fileName = FilenameUtils.getName((String)modelFilename);
                String ext = FilenameUtils.getExtension((String)fileName);
                fileName = FilenameUtils.removeExtension((String)fileName);
                if (ext.toUpperCase().contains("XYZ")) {
                    this.algorithmFunctions.saveAsXYZ(molecularAssembly, new File(dirName + fileName + ".xyz"));
                    continue;
                }
                this.algorithmFunctions.saveAsPDB(molecularAssembly, new File(dirName + fileName + ".pdb"));
            }
        } else {
            XYZFilter writeFilter;
            File saveFile;
            this.activeAssembly = this.topologies[0];
            String modelFilename = this.activeAssembly.getFile().getAbsolutePath();
            if (!(this.baseDir != null && this.baseDir.exists() && this.baseDir.isDirectory() && this.baseDir.canWrite())) {
                this.baseDir = new File(FilenameUtils.getFullPath((String)modelFilename));
            }
            String dirName = this.baseDir.toString() + File.separator;
            String fileName = FilenameUtils.getName((String)modelFilename);
            String ext = FilenameUtils.getExtension((String)fileName);
            fileName = FilenameUtils.removeExtension((String)fileName);
            if (ext.toUpperCase().contains("XYZ")) {
                saveFile = new File(dirName + fileName + ".xyz");
                writeFilter = new XYZFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
                this.algorithmFunctions.saveAsXYZ(this.activeAssembly, saveFile);
            } else if (ext.toUpperCase().contains("ARC")) {
                saveFile = new File(dirName + fileName + ".arc");
                saveFile = this.algorithmFunctions.versionFile(saveFile);
                writeFilter = new XYZFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
                this.algorithmFunctions.saveAsXYZ(this.activeAssembly, saveFile);
            } else {
                saveFile = new File(dirName + fileName + ".pdb");
                saveFile = this.algorithmFunctions.versionFile(saveFile);
                PDBFilter pdbFilter = new PDBFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
                writeFilter = pdbFilter;
                int numModels = systemFilter.countNumModels();
                if (numModels > 1) {
                    pdbFilter.setModelNumbering(0);
                }
                pdbFilter.writeFile(saveFile, true, false, false);
            }
            if (systemFilter instanceof XYZFilter || systemFilter instanceof PDBFilter) {
                while (systemFilter.readNext()) {
                    Crystal crystal = this.activeAssembly.getCrystal();
                    ForceFieldEnergy forceFieldEnergy = this.activeAssembly.getPotentialEnergy();
                    forceFieldEnergy.setCrystal(crystal);
                    if (systemFilter instanceof PDBFilter) {
                        FileUtils.append((File)saveFile, (String)"ENDMDL\n");
                        this.minimize.minimize(this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
                        PDBFilter pdbFilter = (PDBFilter)systemFilter;
                        pdbFilter.writeFile(saveFile, true, false, false);
                        continue;
                    }
                    if (!(systemFilter instanceof XYZFilter)) continue;
                    this.minimize.minimize(this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
                    writeFilter.writeFile(saveFile, true);
                }
                if (systemFilter instanceof PDBFilter) {
                    FileUtils.append((File)saveFile, (String)"END\n");
                }
            }
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.minimize != null) {
            sb.append(this.minimize.toString());
        } else {
            sb.append("No minimization has been performed.");
        }
        return sb.toString();
    }

    public List<Double> getEnergyList() {
        if (this.minimize != null) {
            return this.minimize.getEnergyList();
        }
        return null;
    }

    public double getRMSGradient() {
        if (this.minimize != null) {
            return this.minimize.getRMSGradient();
        }
        return Double.NaN;
    }

    public double getEnergy() {
        if (this.minimize != null) {
            return this.minimize.getEnergy();
        }
        return Double.NaN;
    }

    @Override
    public List<Potential> getPotentials() {
        List<Potential> potentials = this.potential == null ? Collections.emptyList() : Collections.singletonList(this.potential);
        return potentials;
    }
}

