/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import edu.rit.pj.Comm;
import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.ManyBodyOptions;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.algorithms.optimize.TitrationManyBody;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.NamingUtils;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.cli.AlchemicalOptions;
import ffx.potential.parsers.PDBFilter;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import picocli.CommandLine;

@CommandLine.Command(description={" Run ManyBody algorithm on a system."}, name="ManyBody")
public class ManyBody
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private ManyBodyOptions manyBodyOptions;
    @CommandLine.Mixin
    private AlchemicalOptions alchemicalOptions;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"XYZ or PDB input file."})
    private String filename;
    private ForceFieldEnergy potentialEnergy;
    private TitrationManyBody titrationManyBody;

    public ManyBody() {
    }

    public ManyBody(FFXBinding binding) {
        super(binding);
    }

    public ManyBody(String[] args) {
        super(args);
    }

    public ManyBody run() {
        int rank;
        CompositeConfiguration properties;
        boolean lambdaTerm;
        if (!this.init()) {
            return this;
        }
        System.setProperty("sor-scf-fallback", "false");
        System.setProperty("direct-scf-fallback", "true");
        double titrationPH = this.manyBodyOptions.getTitrationPH();
        if (this.manyBodyOptions.getTitration()) {
            System.setProperty("manybody-titration", "true");
        }
        if (lambdaTerm = this.alchemicalOptions.hasSoftcore()) {
            System.setProperty("lambdaterm", "true");
            System.setProperty("elec-lambdaterm", "false");
            System.setProperty("intramolecular-softcore", "true");
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        String listResidues = "";
        if (this.manyBodyOptions.getOnlyTitration() || this.manyBodyOptions.getInterestedResidue() != -1 && this.manyBodyOptions.getInclusionCutoff() != -1.0) {
            listResidues = this.manyBodyOptions.selectInclusionResidues(this.activeAssembly.getResidueList(), this.manyBodyOptions.getInterestedResidue(), this.manyBodyOptions.getOnlyTitration(), this.manyBodyOptions.getInclusionCutoff());
            this.manyBodyOptions.setListResidues(listResidues);
        }
        if ((properties = this.activeAssembly.getProperties()).getBoolean("standardizeAtomNames", false)) {
            NamingUtils.renameAtomsToPDBStandard((MolecularAssembly)this.activeAssembly);
        }
        this.activeAssembly.getPotentialEnergy().setPrintOnFailure(false, false);
        this.potentialEnergy = this.activeAssembly.getPotentialEnergy();
        List<Residue> residues = this.manyBodyOptions.collectResidues(this.activeAssembly);
        if (residues == null || residues.isEmpty()) {
            logger.info(" There are no residues in the active system to optimize.");
            return this;
        }
        if (this.manyBodyOptions.getTitration()) {
            logger.info("\n Adding titration hydrogen to : " + this.filename + "\n");
            ArrayList<Integer> resNumberList = new ArrayList<Integer>();
            for (Residue residue : residues) {
                resNumberList.add(residue.getResidueNumber());
            }
            this.titrationManyBody = new TitrationManyBody(this.filename, this.activeAssembly.getForceField(), resNumberList, titrationPH, this.manyBodyOptions);
            this.activeAssembly = this.titrationManyBody.getProtonatedAssembly();
            this.potentialEnergy = this.activeAssembly.getPotentialEnergy();
        }
        if (lambdaTerm) {
            this.alchemicalOptions.setFirstSystemAlchemistry(this.activeAssembly);
            ForceFieldEnergy lambdaInterface = this.potentialEnergy;
            double lambda = this.alchemicalOptions.getInitialLambda();
            logger.info(String.format(" Setting ManyBody softcore lambda to: %5.3f", lambda));
            lambdaInterface.setLambda(lambda);
        }
        RotamerOptimization rotamerOptimization = new RotamerOptimization(this.activeAssembly, (Potential)this.potentialEnergy, this.algorithmListener);
        rotamerOptimization.setPHRestraint(this.manyBodyOptions.getPHRestraint());
        rotamerOptimization.setpH(titrationPH);
        this.manyBodyOptions.initRotamerOptimization(rotamerOptimization, this.activeAssembly);
        List<Residue> residueList = rotamerOptimization.getResidues();
        logger.info("\n Initial Potential Energy:");
        this.potentialEnergy.energy(false, true);
        logger.info("\n Initial Rotamer Torsion Angles:");
        RotamerLibrary.measureRotamers(residueList, (boolean)false);
        rotamerOptimization.optimize(this.manyBodyOptions.getAlgorithm(residueList.size()));
        boolean isTitrating = false;
        HashSet<Atom> excludeAtoms = new HashSet<Atom>();
        int[] optimalRotamers = rotamerOptimization.getOptimumRotamers();
        if (this.manyBodyOptions.getTitration()) {
            isTitrating = this.titrationManyBody.excludeExcessAtoms(excludeAtoms, optimalRotamers, residueList);
        }
        if ((rank = Comm.world().rank()) == 0) {
            logger.info(" Final Minimum Energy");
            double energy = this.potentialEnergy.energy(false, true);
            if (isTitrating) {
                double phBias = rotamerOptimization.getEnergyExpansion().getTotalRotamerPhBias(residueList, optimalRotamers, titrationPH, this.manyBodyOptions.getPHRestraint());
                logger.info(String.format("\n  Rotamer pH Bias    %16.8f", phBias));
                logger.info(String.format("  Potential with Bias%16.8f\n", phBias + energy));
            }
            properties.setProperty("standardizeAtomNames", (Object)"false");
            File modelFile = this.saveDirFile(this.activeAssembly.getFile());
            PDBFilter pdbFilter = new PDBFilter(modelFile, this.activeAssembly, this.activeAssembly.getForceField(), properties);
            if (this.manyBodyOptions.getTitration()) {
                String remark = String.format("Titration pH: %6.3f", titrationPH);
                if (!pdbFilter.writeFile(modelFile, false, excludeAtoms, true, true, new String[]{remark})) {
                    logger.info(String.format(" Save failed for %s", this.activeAssembly));
                }
            } else if (!pdbFilter.writeFile(modelFile, false, excludeAtoms, true, true)) {
                logger.info(String.format(" Save failed for %s", this.activeAssembly));
            }
        }
        if (this.manyBodyOptions.getTitration()) {
            System.clearProperty("manybody-titration");
        }
        return this;
    }

    public ManyBodyOptions getManyBodyOptions() {
        return this.manyBodyOptions;
    }

    public ForceFieldEnergy getPotential() {
        return this.potentialEnergy;
    }

    @Override
    public List<Potential> getPotentials() {
        List<Object> potentials = this.potentialEnergy == null ? Collections.emptyList() : Collections.singletonList(this.potentialEnergy);
        return potentials;
    }
}

