/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.ManyBodyOptions;
import ffx.algorithms.commands.MutatePDB;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.algorithms.optimize.TitrationManyBody;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.NamingUtils;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.cli.AlchemicalOptions;
import ffx.potential.parsers.PDBFilter;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;
import picocli.CommandLine;

@CommandLine.Command(description={" Run GenZ function for free energy change."}, name="GenZ")
public class GenZ
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private ManyBodyOptions manyBodyOptions;
    @CommandLine.Mixin
    private AlchemicalOptions alchemicalOptions;
    @CommandLine.Option(names={"--resC", "--residueChain"}, paramLabel="A", defaultValue="A", description={"The chain that is mutating."})
    private String mutatingChain;
    @CommandLine.Option(names={"-n", "--residueName"}, paramLabel="ALA", defaultValue="", description={"Mutant residue."})
    private String resName;
    @CommandLine.Option(names={"--rEE", "--ro-ensembleEnergy"}, paramLabel="0.0", defaultValue="0.0", description={"Keep permutations within ensemble Energy kcal/mol from the GMEC."})
    private String ensembleEnergy;
    @CommandLine.Option(names={"--un", "--unfolded"}, paramLabel="false", defaultValue="false", description={"Run the unfolded state tripeptide."})
    private boolean unfolded;
    @CommandLine.Option(names={"--pKa"}, paramLabel="false", defaultValue="false", description={"Calculating protonation populations for pKa shift."})
    private boolean pKa;
    @CommandLine.Option(names={"--pB", "--printBoltzmann"}, paramLabel="false", defaultValue="false", description={"Save the Boltzmann weights of protonated residue and total Boltzmann weights."})
    private boolean printBoltzmann;
    @CommandLine.Option(names={"--pF", "--printFiles"}, paramLabel="false", defaultValue="false", description={"Write to an energy restart file and ensemble file."})
    private boolean printFiles;
    @CommandLine.Option(names={"--rCS", "--recomputeSelf"}, paramLabel="false", defaultValue="false", description={"Recompute the self energies after loading a restart file."})
    private boolean recomputeSelf;
    @CommandLine.Parameters(arity="1", paramLabel="file", defaultValue="", description={"XYZ or PDB input file."})
    private String filename;
    ForceFieldEnergy potentialEnergy;
    private double[][] populationArray;

    public GenZ() {
    }

    public GenZ(FFXBinding binding) {
        super(binding);
    }

    public GenZ(String[] args) {
        super(args);
    }

    public GenZ run() {
        boolean lambdaTerm;
        if (!this.init()) {
            return this;
        }
        System.setProperty("sor-scf-fallback", "false");
        System.setProperty("direct-scf-fallback", "true");
        double titrationPH = this.manyBodyOptions.getTitrationPH();
        double inclusionCutoff = this.manyBodyOptions.getInclusionCutoff();
        int mutatingResidue = this.manyBodyOptions.getInterestedResidue();
        boolean onlyTitration = this.manyBodyOptions.getOnlyTitration();
        double pHRestraint = this.manyBodyOptions.getPHRestraint();
        if (this.manyBodyOptions.getTitration()) {
            System.setProperty("manybody-titration", "true");
        }
        if (lambdaTerm = this.alchemicalOptions.hasSoftcore()) {
            System.setProperty("lambdaterm", "true");
            System.setProperty("elec-lambdaterm", "false");
            System.setProperty("intramolecular-softcore", "true");
        }
        System.setProperty("ro-ensembleEnergy", this.ensembleEnergy);
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        String unfoldedFileName = null;
        if (this.unfolded) {
            unfoldedFileName = "wt" + mutatingResidue + ".pdb";
            List atoms = this.activeAssembly.getAtomList();
            HashSet<Atom> excludeAtoms = new HashSet<Atom>();
            for (Atom atom : atoms) {
                if (atom.getResidueNumber() < mutatingResidue - 1 || atom.getResidueNumber() > mutatingResidue + 1) {
                    excludeAtoms.add(atom);
                    continue;
                }
                if (atom.getResidueNumber() != mutatingResidue - 1 || !"H".equals(atom.getName())) continue;
                excludeAtoms.add(atom);
            }
            File file = new File(unfoldedFileName);
            PDBFilter pdbFilter = new PDBFilter(file, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
            pdbFilter.writeFile(file, false, excludeAtoms, true, true);
            this.activeAssembly = this.getActiveAssembly(unfoldedFileName);
            this.filename = this.activeAssembly.getFile().getAbsolutePath();
        }
        double[] boltzmannWeights = new double[2];
        double[][] titrateBoltzmann = null;
        double totalBoltzmann = 0.0;
        List residueList = this.activeAssembly.getResidueList();
        String mutatedFileName = "";
        if (mutatingResidue != -1) {
            FFXBinding mutatorBinding = new FFXBinding();
            if (this.unfolded) {
                args = new String[]{"-r", String.valueOf(mutatingResidue), "-n", this.resName, unfoldedFileName};
                mutatorBinding.setVariable("args", (Object)args);
            } else {
                args = new String[]{"-r", String.valueOf(mutatingResidue), "-n", this.resName, "--ch", this.mutatingChain, this.filename};
                mutatorBinding.setVariable("args", (Object)args);
            }
            MutatePDB mutatePDB = new MutatePDB(mutatorBinding);
            mutatePDB.run();
            mutatedFileName = (String)mutatorBinding.getVariable("versionFileName");
        }
        String listResidues = "";
        if (mutatingResidue != -1 && inclusionCutoff != -1.0 || onlyTitration) {
            listResidues = this.manyBodyOptions.selectInclusionResidues(residueList, mutatingResidue, onlyTitration, inclusionCutoff);
        }
        int numLoop = 1;
        if (mutatingResidue != -1) {
            numLoop = 2;
        }
        HashSet<Atom> excludeAtoms = new HashSet<Atom>();
        for (int j = 0; j < numLoop; ++j) {
            List<Residue> residues;
            if (j > 0) {
                this.activeAssembly = this.getActiveAssembly(mutatedFileName);
                this.activeAssembly.getPotentialEnergy().energy();
                this.filename = this.activeAssembly.getFile().getAbsolutePath();
            }
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            CompositeConfiguration properties = this.activeAssembly.getProperties();
            if (properties.getBoolean("standardizeAtomNames", false)) {
                NamingUtils.renameAtomsToPDBStandard((MolecularAssembly)this.activeAssembly);
            }
            this.activeAssembly.getPotentialEnergy().setPrintOnFailure(false, false);
            this.potentialEnergy = this.activeAssembly.getPotentialEnergy();
            if (!this.pKa || onlyTitration) {
                this.manyBodyOptions.setListResidues(listResidues);
            }
            if ((residues = this.manyBodyOptions.collectResidues(this.activeAssembly)) == null || residues.isEmpty()) {
                logger.info(" There are no residues in the active system to optimize.");
                return this;
            }
            TitrationManyBody titrationManyBody = null;
            if (this.manyBodyOptions.getTitration()) {
                logger.info("\n Adding titration hydrogen to : " + this.filename + "\n");
                ArrayList<Integer> resNumberList = new ArrayList<Integer>();
                for (Residue residue : residues) {
                    resNumberList.add(residue.getResidueNumber());
                }
                titrationManyBody = new TitrationManyBody(this.filename, this.activeAssembly.getForceField(), resNumberList, titrationPH, this.manyBodyOptions);
                this.activeAssembly = titrationManyBody.getProtonatedAssembly();
                this.potentialEnergy = this.activeAssembly.getPotentialEnergy();
            }
            if (lambdaTerm) {
                this.alchemicalOptions.setFirstSystemAlchemistry(this.activeAssembly);
                ForceFieldEnergy lambdaInterface = this.potentialEnergy;
                double lambda = this.alchemicalOptions.getInitialLambda();
                logger.info(String.format(" Setting ManyBody softcore lambda to: %5.3f", lambda));
                lambdaInterface.setLambda(lambda);
            }
            RotamerOptimization rotamerOptimization = new RotamerOptimization(this.activeAssembly, (Potential)this.potentialEnergy, this.algorithmListener);
            rotamerOptimization.setPrintFiles(this.printFiles);
            rotamerOptimization.setWriteEnergyRestart(this.printFiles);
            rotamerOptimization.setPHRestraint(pHRestraint);
            rotamerOptimization.setRecomputeSelf(this.recomputeSelf);
            rotamerOptimization.setpH(titrationPH);
            this.manyBodyOptions.initRotamerOptimization(rotamerOptimization, this.activeAssembly);
            List<Residue> selectedResidues = rotamerOptimization.getResidues();
            rotamerOptimization.initFraction(selectedResidues);
            logger.info("\n Initial Potential Energy:");
            this.potentialEnergy.energy(false, true);
            logger.info("\n Initial Rotamer Torsion Angles:");
            RotamerLibrary.measureRotamers(selectedResidues, (boolean)false);
            rotamerOptimization.optimize(this.manyBodyOptions.getAlgorithm(selectedResidues.size()));
            int[] currentRotamers = new int[selectedResidues.size()];
            try {
                rotamerOptimization.getFractions(selectedResidues.toArray(new Residue[0]), 0, currentRotamers);
            }
            catch (Exception e) {
                logger.severe(" Error calculating fractions: " + e.getMessage());
                return this;
            }
            boltzmannWeights[j] = rotamerOptimization.getTotalBoltzmann();
            this.populationArray = rotamerOptimization.getFraction();
            if (this.printBoltzmann) {
                titrateBoltzmann = rotamerOptimization.getPopulationBoltzmann();
                totalBoltzmann = rotamerOptimization.getTotalBoltzmann();
            }
            int[] optimalRotamers = rotamerOptimization.getOptimumRotamers();
            if (this.manyBodyOptions.getTitration()) {
                titrationManyBody.excludeExcessAtoms(excludeAtoms, optimalRotamers, selectedResidues);
            }
            if (this.pKa) {
                rotamerOptimization.getProtonationPopulations(selectedResidues.toArray(new Residue[0]));
            }
            Object populationFilename = "populations.txt";
            if (j > 0) {
                populationFilename = "populations." + j + ".txt";
            }
            try (FileWriter fileWriter = new FileWriter((String)populationFilename);){
                int residueIndex = 0;
                for (Residue residue : selectedResidues) {
                    fileWriter.write("\n");
                    double protonationBoltzmannSum = 0.0;
                    Rotamer[] rotamers = residue.getRotamers();
                    block23: for (int rotIndex = 0; rotIndex < rotamers.length; ++rotIndex) {
                        String rotPop = String.format("%.6f", this.populationArray[residueIndex][rotIndex]);
                        fileWriter.write(residue.getName() + residue.getResidueNumber() + "\t" + rotamers[rotIndex].toString() + "\t" + rotPop + "\n");
                        if (!this.pKa) continue;
                        switch (rotamers[rotIndex].getName()) {
                            case "HIS": 
                            case "LYS": 
                            case "GLH": 
                            case "ASH": 
                            case "CYS": {
                                if (!this.printBoltzmann) continue block23;
                                protonationBoltzmannSum += titrateBoltzmann[residueIndex][rotIndex];
                                continue block23;
                            }
                        }
                    }
                    if (this.printBoltzmann) {
                        logger.info("\n Residue " + residue.getName() + residue.getResidueNumber() + " Protonated Boltzmann: " + protonationBoltzmannSum);
                    }
                    ++residueIndex;
                }
                logger.info("\n Total Boltzmann: " + totalBoltzmann);
                logger.info("\n Successfully wrote to the populations file: " + (String)populationFilename);
                continue;
            }
            catch (Exception e) {
                logger.severe("Error writing populations file: " + e.getMessage());
            }
        }
        System.setProperty("standardizeAtomNames", "false");
        File modelFile = this.saveDirFile(this.activeAssembly.getFile());
        PDBFilter pdbFilter = new PDBFilter(modelFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
        if (this.manyBodyOptions.getTitration()) {
            String remark = String.format("Titration pH: %6.3f", titrationPH);
            if (!pdbFilter.writeFile(modelFile, false, excludeAtoms, true, true, new String[]{remark})) {
                logger.info(String.format(" Save failed for %s", this.activeAssembly));
            }
        } else if (!pdbFilter.writeFile(modelFile, false, excludeAtoms, true, true)) {
            logger.info(String.format(" Save failed for %s", this.activeAssembly));
        }
        if (mutatingResidue != -1) {
            CompositeConfiguration properties = this.activeAssembly.getProperties();
            String temp = properties.getString("temperature", "298.15");
            double temperature = 298.15;
            if (temp != null) {
                temperature = Double.parseDouble(temp);
            }
            double kT = temperature * 0.0019872042586408316;
            double dG = -kT * FastMath.log((double)(boltzmannWeights[1] / boltzmannWeights[0]));
            logger.info(String.format("\n Mutation Free Energy Difference: %12.8f (kcal/mol)", dG));
        }
        return this;
    }

    public double[][] getPopulationArray() {
        return this.populationArray;
    }

    public ForceFieldEnergy getPotential() {
        return this.potentialEnergy;
    }
}

