/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import edu.rit.pj.Comm;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.WorkerIntegerForLoop;
import edu.rit.pj.WorkerRegion;
import edu.rit.pj.WorkerTeam;
import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.potential.Utilities;
import ffx.utilities.FFXBinding;
import ffx.utilities.FFXCommand;
import ffx.utilities.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Run an FFX command on a series of files."}, name="ForEachFile")
public class ForEachFile
extends AlgorithmsCommand {
    @CommandLine.Option(names={"--recurse"}, defaultValue="0", paramLabel="0", description={"Maximum recursion level (0 only includes the current directory)."})
    private int recurse;
    @CommandLine.Option(names={"--regex", "--fileSelectionRegex"}, paramLabel=".*", defaultValue=".*", description={"Locate files that match a regular expression ('.*' matches all files)."})
    private String regex;
    @CommandLine.Option(names={"--regex2", "--fileSelectionRegex2"}, paramLabel="", defaultValue="", description={"Locate files that match a 2nd regular expression ('.*' matches all files)."})
    private String regex2;
    @CommandLine.Option(names={"--schedule"}, defaultValue="dynamic", paramLabel="dynamic", description={"Load balancing will use a [Dynamic, Fixed, or Guided] schedule."})
    private String schedule;
    @CommandLine.Option(names={"-v", "--verbose"}, defaultValue="false", paramLabel="false", description={"Print additional logging for errors."})
    private boolean verbose;
    @CommandLine.Unmatched
    private List<String> unmatched = null;
    private Class<? extends FFXCommand> script;
    private List<File> files;
    private boolean twoFilesPerCommand = false;
    private List<File> files2;
    private IntegerSchedule integerSchedule;

    public ForEachFile() {
    }

    public ForEachFile(FFXBinding binding) {
        super(binding);
    }

    public ForEachFile(String[] args) {
        super(args);
    }

    public ForEachFile run() {
        if (!this.init()) {
            return this;
        }
        System.setProperty("pj.use.mpi", "false");
        this.script = ForEachFile.getCommand((String)this.unmatched.get(0));
        if (this.script == null) {
            logger.info(String.format(" %s was not recognized.", this.unmatched.get(0)));
            return this;
        }
        logger.info(String.format(" The %s will be run on each file.", this.script));
        Comm world = Comm.world();
        int numProc = world.size();
        int rank = world.rank();
        if (numProc > 1) {
            logger.info(String.format(" Number of processes:  %d", numProc));
            logger.info(String.format(" Rank of this process: %d", rank));
        }
        this.unmatched.remove(0);
        File cwd = new File(".");
        this.files = FileUtils.traverseFiles((File)cwd, (int)this.recurse, (String)this.regex);
        if (!this.regex2.isEmpty()) {
            this.twoFilesPerCommand = true;
            this.files2 = FileUtils.traverseFiles((File)cwd, (int)this.recurse, (String)this.regex2);
        }
        Collections.sort(this.files);
        if (this.twoFilesPerCommand) {
            if (this.files.size() != this.files2.size()) {
                logger.info(" The number of files matched by the two regular expressions do not agree.");
                logger.info(" The number of files matched by the first regular expression: " + this.files.size());
                for (File file : this.files) {
                    logger.info("  File: " + file.getAbsolutePath());
                }
                logger.info(" The number of files matched by the second regular expression: " + this.files2.size());
                for (File file : this.files2) {
                    logger.info("  File: " + file.getAbsolutePath());
                }
                return this;
            }
            Collections.sort(this.files2);
        }
        try {
            this.integerSchedule = IntegerSchedule.parse((String)this.schedule.toLowerCase());
            logger.info(" Parallel Schedule: " + this.schedule);
        }
        catch (Exception e) {
            this.integerSchedule = IntegerSchedule.dynamic();
            logger.info(" Parallel Schedule: Dynamic");
        }
        WorkerTeam workerTeam = new WorkerTeam(world);
        try {
            workerTeam.execute((WorkerRegion)new ForEachFileRegion(this));
        }
        catch (Exception e) {
            logger.severe("Error executing ForEachFileRegion: " + e.getMessage());
        }
        System.clearProperty("pj.use.mpi");
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        return Collections.emptyList();
    }

    private class ForEachFileRegion
    extends WorkerRegion {
        final /* synthetic */ ForEachFile this$0;

        private ForEachFileRegion(ForEachFile forEachFile) {
            ForEachFile forEachFile2 = forEachFile;
            Objects.requireNonNull(forEachFile2);
            this.this$0 = forEachFile2;
        }

        public void run() throws Exception {
            int numFiles = this.this$0.files.size();
            this.execute(0, numFiles - 1, new ForEachFileLoop(this.this$0));
        }
    }

    private class ForEachFileLoop
    extends WorkerIntegerForLoop {
        final /* synthetic */ ForEachFile this$0;

        private ForEachFileLoop(ForEachFile forEachFile) {
            ForEachFile forEachFile2 = forEachFile;
            Objects.requireNonNull(forEachFile2);
            this.this$0 = forEachFile2;
        }

        public IntegerSchedule schedule() {
            return this.this$0.integerSchedule;
        }

        public void run(int lb, int ub) throws Exception {
            for (int i = lb; i <= ub; ++i) {
                File file = this.this$0.files.get(i);
                if (!file.exists()) {
                    FFXCommand.logger.info(String.format(" Ignoring file that does not exist: %s", file.getAbsolutePath()));
                    continue;
                }
                File dualTopologyFile = null;
                if (this.this$0.twoFilesPerCommand && !(dualTopologyFile = this.this$0.files2.get(i)).exists()) {
                    FFXCommand.logger.info(String.format(" Ignoring dual topology file that does not exist: %s", dualTopologyFile.getAbsolutePath()));
                    continue;
                }
                String path = FilenameUtils.normalize((String)file.getAbsolutePath());
                FFXCommand.logger.info(String.format(" Current File: %s", path));
                String dualTopologyPath = null;
                if (this.this$0.twoFilesPerCommand) {
                    dualTopologyPath = FilenameUtils.normalize((String)dualTopologyFile.getAbsolutePath());
                    FFXCommand.logger.info(String.format(" Current Dual Topology File: %s", dualTopologyPath));
                }
                ArrayList<String> commandArgs = new ArrayList<String>();
                boolean foundFile = false;
                boolean found2File = false;
                for (String arg : this.this$0.unmatched) {
                    if (arg.equalsIgnoreCase("FILE")) {
                        commandArgs.add(path);
                        foundFile = true;
                        continue;
                    }
                    if (this.this$0.twoFilesPerCommand && arg.equalsIgnoreCase("FILE2")) {
                        commandArgs.add(dualTopologyPath);
                        found2File = true;
                        continue;
                    }
                    commandArgs.add(arg);
                }
                if (!foundFile) {
                    commandArgs.add(path);
                }
                if (this.this$0.twoFilesPerCommand && !found2File) {
                    commandArgs.add(dualTopologyPath);
                }
                FFXBinding binding = new FFXBinding();
                binding.setVariable("args", commandArgs);
                FFXCommand command = this.this$0.script.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                command.setBinding(binding);
                try {
                    command.run();
                    continue;
                }
                catch (Exception e) {
                    FFXCommand.logger.info(String.format(" Exception for file: %s", path));
                    if (this.this$0.twoFilesPerCommand) {
                        FFXCommand.logger.info(String.format(" Dual topology file: %s", dualTopologyPath));
                    }
                    if (!this.this$0.verbose) continue;
                    FFXCommand.logger.info(e.toString());
                    FFXCommand.logger.info(Utilities.stackTraceToString((Throwable)e));
                }
            }
        }
    }
}

