/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.crystal.Crystal;
import ffx.numerics.Potential;
import ffx.numerics.math.RunningStatistics;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.parsers.DistanceMatrixFilter;
import ffx.potential.parsers.PDBFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.potential.utils.Clustering;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.util.FastMath;
import picocli.CommandLine;

@CommandLine.Command(description={" Cluster structures using an RMSD matrix."}, name="Cluster")
public class Cluster
extends AlgorithmsCommand {
    @CommandLine.Option(names={"-a", "--algorithm"}, paramLabel="0", defaultValue="0", description={"Algorithm: Multi-K-Means++ (0), Hierarchical (1), or Iterative (2)"})
    private int algorithm;
    @CommandLine.Option(names={"-t", "--trials"}, paramLabel="1000", defaultValue="1000", description={"Number of trials for Multi-K-Means or iterative method."})
    private int trials;
    @CommandLine.Option(names={"--tol", "--tolerance"}, paramLabel="0.5", defaultValue="0.5", description={"Tolerance to determine if points are equivalent (iterative method)."})
    private double tolerance;
    @CommandLine.Option(names={"-k", "--clusters"}, paramLabel="0", defaultValue="0", description={"Maximum number of k-means clusters."})
    private int maxClusters;
    @CommandLine.Option(names={"--rs", "--randomSeed"}, paramLabel="-1", defaultValue="-1", description={"Set the random seed for deterministic clustering (-1 uses the current time)."})
    private long randomSeed;
    @CommandLine.Option(names={"--td", "--threshold"}, paramLabel="2.0", defaultValue="2.0", description={"The distance value where a hierarchical tree flattened into clusters."})
    private double threshold;
    @CommandLine.Option(names={"-w", "--write"}, paramLabel="false", defaultValue="false", description={"Write an archive containing a representative from each cluster."})
    private boolean write;
    @CommandLine.Parameters(arity="1..2", paramLabel="files", description={"The RMSD distance matrix and optionally the corresponding structure archive (required for --write)."})
    private List<String> filenames = null;
    private List<CentroidCluster<Clustering.Conformation>> clusterList;

    public Cluster() {
    }

    public Cluster(FFXBinding binding) {
        super(binding);
    }

    public Cluster(String[] args) {
        super(args);
    }

    public List<CentroidCluster<Clustering.Conformation>> getClusterList() {
        return this.clusterList;
    }

    public Cluster run() {
        if (!this.init()) {
            return this;
        }
        if (this.filenames == null || this.filenames.isEmpty()) {
            logger.info(this.helpString());
            return this;
        }
        ArrayList distMatrix = new ArrayList();
        String filename = this.filenames.get(0);
        DistanceMatrixFilter distanceMatrixFilter = new DistanceMatrixFilter();
        RunningStatistics runningStatistics = distanceMatrixFilter.readDistanceMatrix(filename, distMatrix);
        logger.info(" RMSD Distance Matrix Statistics");
        logger.info(String.format(" RMSD Minimum:  %8.6f", runningStatistics.getMin()));
        logger.info(String.format(" RMSD Maximum:  %8.6f", runningStatistics.getMax()));
        logger.info(String.format(" RMSD Mean:     %8.6f", runningStatistics.getMean()));
        double variance = runningStatistics.getVariance();
        if (!Double.isNaN(variance)) {
            logger.info(String.format(" RMSD Variance: %8.6f\n", variance));
        } else {
            logger.info("");
        }
        if (runningStatistics == null) {
            logger.info(String.format(" The distance matrix %s could not be read in.", filename));
            return this;
        }
        switch (this.algorithm) {
            case 1: {
                logger.info(" Performing Hierarchical Clustering");
                logger.info(String.format("  Cluster separation threshold: %6.4f A.\n", this.threshold));
                this.clusterList = Clustering.hierarchicalClustering(distMatrix, (double)this.threshold);
                break;
            }
            case 2: {
                logger.info(" Performing Iterative Clustering");
                this.clusterList = Clustering.iterativeClustering(distMatrix, (int)this.trials, (double)this.tolerance);
                break;
            }
            default: {
                logger.info(" Performing K-Means++ Clustering");
                int dim = distMatrix.size();
                if (this.maxClusters <= 0 || this.maxClusters >= dim) {
                    int newSize;
                    this.maxClusters = newSize = FastMath.floorDiv((int)dim, (int)2);
                }
                logger.info(String.format("  Number of clusters: %d", this.maxClusters));
                if (this.randomSeed == -1L) {
                    this.randomSeed = System.nanoTime();
                } else {
                    logger.info(String.format("  Random seed:        %d", this.randomSeed));
                }
                logger.info(String.format("  Number of trials:   %d\n", this.trials));
                this.clusterList = Clustering.kMeansClustering(distMatrix, (int)this.maxClusters, (int)this.trials, (long)this.randomSeed);
            }
        }
        boolean verbose = true;
        ArrayList<Integer> representativeConformer = new ArrayList<Integer>();
        Clustering.analyzeClusters(this.clusterList, representativeConformer, (boolean)verbose);
        if (this.write) {
            this.writeStructures(representativeConformer);
        }
        return this;
    }

    private void writeStructures(List<Integer> repStructs) {
        Object saveName = null;
        File structureFile = null;
        if (this.filenames.size() < 2) {
            saveName = FilenameUtils.removeExtension((String)this.filenames.get(0)) + ".arc";
            structureFile = new File((String)saveName);
            if (structureFile.exists()) {
                structureFile = this.algorithmFunctions.versionFile(structureFile);
            } else {
                saveName = FilenameUtils.removeExtension((String)this.filenames.get(0)) + ".pdb";
                structureFile = new File((String)saveName);
                if (structureFile.exists()) {
                    structureFile = this.algorithmFunctions.versionFile(structureFile);
                } else {
                    logger.info(" Please supply an ARC or PDB file corresponding to the distance matrix.");
                    return;
                }
            }
        }
        System.setProperty("vdwterm", "false");
        if (structureFile == null) {
            saveName = this.filenames.get(1);
            structureFile = new File(this.algorithmFunctions.versionFile((String)saveName));
        }
        File saveFile = new File(this.algorithmFunctions.versionFile((String)saveName));
        logger.info(String.format("\n Saving representative cluster members to %s.", structureFile.toString()));
        MolecularAssembly[] molecularAssemblies = this.algorithmFunctions.openAll((String)saveName);
        this.activeAssembly = molecularAssemblies[0];
        SystemFilter systemFilter = this.algorithmFunctions.getFilter();
        PDBFilter pdbFilter = null;
        XYZFilter xyzFilter = null;
        if (systemFilter instanceof PDBFilter) {
            pdbFilter = new PDBFilter(structureFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
        } else if (systemFilter instanceof XYZFilter) {
            xyzFilter = new XYZFilter(structureFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
        } else {
            logger.info(" Unknown file type.");
            return;
        }
        logger.info("\n Conformations: ");
        int structNum = 0;
        do {
            if (repStructs.contains(structNum)) {
                int clusterNum = repStructs.indexOf(structNum);
                Crystal crystal = this.activeAssembly.getCrystal();
                ForceFieldEnergy forceFieldEnergy = this.activeAssembly.getPotentialEnergy();
                forceFieldEnergy.setCrystal(crystal);
                if (crystal.aperiodic()) {
                    logger.info(String.format(" Conformation %d, Cluster %d)", structNum + 1, clusterNum + 1));
                } else {
                    logger.info(String.format(" Conformation %d, Cluster %d (%s)", structNum + 1, clusterNum + 1, crystal.getUnitCell().toShortString()));
                }
                if (systemFilter instanceof PDBFilter) {
                    pdbFilter.writeFile(structureFile, true, false, false);
                } else if (systemFilter instanceof XYZFilter) {
                    String[] message = new String[]{String.format(" Conformation %d, Cluster %d ", structNum + 1, clusterNum + 1)};
                    xyzFilter.writeFile(structureFile, true, message);
                }
            }
            ++structNum;
        } while (systemFilter.readNext(false, false));
        if (systemFilter instanceof PDBFilter) {
            try (FileWriter fw = new FileWriter(structureFile, true);){
                fw.append("END\n");
            }
            catch (IOException e) {
                logger.warning("Error appending END to PDB file: " + e.getMessage());
            }
        }
        systemFilter.closeReader();
    }

    @Override
    public List<Potential> getPotentials() {
        return Collections.emptyList();
    }
}

