/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.cli;

import ffx.algorithms.optimize.RotamerOptimization;
import ffx.numerics.math.DoubleMath;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Logger;
import picocli.CommandLine;

public class ManyBodyOptions {
    private static final Logger logger = Logger.getLogger(ManyBodyOptions.class.getName());
    @CommandLine.ArgGroup(heading="%n Many-Body Optimization Options%n", validate=false)
    private final ManyBodyOptionGroup group = new ManyBodyOptionGroup();
    @CommandLine.ArgGroup(heading="%n Many-Body Box Optimization Options%n", validate=false)
    private final BoxOptionGroup boxGroup = new BoxOptionGroup();
    @CommandLine.ArgGroup(heading="%n Many-Body Window Optimization Options%n", validate=false)
    private final WindowOptionGroup windowGroup = new WindowOptionGroup();
    @CommandLine.ArgGroup(heading="%n Many-Body Energy Expansion and Cut-off Options%n", validate=false)
    private final EnergyOptionGroup energyGroup = new EnergyOptionGroup();
    @CommandLine.ArgGroup(heading="%n Many-Body Residue Selection Options%n", validate=false)
    private final ResidueOptionGroup residueGroup = new ResidueOptionGroup();
    private RotamerOptimization rotamerOptimization;
    private RotamerLibrary rotamerLibrary;

    public void initRotamerOptimization(RotamerOptimization rotamerOptimization, MolecularAssembly activeAssembly) {
        this.rotamerOptimization = rotamerOptimization;
        List<Residue> residues = this.collectResidues(activeAssembly);
        rotamerOptimization.setResidues(residues);
        rotamerOptimization.setRotamerLibrary(this.rotamerLibrary);
        RotamerOptimization.Algorithm algorithm = this.getAlgorithm(residues.size());
        rotamerOptimization.setDecomposeOriginal(this.group.decompose);
        rotamerOptimization.setUseGoldstein(!this.group.dee);
        rotamerOptimization.setRevert(this.group.revert);
        boolean monteCarloBool = this.group.monteCarlo > 1;
        rotamerOptimization.setMonteCarlo(monteCarloBool, this.group.monteCarlo);
        if (!this.group.energyRestart.equalsIgnoreCase("none")) {
            File energyRestartFile = new File(this.group.energyRestart);
            rotamerOptimization.setEnergyRestartFile(energyRestartFile);
        }
        rotamerOptimization.setTwoBodyCutoff(this.energyGroup.twoBodyCutoff);
        rotamerOptimization.setThreeBodyEnergy(this.energyGroup.threeBody);
        rotamerOptimization.setThreeBodyCutoff(this.energyGroup.threeBodyCutoff);
        rotamerOptimization.setDistanceCutoff(this.energyGroup.cutoff);
        rotamerOptimization.setPruning(this.energyGroup.prune);
        rotamerOptimization.setSingletonClashThreshold(this.energyGroup.clashThreshold);
        rotamerOptimization.setPairClashThreshold(this.energyGroup.pairClashThreshold);
        if (algorithm == RotamerOptimization.Algorithm.WINDOW) {
            rotamerOptimization.setWindowSize(this.windowGroup.window);
            rotamerOptimization.setIncrement(this.windowGroup.increment);
        } else if (algorithm == RotamerOptimization.Algorithm.BOX) {
            this.parseBoxSelection();
            if (this.boxGroup.approxBoxLength < 0.0) {
                logger.info(" Negative box length value changed to -1 * input.");
                this.boxGroup.approxBoxLength *= -1.0;
            }
            rotamerOptimization.setBoxBorderSize(this.boxGroup.boxBorderSize);
            rotamerOptimization.setApproxBoxLength(this.boxGroup.approxBoxLength);
            rotamerOptimization.setNumXYZBoxes(this.boxGroup.numXYZBoxes);
            rotamerOptimization.setBoxInclusionCriterion(this.boxGroup.boxInclusionCriterion);
            rotamerOptimization.setBoxStart(this.boxGroup.initialBox);
            rotamerOptimization.setBoxEnd(this.boxGroup.finalBox);
            rotamerOptimization.setTitrationBoxes(this.boxGroup.boxTitration);
            rotamerOptimization.setTitrationBoxSize(this.boxGroup.approxBoxLength);
        }
    }

    public List<Residue> collectResidues(MolecularAssembly activeAssembly) {
        Polymer[] polymers;
        this.initRotamerLibrary(true);
        if (!this.residueGroup.listResidues.isEmpty() && !this.residueGroup.listResidues.equalsIgnoreCase("none")) {
            ArrayList stringList = new ArrayList();
            String[] tok = this.residueGroup.listResidues.split(",");
            Collections.addAll(stringList, tok);
            ArrayList<Residue> residueList = new ArrayList<Residue>();
            Polymer[] polymers2 = activeAssembly.getChains();
            for (String s : stringList) {
                Character chainID = Character.valueOf(s.charAt(0));
                int i = Integer.parseInt(s.substring(1));
                for (Polymer polymer : polymers2) {
                    if (polymer.getChainID() != chainID) continue;
                    List residues = polymer.getResidues();
                    for (Residue residue : residues) {
                        Rotamer[] rotamers;
                        if (residue.getResidueNumber() != i || (rotamers = residue.setRotamers(this.rotamerLibrary)) == null || rotamers.length <= 0) continue;
                        residueList.add(residue);
                    }
                }
            }
            return residueList;
        }
        if (this.residueGroup.finish < this.residueGroup.start) {
            this.residueGroup.finish = Integer.MAX_VALUE;
        }
        Character chainID = null;
        if (!this.residueGroup.chain.equalsIgnoreCase("-1")) {
            chainID = Character.valueOf(this.residueGroup.chain.charAt(0));
        }
        ArrayList<Residue> residueList = new ArrayList<Residue>();
        for (Polymer polymer : polymers = activeAssembly.getChains()) {
            if (chainID != null && chainID != polymer.getChainID()) continue;
            List residues = polymer.getResidues();
            for (Residue residue : residues) {
                Rotamer[] rotamers;
                int resID = residue.getResidueNumber();
                if (resID < this.residueGroup.start || resID > this.residueGroup.finish || (rotamers = residue.setRotamers(this.rotamerLibrary)) == null) continue;
                residueList.add(residue);
            }
        }
        return residueList;
    }

    public RotamerOptimization.Algorithm getAlgorithm(int numResidues) {
        if (this.group.algorithm == 0) {
            if (numResidues < 100) {
                return RotamerOptimization.Algorithm.ALL;
            }
            return RotamerOptimization.Algorithm.BOX;
        }
        return RotamerOptimization.Algorithm.getAlgorithm(this.group.algorithm);
    }

    public boolean getUsingOriginalCoordinates() {
        return !this.group.noOriginal;
    }

    public void setOriginalCoordinates(boolean useOrig) {
        this.group.noOriginal = !useOrig;
    }

    public double getApproximate() {
        return this.rotamerOptimization.getApproximate();
    }

    public File getRestartFile() {
        return this.rotamerOptimization.getRestartFile();
    }

    public RotamerLibrary getRotamerLibrary(boolean reinit) {
        this.initRotamerLibrary(reinit);
        return this.rotamerLibrary;
    }

    private void initRotamerLibrary(boolean reinit) {
        if (this.rotamerLibrary == null || reinit) {
            boolean useOrigCoordsRotamer;
            boolean bl = useOrigCoordsRotamer = !this.group.noOriginal;
            if (this.group.decompose) {
                useOrigCoordsRotamer = true;
            }
            this.rotamerLibrary = new RotamerLibrary(RotamerLibrary.ProteinLibrary.intToProteinLibrary((int)this.group.library), useOrigCoordsRotamer);
        }
    }

    private void parseBoxSelection() {
        String input = this.boxGroup.numBoxes;
        Scanner boxNumInput = new Scanner(input);
        boxNumInput.useDelimiter(",");
        int inputLoopCounter = 0;
        int[] numXYZBoxes = new int[3];
        numXYZBoxes[0] = 3;
        while (inputLoopCounter < 3) {
            if (boxNumInput.hasNextInt()) {
                numXYZBoxes[inputLoopCounter] = boxNumInput.nextInt();
                ++inputLoopCounter;
                continue;
            }
            if (boxNumInput.hasNextDouble()) {
                numXYZBoxes[inputLoopCounter] = (int)Math.floor(boxNumInput.nextDouble());
                ++inputLoopCounter;
                logger.info(" Double input to nB truncated to integer.");
                continue;
            }
            if (boxNumInput.hasNext()) {
                logger.info(" Non-numeric input to nB discarded");
                boxNumInput.next();
                continue;
            }
            logger.info(" Insufficient input to nB. Non-input values assumed either equal to X or default to 3");
            break;
        }
        boxNumInput.close();
        for (int i = inputLoopCounter; i < 3; ++i) {
            numXYZBoxes[i] = numXYZBoxes[0];
        }
        int totalCount = 1;
        for (int i = 0; i < 3; ++i) {
            if (numXYZBoxes[i] == 0) {
                numXYZBoxes[i] = 3;
                logger.info(" Input of 0 to nB reset to default of 3.");
            } else if (numXYZBoxes[i] < 0) {
                numXYZBoxes[i] = -1 * numXYZBoxes[i];
                logger.info(" Input of negative number to nB reset to positive number");
            }
            totalCount *= numXYZBoxes[i];
        }
        this.boxGroup.numXYZBoxes = numXYZBoxes;
        if (this.boxGroup.initialBox < 0) {
            this.boxGroup.initialBox = 0;
        }
        if (this.boxGroup.finalBox < 0 || this.boxGroup.finalBox > totalCount) {
            this.boxGroup.finalBox = totalCount;
        }
    }

    private void setRotOptProperties(RotamerOptimization.Algorithm algorithm) {
    }

    public void setAlgorithm(int algorithm) {
        this.group.algorithm = algorithm;
    }

    public int getLibrary() {
        return this.group.library;
    }

    public void setLibrary(int library) {
        this.group.library = library;
    }

    public String getNaLibraryName() {
        return this.group.naLibraryName;
    }

    public void setNaLibraryName(String naLibraryName) {
        this.group.naLibraryName = naLibraryName;
    }

    public boolean isDee() {
        return this.group.dee;
    }

    public void setDee(boolean dee) {
        this.group.dee = dee;
    }

    public String getChain() {
        return this.residueGroup.chain;
    }

    public void setChain(String chain) {
        this.residueGroup.chain = chain;
    }

    public boolean getOnlyTitration() {
        return this.residueGroup.onlyTitration;
    }

    public void setOnlyTitration(boolean onlyTitration) {
        this.residueGroup.onlyTitration = onlyTitration;
    }

    public int getInterestedResidue() {
        return this.residueGroup.interestedResidue;
    }

    public void setInterestedResidue(int interestedResidue) {
        this.residueGroup.interestedResidue = interestedResidue;
    }

    public double getInclusionCutoff() {
        return this.residueGroup.inclusionCutoff;
    }

    public void setInclusionCutoff(double inclusionCutoff) {
        this.residueGroup.inclusionCutoff = inclusionCutoff;
    }

    public int getStart() {
        return this.residueGroup.start;
    }

    public void setStart(int start) {
        this.residueGroup.start = start;
    }

    public int getFinish() {
        return this.residueGroup.finish;
    }

    public void setFinish(int finish) {
        this.residueGroup.finish = finish;
    }

    public double getTwoBodyCutoff() {
        return this.energyGroup.twoBodyCutoff;
    }

    public void setTwoBodyCutoff(double twoBodyCutoff) {
        this.energyGroup.twoBodyCutoff = twoBodyCutoff;
    }

    public boolean isThreeBody() {
        return this.energyGroup.threeBody;
    }

    public void setThreeBody(boolean threeBody) {
        this.energyGroup.threeBody = threeBody;
    }

    public double getThreeBodyCutoff() {
        return this.energyGroup.threeBodyCutoff;
    }

    public void setThreeBodyCutoff(double threeBodyCutoff) {
        this.energyGroup.threeBodyCutoff = threeBodyCutoff;
    }

    public int getPrune() {
        return this.energyGroup.prune;
    }

    public void setPrune(int prune) {
        this.energyGroup.prune = prune;
    }

    public boolean isRevert() {
        return this.group.revert;
    }

    public void setRevert(boolean revert) {
        this.group.revert = revert;
    }

    public String getEnergyRestart() {
        return this.group.energyRestart;
    }

    public void setEnergyRestart(String energyRestart) {
        this.group.energyRestart = energyRestart;
    }

    public boolean isNoOriginal() {
        return this.group.noOriginal;
    }

    public void setNoOriginal(boolean noOriginal) {
        this.group.noOriginal = noOriginal;
    }

    public boolean isDecompose() {
        return this.group.decompose;
    }

    public void setDecompose(boolean decompose) {
        this.group.decompose = decompose;
    }

    public String getListResidues() {
        return this.residueGroup.listResidues;
    }

    public void setListResidues(String listResidues) {
        this.residueGroup.listResidues = listResidues;
    }

    public int getMonteCarlo() {
        return this.group.monteCarlo;
    }

    public void setMonteCarlo(int monteCarlo) {
        this.group.monteCarlo = monteCarlo;
    }

    public boolean isSaveOutput() {
        return this.group.saveOutput;
    }

    public void setSaveOutput(boolean saveOutput) {
        this.group.saveOutput = saveOutput;
    }

    public int getWindow() {
        return this.windowGroup.window;
    }

    public void setWindow(int window) {
        this.windowGroup.window = window;
    }

    public int getIncrement() {
        return this.windowGroup.increment;
    }

    public void setIncrement(int increment) {
        this.windowGroup.increment = increment;
    }

    public double getCutoff() {
        return this.energyGroup.cutoff;
    }

    public void setCutoff(double cutoff) {
        this.energyGroup.cutoff = cutoff;
    }

    public double getClashThreshold() {
        return this.energyGroup.clashThreshold;
    }

    public void setClashThreshold(double clashThreshold) {
        this.energyGroup.clashThreshold = clashThreshold;
    }

    public double getPairClashThreshold() {
        return this.energyGroup.pairClashThreshold;
    }

    public void setPairClashThreshold(double pairClashThreshold) {
        this.energyGroup.pairClashThreshold = pairClashThreshold;
    }

    public String getNumBoxes() {
        return this.boxGroup.numBoxes;
    }

    public void setNumBoxes(String numBoxes) {
        this.boxGroup.numBoxes = numBoxes;
    }

    public double getBoxBorderSize() {
        return this.boxGroup.boxBorderSize;
    }

    public void setBoxBorderSize(double boxBorderSize) {
        this.boxGroup.boxBorderSize = boxBorderSize;
    }

    public double getApproxBoxLength() {
        return this.boxGroup.approxBoxLength;
    }

    public void setApproxBoxLength(double approxBoxLength) {
        this.boxGroup.approxBoxLength = approxBoxLength;
    }

    public int getBoxInclusionCriterion() {
        return this.boxGroup.boxInclusionCriterion;
    }

    public void setBoxInclusionCriterion(int boxInclusionCriterion) {
        this.boxGroup.boxInclusionCriterion = boxInclusionCriterion;
    }

    public void setBoxTitration(boolean boxTitration) {
        this.boxGroup.boxTitration = boxTitration;
    }

    public boolean getBoxTitration() {
        return this.boxGroup.boxTitration;
    }

    public void setTitrationPH(double pH) {
        this.group.titrationPH = pH;
    }

    public double getTitrationPH() {
        return this.group.titrationPH;
    }

    public void setPHRestraint(double pHRestraint) {
        this.energyGroup.pHRestraint = pHRestraint;
    }

    public double getPHRestraint() {
        return this.energyGroup.pHRestraint;
    }

    public boolean isTitrating() {
        return this.group.titrationPH == 0.0;
    }

    public boolean getTitration() {
        return this.group.titration;
    }

    public String selectInclusionResidues(List<Residue> residueList, int mutatingResidue, boolean onlyTitration, double inclusionCutoff) {
        Object listResidues = "";
        if (mutatingResidue != -1 && inclusionCutoff != -1.0) {
            ArrayList<Integer> residueNumber = new ArrayList<Integer>();
            for (Residue residue : residueList) {
                residueNumber.add(residue.getResidueNumber());
            }
            double[] mutatingResCoor = new double[3];
            int index = residueNumber.indexOf(mutatingResidue);
            mutatingResCoor = residueList.get(index).getAtomByName("CA", true).getXYZ(mutatingResCoor);
            for (Residue residue : residueList) {
                double[] currentResCoor = new double[3];
                currentResCoor = residue.getAtomByName("CA", true).getXYZ(currentResCoor);
                double dist = DoubleMath.dist((double[])mutatingResCoor, (double[])currentResCoor);
                if (!(dist < inclusionCutoff)) continue;
                listResidues = (String)listResidues + "," + residue.getChainID() + residue.getResidueNumber();
            }
            listResidues = ((String)listResidues).substring(1);
        } else if (onlyTitration) {
            String[] titratableResidues = new String[]{"HIS", "HIE", "HID", "GLU", "GLH", "ASP", "ASH", "LYS", "LYD", "CYS", "CYD"};
            List<String> titratableResiudesList = Arrays.asList(titratableResidues);
            for (Residue residue : residueList) {
                if (!titratableResiudesList.contains(residue.getName())) continue;
                String titrateResNum = Integer.toString(residue.getResidueNumber());
                if (!((String)listResidues).contains(titrateResNum)) {
                    listResidues = (String)listResidues + "," + residue.getChainID() + titrateResNum;
                }
                if (inclusionCutoff == -1.0) continue;
                for (Residue residue2 : residueList) {
                    String residue2Number;
                    boolean includeResidue = ManyBodyOptions.evaluateAllRotDist(residue, residue2, inclusionCutoff);
                    if (!includeResidue || ((String)listResidues).contains(residue2Number = Integer.toString(residue2.getResidueNumber()))) continue;
                    listResidues = (String)listResidues + "," + residue2.getChainID() + residue2Number;
                }
            }
            listResidues = ((String)listResidues).substring(1);
        }
        return listResidues;
    }

    private static boolean evaluateAllRotDist(Residue residueA, Residue residueB, double inclusionCutoff) {
        residueA.setRotamers(RotamerLibrary.getDefaultLibrary());
        residueB.setRotamers(RotamerLibrary.getDefaultLibrary());
        Rotamer[] rotamersA = residueA.getRotamers();
        Rotamer[] rotamersB = residueB.getRotamers();
        double[] aCoor = new double[3];
        double[] bCoor = new double[3];
        try {
            int a = rotamersA.length;
            int n = rotamersB.length;
        }
        catch (Exception e) {
            return false;
        }
        for (Rotamer rotamerA : rotamersA) {
            residueA.setRotamer(rotamerA);
            for (Rotamer rotamerB : rotamersB) {
                residueB.setRotamer(rotamerB);
                for (Atom atomA : residueA.getAtomList()) {
                    for (Atom atomB : residueB.getAtomList()) {
                        double dist = DoubleMath.dist((double[])atomA.getXYZ(aCoor), (double[])atomB.getXYZ(bCoor));
                        if (!(dist <= inclusionCutoff)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static class ManyBodyOptionGroup {
        @CommandLine.Option(names={"-a", "--algorithm"}, paramLabel="0", defaultValue="0", description={"Algorithm: default automatic settings (0), independent residues (1), all with rotamer elimination (2), all brute force (3), sliding window (4), or box optimization (5)"})
        private int algorithm;
        @CommandLine.Option(names={"-L", "--library"}, paramLabel="2", defaultValue="2", description={"Ponder and Richards (1) or Richardson (2) rotamer library."})
        private int library;
        private String naLibraryName = "Richardson";
        @CommandLine.Option(names={"--dee", "--deadEnd"}, paramLabel="false", defaultValue="false", description={"Use dead-end elimination criteria instead of Goldstein criteria."})
        private boolean dee;
        @CommandLine.Option(names={"-z", "--revert"}, defaultValue="true", description={"Revert unfavorable changes."})
        private boolean revert;
        @CommandLine.Option(names={"--eR", "--energyRestart"}, paramLabel="none", defaultValue="none", description={"Load energy restart file from a previous run (requires that all parameters are the same)."})
        private String energyRestart;
        @CommandLine.Option(names={"-O", "--noOriginal"}, defaultValue="false", description={"Do not include starting coordinates as their own rotamer."})
        private boolean noOriginal;
        @CommandLine.Option(names={"-E", "--decompose"}, defaultValue="false", description={"Print energy decomposition for the input structure (no optimization!)."})
        private boolean decompose;
        @CommandLine.Option(names={"--pH", "--titrationPH"}, paramLabel="0", defaultValue="0", description={" Optimize the titration state of ASP, GLU, HIS and LYS residues at the given pH (pH = 0 turns off titration"})
        private double titrationPH;
        @CommandLine.Option(names={"--tR", "--titration"}, paramLabel="false", defaultValue="false", description={" Turn on titration state optimization"})
        private boolean titration;
        @CommandLine.Option(names={"--mC", "--monteCarlo"}, paramLabel="-1", defaultValue="-1", description={"Follow elimination criteria with (n) Monte Carlo steps, or enumerate all remaining conformations, whichever is smaller."})
        private int monteCarlo;
        private boolean saveOutput;

        private ManyBodyOptionGroup() {
        }
    }

    private static class BoxOptionGroup {
        @CommandLine.Option(names={"--nB", "--numBoxes"}, paramLabel="3,3,3", defaultValue="3,3,3", description={"Specify number of boxes along X, Y, and Z (default: 3,3,3)"})
        private String numBoxes;
        private int[] numXYZBoxes;
        @CommandLine.Option(names={"--bB", "--boxBorderSize"}, paramLabel="0.0", defaultValue="0.0", description={"Extent of overlap between optimization boxes in Angstroms."})
        private double boxBorderSize;
        @CommandLine.Option(names={"--bL", "--approxBoxLength"}, paramLabel="20.0", defaultValue="20.0", description={"Approximate side lengths of boxes to be constructed (over-rides numXYZBoxes)."})
        private double approxBoxLength;
        @CommandLine.Option(names={"--bC", "--boxInclusionCriterion"}, paramLabel="1", defaultValue="1", description={"Criterion to use for adding a residue to a box: (1) uses C alpha only (N1/9 for nucleic acids), (2) uses any atom, and (3) uses any rotamer"})
        private int boxInclusionCriterion;
        @CommandLine.Option(names={"--iB", "--initialBox"}, defaultValue="0", description={"Initial box to optimize."})
        private int initialBox;
        @CommandLine.Option(names={"--fB", "--finalBox"}, defaultValue="2147483647", description={"Final box to optimize."})
        private int finalBox;
        @CommandLine.Option(names={"--bT", "--boxTitration"}, defaultValue="false", description={"Center boxes around titratable residues."})
        private boolean boxTitration;

        private BoxOptionGroup() {
        }
    }

    private static class WindowOptionGroup {
        @CommandLine.Option(names={"--window"}, paramLabel="7", defaultValue="7", description={"Size of the sliding window with respect to adjacent residues."})
        private int window;
        @CommandLine.Option(names={"--increment"}, paramLabel="3", defaultValue="3", description={"Sliding window increment."})
        private int increment;

        private WindowOptionGroup() {
        }
    }

    private static class EnergyOptionGroup {
        @CommandLine.Option(names={"--radius"}, paramLabel="2.0", defaultValue="2.0", description={"The sliding box and window cutoff radius (Angstroms)."})
        private double cutoff;
        @CommandLine.Option(names={"--tC", "--twoBodyCutoff"}, paramLabel="3.0", defaultValue="3.0", description={"Cutoff distance for two body interactions."})
        private double twoBodyCutoff;
        @CommandLine.Option(names={"-T", "--threeBody"}, defaultValue="false", description={"Include 3-Body interactions in the elimination criteria."})
        private boolean threeBody;
        @CommandLine.Option(names={"--thC", "--threeBodyCutoff"}, paramLabel="3.0", defaultValue="3.0", description={"Cutoff distance for three-body interactions."})
        private double threeBodyCutoff;
        @CommandLine.Option(names={"--pr", "--prune"}, paramLabel="1", defaultValue="1", description={"Prune no clashes (0), only single clashes (1), or all clashes (2)"})
        private int prune;
        @CommandLine.Option(names={"--clashThreshold"}, paramLabel="25.0", defaultValue="25.0", description={"The threshold for pruning clashes."})
        private double clashThreshold;
        @CommandLine.Option(names={"--pairClashThreshold"}, paramLabel="25.0", defaultValue="25.0", description={"The threshold for pruning pair clashes."})
        private double pairClashThreshold;
        @CommandLine.Option(names={"--kPH", "--pHRestraint"}, paramLabel="0.0", defaultValue="0.0", description={"Only allow titration state to change fromstandard state is self energy exceeds the restraint."})
        private double pHRestraint = 0.0;

        private EnergyOptionGroup() {
        }
    }

    private static class ResidueOptionGroup {
        @CommandLine.Option(names={"--ch", "--chain"}, paramLabel="<A>", defaultValue="-1", description={"Include only specified chain ID (default: all chains)."})
        private String chain;
        @CommandLine.Option(names={"--sR", "--start"}, defaultValue="-2147483648", description={"Starting residue to optimize (default: all residues)."})
        private int start;
        @CommandLine.Option(names={"--fR", "--final"}, paramLabel="<final>", defaultValue="2147483647", description={"Final residue to optimize (default: all residues)."})
        private int finish;
        @CommandLine.Option(names={"--lR", "--listResidues"}, paramLabel="<list>", defaultValue="none", description={"Select a list of residues to optimize (eg. A11,A24,B40)."})
        private String listResidues;
        @CommandLine.Option(names={"--oT", "--onlyTitration"}, paramLabel="", defaultValue="false", description={"Rotamer optimize only titratable residues."})
        private boolean onlyTitration;
        @CommandLine.Option(names={"--iR", "--interestedResidue"}, paramLabel="", defaultValue="-1", description={"Optimize rotamers within some distance of a specific residue."})
        private int interestedResidue = -1;
        @CommandLine.Option(names={"--iC", "--inclusionCutoff"}, paramLabel="", defaultValue="-1", description={"Distance which rotamers will be included when using only protons, titratable residues, or interested residue."})
        private double inclusionCutoff = -1.0;

        private ResidueOptionGroup() {
        }
    }
}

