/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.cli;

import picocli.CommandLine;

public class LambdaParticleOptions {
    private static final double DEFAULT_THETA_FRICTION = 91.0;
    private static final double DEFAULT_THETA_MASS = 10.0;
    @CommandLine.ArgGroup(heading="%n Lambda Particle Options for MD-OST%n", validate=false)
    private final LambdaParticleOptionGroup group = new LambdaParticleOptionGroup();

    public double getLambdaFriction() {
        return this.group.lambdaFriction;
    }

    public void setLambdaFriction(double lambdaFriction) {
        this.group.lambdaFriction = lambdaFriction;
    }

    public double getLambdaMass() {
        return this.group.lambdaMass;
    }

    public void setLambdaMass(double lambdaMass) {
        this.group.lambdaMass = lambdaMass;
    }

    private static class LambdaParticleOptionGroup {
        @CommandLine.Option(names={"--lm", "--lambdaMass"}, paramLabel="10.0", defaultValue="10.0", description={"Mass of the lambda particle (AMU)."})
        private double lambdaMass = 10.0;
        @CommandLine.Option(names={"--lf", "--lambdaFriction"}, paramLabel="91.0", defaultValue="91.0", description={"Friction on the lambda particle (1/psec)."})
        private double lambdaFriction = 91.0;

        private LambdaParticleOptionGroup() {
        }
    }
}

