/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.cli;

import ffx.algorithms.dynamics.Barostat;
import ffx.crystal.CrystalPotential;
import ffx.potential.MolecularAssembly;
import java.util.logging.Logger;
import picocli.CommandLine;

public class BarostatOptions {
    public static final String DEFAULT_MAX_DENSITY = "1.6";
    public static final String DEFAULT_MIN_DENSITY = "0.75";
    public static final String DEFAULT_MAX_ANGLE_MOVE = "0.5";
    public static final String DEFAULT_MAX_VOLUME_MOVE = "1.0";
    public static final String DEFAULT_BAROSTAT_INTERVAL = "10";
    public static final String DEFAULT_BAROSTAT_PRINT_INTERVAL = "1000";
    private static final Logger logger = Logger.getLogger(BarostatOptions.class.getName());
    @CommandLine.ArgGroup(heading="%n Monte Carlo Pressure Options%n", validate=false)
    private final BarostatOptionGroup group = new BarostatOptionGroup();

    public CrystalPotential checkNPT(MolecularAssembly molecularAssembly, CrystalPotential crystalPotential) {
        if (this.group.pressure > 0.0) {
            return this.createBarostat(molecularAssembly, crystalPotential);
        }
        return crystalPotential;
    }

    public Barostat createBarostat(MolecularAssembly assembly, CrystalPotential crystalPotential) throws IllegalArgumentException {
        if (this.group.pressure > 0.0) {
            Barostat barostat = new Barostat(assembly, crystalPotential);
            barostat.setPressure(this.group.pressure);
            barostat.setIsotropic(this.group.isotropic);
            barostat.setMaxDensity(this.group.maxD);
            barostat.setMinDensity(this.group.minD);
            barostat.setBarostatPrintFrequency(this.group.barPrint);
            double dens = barostat.density();
            if (dens < this.group.minD) {
                logger.info(String.format(" Barostat: initial density %9.4g < minimum density %9.4g, resetting to minimum density", dens, this.group.minD));
                barostat.setDensity(this.group.minD);
            } else if (dens > this.group.maxD) {
                logger.info(String.format(" Barostat: initial density %9.4g > maximum density %9.4g, resetting to maximum density", dens, this.group.maxD));
                barostat.setDensity(this.group.maxD);
            }
            barostat.setMaxAngleMove(this.group.maxAM);
            barostat.setMaxVolumeMove(this.group.maxV);
            barostat.setMeanBarostatInterval(this.group.barInt);
            return barostat;
        }
        throw new IllegalArgumentException(" Pressure is <= 0; cannot create a Barostat!");
    }

    public double getPressure() {
        return this.group.pressure;
    }

    public void setPressure(double pressure) {
        this.group.pressure = pressure;
    }

    public boolean isIsotropic() {
        return this.group.isotropic;
    }

    public void setIsotropic(boolean isotropic) {
        this.group.isotropic = isotropic;
    }

    public double getMaxD() {
        return this.group.maxD;
    }

    public void setMaxD(double maxD) {
        this.group.maxD = maxD;
    }

    public double getMinD() {
        return this.group.minD;
    }

    public void setMinD(double minD) {
        this.group.minD = minD;
    }

    public double getMaxV() {
        return this.group.maxV;
    }

    public double getMaxAM() {
        return this.group.maxAM;
    }

    public void setMaxAM(double maxAM) {
        this.group.maxAM = maxAM;
    }

    public void setMaxV(double maxV) {
        this.group.maxV = maxV;
    }

    public int getBarInt() {
        return this.group.barInt;
    }

    public void setBarInt(int barInt) {
        this.group.barInt = barInt;
    }

    public int getPrintInt() {
        return this.group.barPrint;
    }

    public void setPrintInt(int printInterval) {
        this.group.barPrint = printInterval;
    }

    private static class BarostatOptionGroup {
        @CommandLine.Option(names={"-p", "--npt"}, paramLabel="0", defaultValue="0", description={"Specify use of a MC Barostat at the given pressure; the default 0 disables NPT (atm)."})
        private double pressure = 0.0;
        @CommandLine.Option(names={"--iso", "--isotropic"}, defaultValue="false", description={"Restrict the MC Barostat to isotropic moves."})
        private boolean isotropic = false;
        @CommandLine.Option(names={"--maxD", " --maxDensity"}, paramLabel="1.6", defaultValue="1.6", description={"Specify the maximum density accepted by the MC Barostat (g/cc)."})
        private double maxD = Double.parseDouble("1.6");
        @CommandLine.Option(names={"--minD", " --minDensity"}, paramLabel="0.75", defaultValue="0.75", description={"Specify the minimum density accepted by the MC Barostat (g/cc)."})
        private double minD = Double.parseDouble("0.75");
        @CommandLine.Option(names={"--maxAM", "--maxAngleMove"}, paramLabel="0.5", defaultValue="0.5", description={"Sets the width of proposed crystal angle moves (uniformly distributed) in degrees."})
        private double maxAM = Double.parseDouble("0.5");
        @CommandLine.Option(names={"--maxV", "--maxVolumeMove"}, paramLabel="1.0", defaultValue="1.0", description={"Default maximum volume move for proposed unit cell moves (uniformly distributed) in Angstroms^3."})
        private double maxV = Double.parseDouble("1.0");
        @CommandLine.Option(names={"--barInt", "--meanBarostatInterval"}, paramLabel="10", defaultValue="10", description={"Sets the mean number of MD steps between barostat move proposals."})
        private int barInt = Integer.parseInt("10");
        @CommandLine.Option(names={"--bpi", "--barostatPrintInterval"}, paramLabel="1000", defaultValue="1000", description={"Sets the number of Barostat MC cycles between print statements."})
        private int barPrint = Integer.parseInt("1000");

        private BarostatOptionGroup() {
        }
    }
}

