/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.cli;

import ffx.algorithms.AlgorithmFunctions;
import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.AlgorithmUtils;
import ffx.crystal.Crystal;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.utilities.FFXBinding;
import ffx.utilities.FFXCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Strings;

public class AlgorithmsCommand
extends FFXCommand {
    public AlgorithmFunctions algorithmFunctions;
    public MolecularAssembly activeAssembly;
    public AlgorithmListener algorithmListener;
    protected File baseDir;

    public AlgorithmsCommand() {
    }

    public AlgorithmsCommand(FFXBinding binding) {
        super(binding);
    }

    public AlgorithmsCommand(String[] args) {
        super(args);
    }

    public boolean destroyPotentials() {
        boolean allSucceeded = true;
        for (Potential potent : this.getPotentials()) {
            logger.fine(String.format(" Potential %s is being destroyed. ", potent));
            allSucceeded = allSucceeded && potent.destroy();
        }
        return allSucceeded;
    }

    public List<Potential> getPotentials() {
        ArrayList<Potential> potentials = new ArrayList<Potential>();
        if (this.activeAssembly != null && this.activeAssembly.getPotentialEnergy() != null) {
            potentials.add((Potential)this.activeAssembly.getPotentialEnergy());
        }
        return potentials;
    }

    public List<Potential> getPotentialsFromAssemblies(MolecularAssembly[] assemblies) {
        if (assemblies == null) {
            return new ArrayList<Potential>();
        }
        return Arrays.stream(assemblies).filter(Objects::nonNull).map(MolecularAssembly::getPotentialEnergy).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        if (this.binding.hasVariable("functions")) {
            this.algorithmFunctions = (AlgorithmFunctions)this.binding.getVariable("functions");
        } else {
            this.algorithmFunctions = new AlgorithmUtils();
            this.binding.setVariable("functions", (Object)this.algorithmFunctions);
        }
        this.activeAssembly = null;
        if (this.binding.hasVariable("active")) {
            this.activeAssembly = (MolecularAssembly)this.binding.getVariable("active");
        }
        this.algorithmListener = null;
        if (this.binding.hasVariable("listener")) {
            this.algorithmListener = (AlgorithmListener)this.binding.getVariable("listener");
        }
        if (this.binding.hasVariable("baseDir")) {
            this.baseDir = (File)this.binding.getVariable("baseDir");
        }
        return true;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    protected File saveDirFile(File file) {
        if (!(this.baseDir != null && this.baseDir.exists() && this.baseDir.isDirectory() && this.baseDir.canWrite())) {
            return file;
        }
        String baseName = file.getName();
        String newName = this.baseDir.getAbsolutePath() + File.separator + baseName;
        return new File(newName);
    }

    public MolecularAssembly getActiveAssembly(@Nullable String filename) {
        if (filename != null) {
            MolecularAssembly[] assemblies = new MolecularAssembly[]{this.algorithmFunctions.open(filename)};
            this.activeAssembly = assemblies[0];
        }
        return this.activeAssembly;
    }

    public MolecularAssembly[] getActiveAssemblies(@Nullable String filename) {
        if (filename != null) {
            MolecularAssembly[] assemblies = this.algorithmFunctions.openAll(filename);
            this.activeAssembly = assemblies[0];
            return assemblies;
        }
        MolecularAssembly[] assemblies = new MolecularAssembly[]{this.activeAssembly};
        return assemblies;
    }

    public void updateTitle(double energy) {
        String oldName = this.activeAssembly.getName();
        Crystal crystal = this.activeAssembly.getCrystal();
        if (crystal != null && !crystal.aperiodic()) {
            double density = crystal.getDensity(this.activeAssembly.getMass());
            if (Strings.CI.contains((CharSequence)oldName, (CharSequence)"Energy:") || Strings.CI.contains((CharSequence)oldName, (CharSequence)"Density:")) {
                String[] tokens = oldName.trim().split(" +");
                int numTokens = tokens.length;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < numTokens; ++i) {
                    if (Strings.CI.contains((CharSequence)tokens[i], (CharSequence)"Energy:")) {
                        tokens[i++] = Double.toString(energy);
                        continue;
                    }
                    if (Strings.CI.contains((CharSequence)tokens[i], (CharSequence)"Density:")) {
                        tokens[i++] = Double.toString(density);
                        continue;
                    }
                    sb.append(tokens[i]).append(" ");
                }
                this.activeAssembly.setName(String.format("%s Energy: %9.4f Density: %9.4f", sb, energy, density));
            } else {
                this.activeAssembly.setName(String.format("%s Energy: %9.4f Density: %9.4f", oldName, energy, density));
            }
        } else if (Strings.CI.contains((CharSequence)oldName, (CharSequence)"Energy:")) {
            String[] tokens = oldName.trim().split(" +");
            int numTokens = tokens.length;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < numTokens; ++i) {
                if (Strings.CI.contains((CharSequence)tokens[i], (CharSequence)"Energy:")) {
                    tokens[i++] = Double.toString(energy);
                    continue;
                }
                sb.append(tokens[i]).append(" ");
            }
            this.activeAssembly.setName(String.format("%s Energy: %9.4f", sb, energy));
        } else {
            this.activeAssembly.setName(String.format("%s Energy: %9.4f", oldName, energy));
        }
    }
}

