/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.IntBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.Int2;
import uk.ac.manchester.tornado.api.types.vectors.Int3;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Int4
implements TornadoVectorsInterface<IntBuffer> {
    public static final Class<Int4> TYPE = Int4.class;
    private static final String NUMBER_FORMAT = "{ x=%-7d, y=%-7d, z=%-7d, w=%-7d }";
    private static final int NUM_ELEMENTS = 4;
    @Payload
    private final int[] storage;

    private Int4(int[] storage) {
        this.storage = storage;
    }

    public Int4() {
        this(new int[4]);
    }

    public Int4(int x, int y, int z, int w) {
        this();
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setW(w);
    }

    public static Int4 add(Int4 a, Int4 b) {
        return new Int4(a.getX() + b.getX(), a.getY() + b.getY(), a.getZ() + b.getZ(), a.getW() + b.getW());
    }

    public static Int4 sub(Int4 a, Int4 b) {
        return new Int4(a.getX() - b.getX(), a.getY() - b.getY(), a.getZ() - b.getZ(), a.getW() - b.getW());
    }

    public static Int4 div(Int4 a, Int4 b) {
        return new Int4(a.getX() / b.getX(), a.getY() / b.getY(), a.getZ() / b.getZ(), a.getW() / b.getW());
    }

    public static Int4 mult(Int4 a, Int4 b) {
        return new Int4(a.getX() * b.getX(), a.getY() * b.getY(), a.getZ() * b.getZ(), a.getW() * b.getW());
    }

    public static Int4 min(Int4 a, Int4 b) {
        return new Int4(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()), Math.min(a.getZ(), b.getZ()), Math.min(a.getW(), b.getW()));
    }

    public static Int4 max(Int4 a, Int4 b) {
        return new Int4(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()), Math.max(a.getZ(), b.getZ()), Math.max(a.getW(), b.getW()));
    }

    public static Int4 add(Int4 a, int b) {
        return new Int4(a.getX() + b, a.getY() + b, a.getZ() + b, a.getW() + b);
    }

    public static Int4 sub(Int4 a, int b) {
        return new Int4(a.getX() - b, a.getY() - b, a.getZ() - b, a.getW() - b);
    }

    public static Int4 mult(Int4 a, int b) {
        return new Int4(a.getX() * b, a.getY() * b, a.getZ() * b, a.getW() * b);
    }

    public static Int4 div(Int4 a, int b) {
        return new Int4(a.getX() / b, a.getY() / b, a.getZ() / b, a.getW() / b);
    }

    public static Int4 inc(Int4 a, int value) {
        return Int4.add(a, value);
    }

    public static Int4 dec(Int4 a, int value) {
        return Int4.sub(a, value);
    }

    public static Int4 scale(Int4 a, int value) {
        return Int4.mult(a, value);
    }

    public static Int4 clamp(Int4 x, int min, int max) {
        return new Int4(TornadoMath.clamp(x.getX(), min, max), TornadoMath.clamp(x.getY(), min, max), TornadoMath.clamp(x.getZ(), min, max), TornadoMath.clamp(x.getW(), min, max));
    }

    public static int min(Int4 value) {
        return Math.min(value.getX(), Math.min(value.getY(), Math.min(value.getZ(), value.getW())));
    }

    public static int max(Int4 value) {
        return Math.max(value.getX(), Math.max(value.getY(), Math.max(value.getZ(), value.getW())));
    }

    public static boolean isEqual(Int4 a, Int4 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public int[] toArray() {
        return this.storage;
    }

    public int get(int index) {
        return this.storage[index];
    }

    public void set(int index, int value) {
        this.storage[index] = value;
    }

    public void set(Int4 value) {
        this.setX(value.getX());
        this.setY(value.getY());
        this.setZ(value.getZ());
        this.setW(value.getW());
    }

    public int getX() {
        return this.get(0);
    }

    public void setX(int value) {
        this.set(0, value);
    }

    public int getY() {
        return this.get(1);
    }

    public void setY(int value) {
        this.set(1, value);
    }

    public int getZ() {
        return this.get(2);
    }

    public void setZ(int value) {
        this.set(2, value);
    }

    public int getW() {
        return this.get(3);
    }

    public void setW(int value) {
        this.set(3, value);
    }

    public Int4 duplicate() {
        Int4 vector = new Int4();
        vector.set(this);
        return vector;
    }

    public Int2 asInt2() {
        return new Int2(this.getX(), this.getY());
    }

    public Int3 asInt3() {
        return new Int3(this.getX(), this.getY(), this.getZ());
    }

    public String toString(String fmt) {
        return String.format(fmt, this.getX(), this.getY(), this.getZ(), this.getW());
    }

    public String toString() {
        return this.toString(NUMBER_FORMAT);
    }

    @Override
    public void loadFromBuffer(IntBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public IntBuffer asBuffer() {
        return IntBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    public long getNumBytes() {
        return 16L;
    }
}

