/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.ShortBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Half4
implements TornadoVectorsInterface<ShortBuffer> {
    public static final Class<Half4> TYPE = Half4.class;
    private static final int NUM_ELEMENTS = 4;
    @Payload
    short[] storage = new short[4];

    private Half4(HalfFloat[] storage) {
        this.storage[0] = storage[0].getHalfFloatValue();
        this.storage[1] = storage[1].getHalfFloatValue();
        this.storage[2] = storage[2].getHalfFloatValue();
        this.storage[3] = storage[3].getHalfFloatValue();
    }

    public Half4() {
        this.storage = new short[4];
    }

    public Half4(HalfFloat x, HalfFloat y, HalfFloat z, HalfFloat w) {
        this();
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setW(w);
    }

    public static Half4 add(Half4 a, Half4 b) {
        return new Half4(HalfFloat.add(a.getX(), b.getX()), HalfFloat.add(a.getY(), b.getY()), HalfFloat.add(a.getZ(), b.getZ()), HalfFloat.add(a.getW(), b.getW()));
    }

    public static Half4 sub(Half4 a, Half4 b) {
        return new Half4(HalfFloat.sub(a.getX(), b.getX()), HalfFloat.sub(a.getY(), b.getY()), HalfFloat.sub(a.getZ(), b.getZ()), HalfFloat.sub(a.getW(), b.getW()));
    }

    public static Half4 div(Half4 a, Half4 b) {
        return new Half4(HalfFloat.div(a.getX(), b.getX()), HalfFloat.div(a.getY(), b.getY()), HalfFloat.div(a.getZ(), b.getZ()), HalfFloat.div(a.getW(), b.getW()));
    }

    public static Half4 mult(Half4 a, Half4 b) {
        return new Half4(HalfFloat.mult(a.getX(), b.getX()), HalfFloat.mult(a.getY(), b.getY()), HalfFloat.mult(a.getZ(), b.getZ()), HalfFloat.mult(a.getW(), b.getW()));
    }

    public static Half4 add(Half4 a, HalfFloat b) {
        return new Half4(HalfFloat.add(a.getX(), b), HalfFloat.add(a.getY(), b), HalfFloat.add(a.getZ(), b), HalfFloat.add(a.getW(), b));
    }

    public static Half4 sub(Half4 a, HalfFloat b) {
        return new Half4(HalfFloat.sub(a.getX(), b), HalfFloat.sub(a.getY(), b), HalfFloat.sub(a.getZ(), b), HalfFloat.sub(a.getW(), b));
    }

    public static Half4 mult(Half4 a, HalfFloat b) {
        return new Half4(HalfFloat.mult(a.getX(), b), HalfFloat.mult(a.getY(), b), HalfFloat.mult(a.getZ(), b), HalfFloat.mult(a.getW(), b));
    }

    public static Half4 div(Half4 a, HalfFloat b) {
        return new Half4(HalfFloat.div(a.getX(), b), HalfFloat.div(a.getY(), b), HalfFloat.div(a.getZ(), b), HalfFloat.div(a.getW(), b));
    }

    public static HalfFloat dot(Half4 a, Half4 b) {
        Half4 m = Half4.mult(a, b);
        return HalfFloat.add(HalfFloat.add(m.getX(), m.getY()), HalfFloat.add(m.getZ(), m.getW()));
    }

    public HalfFloat get(int index) {
        return new HalfFloat(this.storage[index]);
    }

    public void set(int index, HalfFloat value) {
        this.storage[index] = value.getHalfFloatValue();
    }

    public void set(Half4 value) {
        this.setX(value.getX());
        this.setY(value.getY());
        this.setZ(value.getZ());
        this.setW(value.getW());
    }

    public HalfFloat getX() {
        return this.get(0);
    }

    public void setX(HalfFloat value) {
        this.set(0, value);
    }

    public HalfFloat getY() {
        return this.get(1);
    }

    public void setY(HalfFloat value) {
        this.set(1, value);
    }

    public HalfFloat getZ() {
        return this.get(2);
    }

    public void setZ(HalfFloat value) {
        this.set(2, value);
    }

    public HalfFloat getW() {
        return this.get(3);
    }

    public void setW(HalfFloat value) {
        this.set(3, value);
    }

    public HalfFloat getS0() {
        return this.get(0);
    }

    public void setS0(HalfFloat value) {
        this.set(0, value);
    }

    public HalfFloat getS1() {
        return this.get(1);
    }

    public void setS1(HalfFloat value) {
        this.set(1, value);
    }

    public HalfFloat getS2() {
        return this.get(2);
    }

    public void setS2(HalfFloat value) {
        this.set(2, value);
    }

    public HalfFloat getS3() {
        return this.get(3);
    }

    public void setS3(HalfFloat value) {
        this.set(3, value);
    }

    public Half4 duplicate() {
        Half4 vector = new Half4();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, Float.valueOf(this.getX().getFloat32()), Float.valueOf(this.getY().getFloat32()), Float.valueOf(this.getZ().getFloat32()), Float.valueOf(this.getW().getFloat32()));
    }

    public String toString() {
        return this.toString("{%.3f,%.3f,%.3f,%.3f}");
    }

    @Override
    public void loadFromBuffer(ShortBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ShortBuffer asBuffer() {
        return ShortBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 4;
    }

    public short[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 8L;
    }
}

