/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.ShortBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.vectors.Half2;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Half3
implements TornadoVectorsInterface<ShortBuffer> {
    public static final Class<Half3> TYPE = Half3.class;
    private static final int NUM_ELEMENTS = 3;
    @Payload
    short[] storage = new short[3];

    private Half3(HalfFloat[] storage) {
        this.storage[0] = storage[0].getHalfFloatValue();
        this.storage[1] = storage[1].getHalfFloatValue();
        this.storage[2] = storage[2].getHalfFloatValue();
    }

    public Half3() {
        this.storage = new short[3];
    }

    public Half3(HalfFloat x, HalfFloat y, HalfFloat z) {
        this();
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    public static Half3 add(Half3 a, Half3 b) {
        return new Half3(HalfFloat.add(a.getX(), b.getX()), HalfFloat.add(a.getY(), b.getY()), HalfFloat.add(a.getZ(), b.getZ()));
    }

    public static Half3 sub(Half3 a, Half3 b) {
        return new Half3(HalfFloat.sub(a.getX(), b.getX()), HalfFloat.sub(a.getY(), b.getY()), HalfFloat.sub(a.getZ(), b.getZ()));
    }

    public static Half3 div(Half3 a, Half3 b) {
        return new Half3(HalfFloat.div(a.getX(), b.getX()), HalfFloat.div(a.getY(), b.getY()), HalfFloat.div(a.getZ(), b.getZ()));
    }

    public static Half3 mult(Half3 a, Half3 b) {
        return new Half3(HalfFloat.mult(a.getX(), b.getX()), HalfFloat.mult(a.getY(), b.getY()), HalfFloat.mult(a.getZ(), b.getZ()));
    }

    public static Half3 add(Half3 a, HalfFloat b) {
        return new Half3(HalfFloat.add(a.getX(), b), HalfFloat.add(a.getY(), b), HalfFloat.add(a.getZ(), b));
    }

    public static Half3 sub(Half3 a, HalfFloat b) {
        return new Half3(HalfFloat.sub(a.getX(), b), HalfFloat.sub(a.getY(), b), HalfFloat.sub(a.getZ(), b));
    }

    public static Half3 mult(Half3 a, HalfFloat b) {
        return new Half3(HalfFloat.mult(a.getX(), b), HalfFloat.mult(a.getY(), b), HalfFloat.mult(a.getZ(), b));
    }

    public static Half3 div(Half3 a, HalfFloat b) {
        return new Half3(HalfFloat.div(a.getX(), b), HalfFloat.div(a.getY(), b), HalfFloat.div(a.getZ(), b));
    }

    public static HalfFloat dot(Half3 a, Half3 b) {
        Half3 m = Half3.mult(a, b);
        return HalfFloat.add(HalfFloat.add(m.getX(), m.getY()), m.getZ());
    }

    public HalfFloat get(int index) {
        return new HalfFloat(this.storage[index]);
    }

    public void set(int index, HalfFloat value) {
        this.storage[index] = value.getHalfFloatValue();
    }

    public void set(Half3 value) {
        this.setX(value.getX());
        this.setY(value.getY());
        this.setZ(value.getZ());
    }

    public HalfFloat getX() {
        return this.get(0);
    }

    public void setX(HalfFloat value) {
        this.set(0, value);
    }

    public HalfFloat getY() {
        return this.get(1);
    }

    public void setY(HalfFloat value) {
        this.set(1, value);
    }

    public HalfFloat getZ() {
        return this.get(2);
    }

    public void setZ(HalfFloat value) {
        this.set(2, value);
    }

    public HalfFloat getS0() {
        return this.get(0);
    }

    public void setS0(HalfFloat value) {
        this.set(0, value);
    }

    public HalfFloat getS1() {
        return this.get(1);
    }

    public void setS1(HalfFloat value) {
        this.set(1, value);
    }

    public HalfFloat getS2() {
        return this.get(2);
    }

    public void setS2(HalfFloat value) {
        this.set(2, value);
    }

    public Half3 duplicate() {
        Half3 vector = new Half3();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, Float.valueOf(this.getX().getFloat32()), Float.valueOf(this.getY().getFloat32()), Float.valueOf(this.getZ().getFloat32()));
    }

    public String toString() {
        return this.toString("{%.3f,%.3f,%.3f}");
    }

    public Half2 aHalf2() {
        return new Half2(this.getX(), this.getY());
    }

    @Override
    public void loadFromBuffer(ShortBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ShortBuffer asBuffer() {
        return ShortBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 3;
    }

    public short[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 6L;
    }
}

