/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.ShortBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Half2
implements TornadoVectorsInterface<ShortBuffer> {
    public static final Class<Half2> TYPE = Half2.class;
    private static final int NUM_ELEMENTS = 2;
    @Payload
    short[] storage = new short[2];

    private Half2(HalfFloat[] storage) {
        this.storage[0] = storage[0].getHalfFloatValue();
        this.storage[1] = storage[1].getHalfFloatValue();
    }

    public Half2() {
        this.storage = new short[2];
    }

    public Half2(HalfFloat x, HalfFloat y) {
        this();
        this.setX(x);
        this.setY(y);
    }

    public static Half2 add(Half2 a, Half2 b) {
        return new Half2(HalfFloat.add(a.getX(), b.getX()), HalfFloat.add(a.getY(), b.getY()));
    }

    public static Half2 sub(Half2 a, Half2 b) {
        return new Half2(HalfFloat.sub(a.getX(), b.getX()), HalfFloat.sub(a.getY(), b.getY()));
    }

    public static Half2 div(Half2 a, Half2 b) {
        return new Half2(HalfFloat.div(a.getX(), b.getX()), HalfFloat.div(a.getY(), b.getY()));
    }

    public static Half2 mult(Half2 a, Half2 b) {
        return new Half2(HalfFloat.mult(a.getX(), b.getX()), HalfFloat.mult(a.getY(), b.getY()));
    }

    public static Half2 add(Half2 a, HalfFloat b) {
        return new Half2(HalfFloat.add(a.getX(), b), HalfFloat.add(a.getY(), b));
    }

    public static Half2 sub(Half2 a, HalfFloat b) {
        return new Half2(HalfFloat.sub(a.getX(), b), HalfFloat.sub(a.getY(), b));
    }

    public static Half2 mult(Half2 a, HalfFloat b) {
        return new Half2(HalfFloat.mult(a.getX(), b), HalfFloat.mult(a.getY(), b));
    }

    public static Half2 div(Half2 a, HalfFloat b) {
        return new Half2(HalfFloat.div(a.getX(), b), HalfFloat.div(a.getY(), b));
    }

    public static void add(Half2 a, Half2 b, Half2 c) {
        c.setX(HalfFloat.add(a.getX(), b.getX()));
        c.setY(HalfFloat.add(a.getY(), b.getY()));
    }

    public static void sub(Half2 a, Half2 b, Half2 c) {
        c.setX(HalfFloat.sub(a.getX(), b.getX()));
        c.setY(HalfFloat.sub(a.getY(), b.getY()));
    }

    public static void mult(Half2 a, Half2 b, Half2 c) {
        c.setX(HalfFloat.mult(a.getX(), b.getX()));
        c.setY(HalfFloat.mult(a.getY(), b.getY()));
    }

    public static HalfFloat dot(Half2 a, Half2 b) {
        Half2 m = Half2.mult(a, b);
        return HalfFloat.add(m.getX(), m.getY());
    }

    public HalfFloat get(int index) {
        return new HalfFloat(this.storage[index]);
    }

    public void set(int index, HalfFloat value) {
        this.storage[index] = value.getHalfFloatValue();
    }

    public void set(Half2 value) {
        this.setX(value.getX());
        this.setY(value.getY());
    }

    public HalfFloat getX() {
        return this.get(0);
    }

    public void setX(HalfFloat value) {
        this.set(0, value);
    }

    public HalfFloat getY() {
        return this.get(1);
    }

    public void setY(HalfFloat value) {
        this.set(1, value);
    }

    public Half2 duplicate() {
        Half2 vector = new Half2();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, Float.valueOf(this.getX().getFloat32()), Float.valueOf(this.getY().getFloat32()));
    }

    public String toString() {
        return this.toString("{%.3f,%.3f}");
    }

    @Override
    public void loadFromBuffer(ShortBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ShortBuffer asBuffer() {
        return ShortBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 2;
    }

    public short[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 4L;
    }
}

