/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.Float4;
import uk.ac.manchester.tornado.api.types.vectors.Int8;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Float8
implements TornadoVectorsInterface<FloatBuffer> {
    public static final Class<Float8> TYPE = Float8.class;
    private static final int NUM_ELEMENTS = 8;
    @Payload
    final float[] storage;

    private Float8(float[] storage) {
        this.storage = storage;
    }

    public Float8() {
        this(new float[8]);
    }

    public Float8(float s0, float s1, float s2, float s3, float s4, float s5, float s6, float s7) {
        this();
        this.setS0(s0);
        this.setS1(s1);
        this.setS2(s2);
        this.setS3(s3);
        this.setS4(s4);
        this.setS5(s5);
        this.setS6(s6);
        this.setS7(s7);
    }

    public static Float8 add(Float8 a, Float8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) + b.get(i));
        }
        return result;
    }

    public static Float8 add(Int8 a, Float8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, (float)a.get(i) + b.get(i));
        }
        return result;
    }

    public static Float8 add(Float8 a, Int8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) + (float)b.get(i));
        }
        return result;
    }

    public static Float8 add(Float8 a, float b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) + b);
        }
        return result;
    }

    public static Float8 sub(Float8 a, Float8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) - b.get(i));
        }
        return result;
    }

    public static Float8 sub(Int8 a, Float8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, (float)a.get(i) - b.get(i));
        }
        return result;
    }

    public static Float8 sub(Float8 a, Int8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) - (float)b.get(i));
        }
        return result;
    }

    public static Float8 sub(Float8 a, float b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) - b);
        }
        return result;
    }

    public static Float8 div(Float8 a, Float8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) / b.get(i));
        }
        return result;
    }

    public static Float8 div(Int8 a, Float8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, (float)a.get(i) / b.get(i));
        }
        return result;
    }

    public static Float8 div(Float8 a, Int8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) / (float)b.get(i));
        }
        return result;
    }

    public static Float8 div(Float8 a, float value) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) / value);
        }
        return result;
    }

    public static Float8 mult(Float8 a, Float8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) * b.get(i));
        }
        return result;
    }

    public static Float8 mult(Int8 a, Float8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, (float)a.get(i) * b.get(i));
        }
        return result;
    }

    public static Float8 mult(Float8 a, Int8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) * (float)b.get(i));
        }
        return result;
    }

    public static Float8 mult(Float8 a, float value) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) * value);
        }
        return result;
    }

    public static Float8 min(Float8 a, Float8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, Math.min(a.get(i), b.get(i)));
        }
        return result;
    }

    public static Float8 min(Int8 a, Float8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, Math.min((float)a.get(i), b.get(i)));
        }
        return result;
    }

    public static Float8 min(Float8 a, Int8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, Math.min(a.get(i), (float)b.get(i)));
        }
        return result;
    }

    public static float min(Float8 value) {
        float result = Float.MAX_VALUE;
        for (int i = 0; i < 8; ++i) {
            result = Math.min(result, value.get(i));
        }
        return result;
    }

    public static Float8 max(Float8 a, Float8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, Math.max(a.get(i), b.get(i)));
        }
        return result;
    }

    public static Float8 max(Int8 a, Float8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, Math.max((float)a.get(i), b.get(i)));
        }
        return result;
    }

    public static Float8 max(Float8 a, Int8 b) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, Math.max(a.get(i), (float)b.get(i)));
        }
        return result;
    }

    public static float max(Float8 value) {
        float result = Float.MIN_VALUE;
        for (int i = 0; i < 8; ++i) {
            result = Math.max(result, value.get(i));
        }
        return result;
    }

    public static Float8 sqrt(Float8 a) {
        Float8 result = new Float8();
        for (int i = 0; i < 8; ++i) {
            a.set(i, TornadoMath.sqrt(a.get(i)));
        }
        return result;
    }

    public static float dot(Float8 a, Float8 b) {
        Float8 m = Float8.mult(a, b);
        return m.getS0() + m.getS1() + m.getS2() + m.getS3() + m.getS4() + m.getS5() + m.getS6() + m.getS7();
    }

    public static boolean isEqual(Float8 a, Float8 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public static float findULPDistance(Float8 value, Float8 expected) {
        return TornadoMath.findULPDistance(value.asBuffer().array(), expected.asBuffer().array());
    }

    public float[] getArray() {
        return this.storage;
    }

    public float get(int index) {
        return this.storage[index];
    }

    public void set(int index, float value) {
        this.storage[index] = value;
    }

    public void set(Float8 value) {
        for (int i = 0; i < 8; ++i) {
            this.set(i, value.get(i));
        }
    }

    public float getS0() {
        return this.get(0);
    }

    public void setS0(float value) {
        this.set(0, value);
    }

    public float getS1() {
        return this.get(1);
    }

    public void setS1(float value) {
        this.set(1, value);
    }

    public float getS2() {
        return this.get(2);
    }

    public void setS2(float value) {
        this.set(2, value);
    }

    public float getS3() {
        return this.get(3);
    }

    public void setS3(float value) {
        this.set(3, value);
    }

    public float getS4() {
        return this.get(4);
    }

    public void setS4(float value) {
        this.set(4, value);
    }

    public float getS5() {
        return this.get(5);
    }

    public void setS5(float value) {
        this.set(5, value);
    }

    public float getS6() {
        return this.get(6);
    }

    public void setS6(float value) {
        this.set(6, value);
    }

    public float getS7() {
        return this.get(7);
    }

    public void setS7(float value) {
        this.set(7, value);
    }

    public Float4 getHigh() {
        return new Float4(this.getS4(), this.getS5(), this.getS6(), this.getS7());
    }

    public Float4 getLow() {
        return new Float4(this.getS0(), this.getS1(), this.getS2(), this.getS3());
    }

    public Float8 duplicate() {
        Float8 vector = new Float8();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, Float.valueOf(this.getS0()), Float.valueOf(this.getS1()), Float.valueOf(this.getS2()), Float.valueOf(this.getS3()), Float.valueOf(this.getS4()), Float.valueOf(this.getS5()), Float.valueOf(this.getS6()), Float.valueOf(this.getS7()));
    }

    public String toString() {
        return this.toString("{%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f}");
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 8;
    }

    public float[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 32L;
    }
}

