/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.DoubleBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.Double2;
import uk.ac.manchester.tornado.api.types.vectors.Double3;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Double4
implements TornadoVectorsInterface<DoubleBuffer> {
    public static final Class<Double4> TYPE = Double4.class;
    private static final int NUM_ELEMENTS = 4;
    @Payload
    final double[] storage;

    private Double4(double[] storage) {
        this.storage = storage;
    }

    public Double4() {
        this(new double[4]);
    }

    public Double4(double x, double y, double z, double w) {
        this();
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setW(w);
    }

    public static Double4 add(Double4 a, Double4 b) {
        return new Double4(a.getX() + b.getX(), a.getY() + b.getY(), a.getZ() + b.getZ(), a.getW() + b.getW());
    }

    public static Double4 sub(Double4 a, Double4 b) {
        return new Double4(a.getX() - b.getX(), a.getY() - b.getY(), a.getZ() - b.getZ(), a.getW() - b.getW());
    }

    public static Double4 div(Double4 a, Double4 b) {
        return new Double4(a.getX() / b.getX(), a.getY() / b.getY(), a.getZ() / b.getZ(), a.getW() / b.getW());
    }

    public static Double4 mult(Double4 a, Double4 b) {
        return new Double4(a.getX() * b.getX(), a.getY() * b.getY(), a.getZ() * b.getZ(), a.getW() * b.getW());
    }

    public static Double4 min(Double4 a, Double4 b) {
        return new Double4(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()), Math.min(a.getZ(), b.getZ()), Math.min(a.getW(), b.getW()));
    }

    public static Double4 max(Double4 a, Double4 b) {
        return new Double4(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()), Math.max(a.getZ(), b.getZ()), Math.max(a.getW(), b.getW()));
    }

    public static Double4 add(Double4 a, double b) {
        return new Double4(a.getX() + b, a.getY() + b, a.getZ() + b, a.getW() + b);
    }

    public static Double4 sub(Double4 a, double b) {
        return new Double4(a.getX() - b, a.getY() - b, a.getZ() - b, a.getW() - b);
    }

    public static Double4 mult(Double4 a, double b) {
        return new Double4(a.getX() * b, a.getY() * b, a.getZ() * b, a.getW() * b);
    }

    public static Double4 div(Double4 a, double b) {
        return new Double4(a.getX() / b, a.getY() / b, a.getZ() / b, a.getW() / b);
    }

    public static Double4 inc(Double4 a, double value) {
        return Double4.add(a, value);
    }

    public static Double4 dec(Double4 a, double value) {
        return Double4.sub(a, value);
    }

    public static Double4 scaleByInverse(Double4 a, double value) {
        return Double4.mult(a, 1.0 / value);
    }

    public static Double4 scale(Double4 a, double value) {
        return Double4.mult(a, value);
    }

    public static Double4 sqrt(Double4 a) {
        return new Double4(TornadoMath.sqrt(a.getX()), TornadoMath.sqrt(a.getY()), TornadoMath.sqrt(a.getZ()), TornadoMath.sqrt(a.getW()));
    }

    public static Double4 floor(Double4 a) {
        return new Double4(TornadoMath.floor(a.getX()), TornadoMath.floor(a.getY()), TornadoMath.floor(a.getZ()), TornadoMath.floor(a.getW()));
    }

    public static Double4 fract(Double4 a) {
        return new Double4(TornadoMath.fract(a.getX()), TornadoMath.fract(a.getY()), TornadoMath.fract(a.getZ()), TornadoMath.fract(a.getW()));
    }

    public static Double4 clamp(Double4 x, double min, double max) {
        return new Double4(TornadoMath.clamp(x.getX(), min, max), TornadoMath.clamp(x.getY(), min, max), TornadoMath.clamp(x.getZ(), min, max), TornadoMath.clamp(x.getW(), min, max));
    }

    public static void normalise(Double4 value) {
        double len = Double4.length(value);
        Double4.scaleByInverse(value, len);
    }

    public static double min(Double4 value) {
        return Math.min(value.getX(), Math.min(value.getY(), Math.min(value.getZ(), value.getW())));
    }

    public static double max(Double4 value) {
        return Math.max(value.getX(), Math.max(value.getY(), Math.max(value.getZ(), value.getW())));
    }

    public static double dot(Double4 a, Double4 b) {
        Double4 m = Double4.mult(a, b);
        return m.getX() + m.getY() + m.getZ() + m.getW();
    }

    public static double length(Double4 value) {
        return TornadoMath.sqrt(Double4.dot(value, value));
    }

    public static boolean isEqual(Double4 a, Double4 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public double get(int index) {
        return this.storage[index];
    }

    public void set(int index, double value) {
        this.storage[index] = value;
    }

    public double[] getArray() {
        return this.storage;
    }

    public void set(Double4 value) {
        this.setX(value.getX());
        this.setY(value.getY());
        this.setZ(value.getZ());
        this.setW(value.getW());
    }

    public double getX() {
        return this.get(0);
    }

    public void setX(double value) {
        this.set(0, value);
    }

    public double getY() {
        return this.get(1);
    }

    public void setY(double value) {
        this.set(1, value);
    }

    public double getZ() {
        return this.get(2);
    }

    public void setZ(double value) {
        this.set(2, value);
    }

    public double getW() {
        return this.get(3);
    }

    public void setW(double value) {
        this.set(3, value);
    }

    public Double4 duplicate() {
        Double4 vector = new Double4();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, this.getX(), this.getY(), this.getZ(), this.getW());
    }

    public String toString() {
        return this.toString("{%.3f,%.3f,%.3f,%.3f}");
    }

    public Double2 asDouble2() {
        return new Double2(this.getX(), this.getY());
    }

    public Double3 asDouble3() {
        return new Double3(this.getX(), this.getY(), this.getZ());
    }

    public Double2 getLow() {
        return this.asDouble2();
    }

    public Double2 getHigh() {
        return new Double2(this.getZ(), this.getW());
    }

    @Override
    public void loadFromBuffer(DoubleBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public DoubleBuffer asBuffer() {
        return DoubleBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 4;
    }

    public void fill(double value) {
        Arrays.fill(this.storage, value);
    }

    public double[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 32L;
    }
}

