/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.DoubleBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Double16
implements TornadoVectorsInterface<DoubleBuffer> {
    public static final Class<Double16> TYPE = Double16.class;
    private static final int NUM_ELEMENTS = 16;
    @Payload
    final double[] storage;

    private Double16(double[] storage) {
        this.storage = storage;
    }

    public Double16() {
        this(new double[16]);
    }

    public Double16(double s0, double s1, double s2, double s3, double s4, double s5, double s6, double s7, double s8, double s9, double s10, double s11, double s12, double s13, double s14, double s15) {
        this();
        this.setS0(s0);
        this.setS1(s1);
        this.setS2(s2);
        this.setS3(s3);
        this.setS4(s4);
        this.setS5(s5);
        this.setS6(s6);
        this.setS7(s7);
        this.setS8(s8);
        this.setS9(s9);
        this.setS10(s10);
        this.setS11(s11);
        this.setS12(s12);
        this.setS13(s13);
        this.setS14(s14);
        this.setS15(s15);
    }

    public static Double16 add(Double16 a, Double16 b) {
        Double16 result = new Double16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) + b.get(i));
        }
        return result;
    }

    public static Double16 add(Double16 a, double b) {
        Double16 result = new Double16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) + b);
        }
        return result;
    }

    public static Double16 sub(Double16 a, Double16 b) {
        Double16 result = new Double16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) - b.get(i));
        }
        return result;
    }

    public static Double16 sub(Double16 a, double b) {
        Double16 result = new Double16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) - b);
        }
        return result;
    }

    public static Double16 div(Double16 a, Double16 b) {
        Double16 result = new Double16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) / b.get(i));
        }
        return result;
    }

    public static Double16 div(Double16 a, double value) {
        Double16 result = new Double16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) / value);
        }
        return result;
    }

    public static Double16 mult(Double16 a, Double16 b) {
        Double16 result = new Double16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) * b.get(i));
        }
        return result;
    }

    public static Double16 mult(Double16 a, double value) {
        Double16 result = new Double16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) * value);
        }
        return result;
    }

    public static Double16 min(Double16 a, Double16 b) {
        Double16 result = new Double16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, Math.min(a.get(i), b.get(i)));
        }
        return result;
    }

    public static double min(Double16 value) {
        double result = Double.MAX_VALUE;
        for (int i = 0; i < 16; ++i) {
            result = Math.min(result, value.get(i));
        }
        return result;
    }

    public static Double16 max(Double16 a, Double16 b) {
        Double16 result = new Double16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, Math.max(a.get(i), b.get(i)));
        }
        return result;
    }

    public static double max(Double16 value) {
        double result = Double.MIN_VALUE;
        for (int i = 0; i < 16; ++i) {
            result = Math.max(result, value.get(i));
        }
        return result;
    }

    public static Double16 sqrt(Double16 a) {
        Double16 result = new Double16();
        for (int i = 0; i < 16; ++i) {
            a.set(i, TornadoMath.sqrt(a.get(i)));
        }
        return result;
    }

    public static double dot(Double16 a, Double16 b) {
        Double16 m = Double16.mult(a, b);
        return m.getS0() + m.getS1() + m.getS2() + m.getS3() + m.getS4() + m.getS5() + m.getS6() + m.getS7() + m.getS8() + m.getS9() + m.getS10() + m.getS11() + m.getS12() + m.getS13() + m.getS14() + m.getS15();
    }

    public static boolean isEqual(Double16 a, Double16 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public static double findULPDistance(Double16 value, Double16 expected) {
        return TornadoMath.findULPDistance(value.asBuffer().array(), expected.asBuffer().array());
    }

    public double[] getArray() {
        return this.storage;
    }

    public double get(int index) {
        return this.storage[index];
    }

    public void set(int index, double value) {
        this.storage[index] = value;
    }

    public void set(Double16 value) {
        for (int i = 0; i < 16; ++i) {
            this.set(i, value.get(i));
        }
    }

    public double getS0() {
        return this.get(0);
    }

    public void setS0(double value) {
        this.set(0, value);
    }

    public double getS1() {
        return this.get(1);
    }

    public void setS1(double value) {
        this.set(1, value);
    }

    public double getS2() {
        return this.get(2);
    }

    public void setS2(double value) {
        this.set(2, value);
    }

    public double getS3() {
        return this.get(3);
    }

    public void setS3(double value) {
        this.set(3, value);
    }

    public double getS4() {
        return this.get(4);
    }

    public void setS4(double value) {
        this.set(4, value);
    }

    public double getS5() {
        return this.get(5);
    }

    public void setS5(double value) {
        this.set(5, value);
    }

    public double getS6() {
        return this.get(6);
    }

    public void setS6(double value) {
        this.set(6, value);
    }

    public double getS7() {
        return this.get(7);
    }

    public void setS7(double value) {
        this.set(7, value);
    }

    public double getS8() {
        return this.get(8);
    }

    public void setS8(double value) {
        this.set(8, value);
    }

    public double getS9() {
        return this.get(9);
    }

    public void setS9(double value) {
        this.set(9, value);
    }

    public double getS10() {
        return this.get(10);
    }

    public void setS10(double value) {
        this.set(10, value);
    }

    public double getS11() {
        return this.get(11);
    }

    public void setS11(double value) {
        this.set(11, value);
    }

    public double getS12() {
        return this.get(12);
    }

    public void setS12(double value) {
        this.set(12, value);
    }

    public double getS13() {
        return this.get(13);
    }

    private void setS13(double value) {
        this.set(13, value);
    }

    public double getS14() {
        return this.get(14);
    }

    public void setS14(double value) {
        this.set(14, value);
    }

    public double getS15() {
        return this.get(15);
    }

    public void setS15(double value) {
        this.set(15, value);
    }

    public Double16 duplicate() {
        Double16 vector = new Double16();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, this.getS0(), this.getS1(), this.getS2(), this.getS3(), this.getS4(), this.getS5(), this.getS6(), this.getS7(), this.getS8(), this.getS9(), this.getS10(), this.getS11(), this.getS12(), this.getS13(), this.getS13(), this.getS14(), this.getS15());
    }

    public String toString() {
        return this.toString("{%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f}");
    }

    @Override
    public void loadFromBuffer(DoubleBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public DoubleBuffer asBuffer() {
        return DoubleBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 16;
    }

    public double[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 128L;
    }
}

