/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.utils;

import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;

public final class StorageFormats {
    private StorageFormats() {
    }

    @Deprecated
    public static int toColumnMajor(int i, int j, int ld) {
        return j * ld + i;
    }

    public static int toRowMajor(int i, int j, int numColumns) {
        return i * numColumns + j;
    }

    public static int toRowMajorVector(int i, int j, int numColumns, int vectorElements) {
        return (i * numColumns + j) * vectorElements;
    }

    public static int toRowMajor3D(int i, int j, int k, int zMax, int yMax) {
        return i * zMax * yMax + j * zMax + k;
    }

    public static int toRowMajor3DVector(int i, int j, int k, int zSize, int ySize, int vectorWidth) {
        return i * zSize * ySize * vectorWidth + j * zSize + k;
    }

    public static int toRowMajor(int i, int j, int ld, int el) {
        return i * ld + j * el;
    }

    public static int toRowMajor(int i, int j, int k, int ld1, int ld2, int el) {
        return StorageFormats.toRowMajor(i, j, ld1, el) + k * ld2;
    }

    public static int toRowMajor(int i, int j, int incm, int incn, int ld) {
        return i * ld * incn + j * incm;
    }

    public static int toFortran(int i, int j, int ld) {
        return (j - 1) * ld + (i - 1);
    }

    public static DoubleArray toRowMajor(double[][] matrix) {
        int cols = matrix[0].length;
        int rows = matrix.length;
        DoubleArray flattenMatrix = new DoubleArray(rows * cols);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                flattenMatrix.set(StorageFormats.toRowMajor(i, j, cols), matrix[i][j]);
            }
        }
        return flattenMatrix;
    }

    public static FloatArray toRowMajor(float[][] matrix) {
        int dimX = matrix.length;
        int dimY = matrix[0].length;
        FloatArray flattenMatrix = new FloatArray(dimX * dimY);
        for (int i = 0; i < dimX; ++i) {
            for (int j = 0; j < dimY; ++j) {
                flattenMatrix.set(StorageFormats.toRowMajor(i, j, dimY), matrix[i][j]);
            }
        }
        return flattenMatrix;
    }

    public static FloatArray toRowMajor3D(float[][][] matrix) {
        int dimX = matrix.length;
        int dimY = matrix[0].length;
        int dimZ = matrix[0][0].length;
        FloatArray flattenMatrix = new FloatArray(dimX * dimY * dimZ);
        for (int i = 0; i < dimX; ++i) {
            for (int j = 0; j < dimY; ++j) {
                for (int k = 0; k < dimZ; ++k) {
                    int index = StorageFormats.toRowMajor3D(i, j, k, dimZ, dimY);
                    flattenMatrix.set(index, matrix[i][j][k]);
                }
            }
        }
        return flattenMatrix;
    }

    public static IntArray toRowMajor3D(int[][][] matrix) {
        int dimX = matrix.length;
        int dimY = matrix[0].length;
        int dimZ = matrix[0][0].length;
        IntArray flattenMatrix = new IntArray(dimX * dimY * dimZ);
        for (int i = 0; i < dimX; ++i) {
            for (int j = 0; j < dimY; ++j) {
                for (int k = 0; k < dimZ; ++k) {
                    int index = StorageFormats.toRowMajor3D(i, j, k, dimZ, dimY);
                    flattenMatrix.set(index, matrix[i][j][k]);
                }
            }
        }
        return flattenMatrix;
    }

    public static DoubleArray toRowMajor3D(double[][][] matrix) {
        int dimX = matrix.length;
        int dimY = matrix[0].length;
        int dimZ = matrix[0][0].length;
        DoubleArray flattenMatrix = new DoubleArray(dimX * dimY * dimZ);
        for (int i = 0; i < dimX; ++i) {
            for (int j = 0; j < dimY; ++j) {
                for (int k = 0; k < dimZ; ++k) {
                    int index = StorageFormats.toRowMajor3D(i, j, k, dimZ, dimY);
                    flattenMatrix.set(index, matrix[i][j][k]);
                }
            }
        }
        return flattenMatrix;
    }

    public static LongArray toRowMajor3D(long[][][] matrix) {
        int dimX = matrix.length;
        int dimY = matrix[0].length;
        int dimZ = matrix[0][0].length;
        LongArray flattenMatrix = new LongArray(dimX * dimY * dimZ);
        for (int i = 0; i < dimX; ++i) {
            for (int j = 0; j < dimY; ++j) {
                for (int k = 0; k < dimZ; ++k) {
                    int index = StorageFormats.toRowMajor3D(i, j, k, dimZ, dimY);
                    flattenMatrix.set(index, matrix[i][j][k]);
                }
            }
        }
        return flattenMatrix;
    }

    public static ShortArray toRowMajor3D(short[][][] matrix) {
        int dimX = matrix.length;
        int dimY = matrix[0].length;
        int dimZ = matrix[0][0].length;
        ShortArray flattenMatrix = new ShortArray(dimX * dimY * dimZ);
        for (int i = 0; i < dimX; ++i) {
            for (int j = 0; j < dimY; ++j) {
                for (int k = 0; k < dimZ; ++k) {
                    int index = StorageFormats.toRowMajor3D(i, j, k, dimZ, dimY);
                    flattenMatrix.set(index, matrix[i][j][k]);
                }
            }
        }
        return flattenMatrix;
    }

    public static IntArray toRowMajor(int[][] matrix) {
        int dimX = matrix.length;
        int dimY = matrix[0].length;
        IntArray matrixRM = new IntArray(dimX * dimY);
        for (int i = 0; i < dimX; ++i) {
            for (int j = 0; j < dimY; ++j) {
                matrixRM.set(StorageFormats.toRowMajor(i, j, dimY), matrix[i][j]);
            }
        }
        return matrixRM;
    }

    public static ByteArray toRowMajor(byte[][] matrix) {
        int m = matrix[0].length;
        int n = matrix.length;
        ByteArray matrixRM = new ByteArray(m * n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                matrixRM.set(StorageFormats.toRowMajor(i, j, m), matrix[i][j]);
            }
        }
        return matrixRM;
    }
}

