/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.utils;

public class FloatingPointError {
    private final float averageUlp;
    private final float minUlp;
    private final float maxUlp;
    private final float stdDevUlp;
    private final int errors;

    public FloatingPointError(float average, float min, float max, float stdDev, int errors) {
        this.averageUlp = average;
        this.minUlp = min;
        this.maxUlp = max;
        this.stdDevUlp = stdDev;
        this.errors = errors;
    }

    public FloatingPointError(float average, float min, float max, float stdDev) {
        this(average, min, max, stdDev, -1);
    }

    public String toString() {
        return String.format("errors=%d, mean ulp=%f, std. dev =%f, min ulp=%f, max ulp=%f", this.errors, Float.valueOf(this.averageUlp), Float.valueOf(this.stdDevUlp), Float.valueOf(this.minUlp), Float.valueOf(this.maxUlp));
    }

    public float getErrors() {
        return this.errors;
    }

    public float getAverageUlp() {
        return this.averageUlp;
    }

    public float getMinUlp() {
        return this.minUlp;
    }

    public float getMaxUlp() {
        return this.maxUlp;
    }

    public float getStdDevUlp() {
        return this.stdDevUlp;
    }
}

