/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.utils;

import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.Double2;
import uk.ac.manchester.tornado.api.types.vectors.Double3;
import uk.ac.manchester.tornado.api.types.vectors.Double4;
import uk.ac.manchester.tornado.api.types.vectors.Double8;

public class DoubleOps {
    public static final double EPSILON = (double)1.0E-7f;
    public static final String FMT = "%.3f";
    public static final String FMT_2 = "{%.3f,%.3f}";
    public static final String FMT_3 = "{%.3f,%.3f,%.3f}";
    public static final String FMT_3_E = "{%.4e,%.4e,%.4e}";
    public static final String FMT_4 = "{%.3f,%.3f,%.3f,%.3f}";
    public static final String FMT_4_M = "%.3f,%.3f,%.3f,%.3f";
    public static final String FMT_4_EM = "%.3e,%.3e,%.3e,%.3e";
    public static final String FMT_6 = "{%.3f,%.3f,%.3f,%.3f,%.3f,%.3f}";
    public static final String FMT_8 = "{%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f}";
    public static final String FMT_16 = "{%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f}";
    public static final String FMT_6_E = "{%e,%e,%e,%e,%e,%e}";

    public static boolean compareBits(double a, double b) {
        long bi;
        long ai = Double.doubleToRawLongBits(a);
        long diff = ai ^ (bi = Double.doubleToRawLongBits(b));
        return diff == 0L;
    }

    public static boolean compareULP(double value, double expected, double ulps) {
        double tol = ulps * Math.ulp(expected);
        if (value == expected) {
            return true;
        }
        return Math.abs(value - expected) < tol;
    }

    public static double findMaxULP(Double2 value, Double2 expected) {
        return TornadoMath.findULPDistance(value.toArray(), expected.toArray());
    }

    public static double findMaxULP(Double3 value, Double3 expected) {
        return TornadoMath.findULPDistance(value.toArray(), expected.toArray());
    }

    public static double findMaxULP(Double4 value, Double4 expected) {
        return TornadoMath.findULPDistance(value.toArray(), expected.toArray());
    }

    public static double findMaxULP(Double8 value, Double8 expected) {
        return TornadoMath.findULPDistance(value.toArray(), expected.toArray());
    }

    public static double findMaxULP(double value, double expected) {
        double ulp = Math.ulp(expected);
        if (value == expected) {
            return 0.0;
        }
        double absValue = Math.abs(value - expected);
        return absValue / ulp;
    }

    public static boolean compare(double a, double b) {
        return Math.abs(a - b) <= (double)1.0E-7f;
    }

    public static boolean compare(double a, double b, double tol) {
        return Math.abs(a - b) <= tol;
    }

    public static double sq(double value) {
        return value * value;
    }

    public static void atomicAdd(double[] array, int index, double value) {
        int n = index;
        array[n] = array[n] + value;
    }
}

