/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.tensors;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.LongBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.api.types.tensors.DType;
import uk.ac.manchester.tornado.api.types.tensors.Shape;
import uk.ac.manchester.tornado.api.types.tensors.Tensor;

@SegmentElementSize(size=8)
public final class TensorInt64
extends Tensor {
    private static final int LONG_BYTES = 8;
    private final DType dType;
    private final Shape shape;
    private final LongArray tensorStorage;
    private int numberOfElements;

    public TensorInt64(Shape shape) {
        super(DType.INT64, shape);
        this.shape = shape;
        this.numberOfElements = shape.getSize();
        this.dType = DType.INT64;
        this.tensorStorage = new LongArray(this.numberOfElements);
    }

    public void init(long value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.tensorStorage.getSegmentWithHeader().setAtIndex(ValueLayout.JAVA_LONG, this.getBaseIndex() + (long)i, value);
        }
    }

    public void set(int index, long value) {
        this.tensorStorage.getSegmentWithHeader().setAtIndex(ValueLayout.JAVA_LONG, this.getBaseIndex() + (long)index, value);
    }

    private long getBaseIndex() {
        return (int)TornadoNativeArray.ARRAY_HEADER / 8;
    }

    public long get(int index) {
        return this.tensorStorage.getSegmentWithHeader().getAtIndex(ValueLayout.JAVA_LONG, this.getBaseIndex() + (long)index);
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.tensorStorage.getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.tensorStorage.getSegmentWithHeader();
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.tensorStorage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.tensorStorage.getNumBytesOfSegment();
    }

    @Override
    protected void clear() {
        this.init(0L);
    }

    @Override
    public int getElementSize() {
        return 8;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public String getDTypeAsString() {
        return this.dType.toString();
    }

    @Override
    public DType getDType() {
        return this.dType;
    }

    public LongBuffer getLongBuffer() {
        return this.getSegment().asByteBuffer().asLongBuffer();
    }

    public static void initialize(TensorInt64 tensor, long value) {
        for (int i = 0; i < tensor.getSize(); ++i) {
            tensor.set(i, value);
        }
    }

    public static TensorInt64 concat(TensorInt64 ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(TensorInt64::getSize).sum();
        TensorInt64 concatArray = new TensorInt64(new Shape(newSize));
        long currentPositionBytes = 0L;
        for (TensorInt64 array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }
}

