/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.tensors;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.IntBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.api.types.tensors.DType;
import uk.ac.manchester.tornado.api.types.tensors.Shape;
import uk.ac.manchester.tornado.api.types.tensors.Tensor;

@SegmentElementSize(size=4)
public final class TensorInt32
extends Tensor {
    private static final int INT_BYTES = 4;
    private final DType dType;
    private final Shape shape;
    private final IntArray tensorStorage;
    private int numberOfElements;

    public TensorInt32(Shape shape) {
        super(DType.INT32, shape);
        this.shape = shape;
        this.numberOfElements = shape.getSize();
        this.dType = DType.INT32;
        this.tensorStorage = new IntArray(this.numberOfElements);
    }

    public void init(int value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.tensorStorage.getSegmentWithHeader().setAtIndex(ValueLayout.JAVA_INT, this.getBaseIndex() + (long)i, value);
        }
    }

    public void set(int index, int value) {
        this.tensorStorage.getSegmentWithHeader().setAtIndex(ValueLayout.JAVA_INT, this.getBaseIndex() + (long)index, value);
    }

    private long getBaseIndex() {
        return (int)TornadoNativeArray.ARRAY_HEADER / 4;
    }

    public int get(int index) {
        return this.tensorStorage.getSegmentWithHeader().getAtIndex(ValueLayout.JAVA_INT, this.getBaseIndex() + (long)index);
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.tensorStorage.getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.tensorStorage.getSegmentWithHeader();
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.tensorStorage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.tensorStorage.getNumBytesOfSegment();
    }

    @Override
    protected void clear() {
        this.init(0);
    }

    @Override
    public int getElementSize() {
        return 4;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public String getDTypeAsString() {
        return this.dType.toString();
    }

    @Override
    public DType getDType() {
        return this.dType;
    }

    public IntBuffer getIntBuffer() {
        return this.getSegment().asByteBuffer().asIntBuffer();
    }

    public static void initialize(TensorInt32 tensor, int value) {
        for (int i = 0; i < tensor.getSize(); ++i) {
            tensor.set(i, value);
        }
    }

    public static TensorInt32 concat(TensorInt32 ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(TensorInt32::getSize).sum();
        TensorInt32 concatArray = new TensorInt32(new Shape(newSize));
        long currentPositionBytes = 0L;
        for (TensorInt32 array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }
}

