/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.images;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.images.TornadoImagesInterface;
import uk.ac.manchester.tornado.api.types.utils.FloatingPointError;
import uk.ac.manchester.tornado.api.types.vectors.Float3;

public final class ImageFloat3
implements TornadoImagesInterface<FloatBuffer> {
    public static final Class<ImageFloat3> TYPE = ImageFloat3.class;
    private static final int ELEMENT_SIZE = 3;
    private final FloatArray storage;
    private final int Y;
    private final int X;
    private final int numElements;

    public ImageFloat3(int width, int height, FloatArray array) {
        this.storage = array;
        this.X = width;
        this.Y = height;
        this.numElements = this.X * this.Y * 3;
    }

    public ImageFloat3(int width, int height) {
        this(width, height, new FloatArray(width * height * 3));
    }

    public ImageFloat3(float[][] matrix) {
        this(matrix.length / 3, matrix[0].length / 3);
    }

    public FloatArray getArray() {
        return this.storage;
    }

    private int toIndex(int x, int y) {
        return 3 * (x + y * this.X);
    }

    public Float3 get(int x) {
        return this.get(x, 0);
    }

    public void set(int x, Float3 value) {
        this.set(x, 0, value);
    }

    public Float3 get(int x, int y) {
        int offset = this.toIndex(x, y);
        return this.loadFromArray(this.storage, offset);
    }

    private Float3 loadFromArray(FloatArray array, int index) {
        Float3 result = new Float3();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        result.setZ(array.get(index + 2));
        return result;
    }

    public void set(int x, int y, Float3 value) {
        int offset = this.toIndex(x, y);
        this.storeToArray(value, this.storage, offset);
    }

    private void storeToArray(Float3 value, FloatArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
        array.set(index + 2, value.getZ());
    }

    public int X() {
        return this.X;
    }

    public int Y() {
        return this.Y;
    }

    public void fill(float value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public ImageFloat3 duplicate() {
        ImageFloat3 matrix = new ImageFloat3(this.X, this.Y);
        matrix.set(this);
        return matrix;
    }

    public void set(ImageFloat3 m) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, m.storage.get(i));
        }
    }

    public String toString(String fmt) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.Y; ++i) {
            for (int j = 0; j < this.X; ++j) {
                str.append(this.get(j, i).toString(fmt)).append("\n");
            }
        }
        return str.toString();
    }

    public String toString() {
        Object result = String.format("ImageFloat3 <%d x %d>", this.X, this.Y);
        if (this.X <= 8 && this.Y <= 8) {
            result = (String)result + "\n" + this.toString("{%.3f,%.3f,%.3f}");
        }
        return result;
    }

    public Float3 mean() {
        Float3 result = new Float3();
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                result = Float3.add(result, this.get(col, row));
            }
        }
        return Float3.div(result, this.X * this.Y);
    }

    public Float3 min() {
        Float3 result = new Float3(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                result = Float3.min(result, this.get(col, row));
            }
        }
        return result;
    }

    public Float3 max() {
        Float3 result = new Float3(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                result = Float3.max(result, this.get(col, row));
            }
        }
        return result;
    }

    public Float3 stdDev() {
        Float3 mean = this.mean();
        Float3 varience = new Float3();
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                Float3 v = Float3.sub(mean, this.get(col, row));
                v = Float3.mult(v, v);
                v = Float3.div(v, this.X);
                varience = Float3.add(v, varience);
            }
        }
        return Float3.sqrt(varience);
    }

    public String summarise() {
        return String.format("ImageFloat3<%dx%d>: min=%s, max=%s, mean=%s, sd=%s", this.X, this.Y, this.min(), this.max(), this.mean(), this.stdDev());
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    public FloatingPointError calculateULP(ImageFloat3 ref) {
        float maxULP = Float.MIN_VALUE;
        float minULP = Float.MAX_VALUE;
        float averageULP = 0.0f;
        if (ref.X != this.X && ref.Y != this.Y) {
            return new FloatingPointError(-1.0f, 0.0f, 0.0f, 0.0f);
        }
        int errors = 0;
        for (int j = 0; j < this.Y; ++j) {
            for (int i = 0; i < this.X; ++i) {
                Float3 v = this.get(i, j);
                Float3 r = ref.get(i, j);
                float ulpFactor = Float3.findULPDistance(v, r);
                averageULP += ulpFactor;
                minULP = Math.min(ulpFactor, minULP);
                maxULP = Math.max(ulpFactor, maxULP);
                if (!(ulpFactor > 5.0f)) continue;
                ++errors;
            }
        }
        return new FloatingPointError(averageULP /= (float)this.X * (float)this.Y, minULP, maxULP, -1.0f, errors);
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

