/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.ShortBuffer;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;

public final class VectorHalf
implements TornadoCollectionInterface<ShortBuffer> {
    private static final int ELEMENT_SIZE = 1;
    private final int numElements;
    private final HalfFloatArray storage;

    public VectorHalf(int numElements, HalfFloatArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorHalf(int numElements) {
        this(numElements, new HalfFloatArray(numElements));
    }

    public VectorHalf(HalfFloatArray storage) {
        this(storage.getSize() / 1, storage);
    }

    public static HalfFloat dot(VectorHalf a, VectorHalf b) {
        HalfFloat sum = new HalfFloat(0.0f);
        for (int i = 0; i < a.size(); ++i) {
            sum = HalfFloat.add(sum, HalfFloat.mult(a.get(i), b.get(i)));
        }
        return sum;
    }

    public HalfFloatArray getArray() {
        return this.storage;
    }

    public HalfFloat get(int index) {
        return this.storage.get(index);
    }

    public void set(int index, HalfFloat value) {
        this.storage.set(index, value);
    }

    public void set(VectorHalf values) {
        for (int i = 0; i < values.storage.getSize(); ++i) {
            this.storage.set(i, values.storage.get(i));
        }
    }

    public void set(HalfFloat[] values) {
        System.arraycopy(values, 0, this.storage, 0, values.length);
    }

    public void fill(HalfFloat value) {
        this.storage.init(value);
    }

    public VectorHalf subVector(int start, int length) {
        VectorHalf v = new VectorHalf(length);
        for (int i = 0; i < length; ++i) {
            v.storage.set(i, this.storage.get(i + start));
        }
        return v;
    }

    public VectorHalf duplicate() {
        HalfFloatArray cp = new HalfFloatArray(this.storage.getSize());
        for (int i = 0; i < cp.getSize(); ++i) {
            cp.set(i, this.storage.get(i));
        }
        return new VectorHalf(cp);
    }

    public boolean isEqual(VectorHalf vector) {
        return TornadoMath.isEqual(this.storage, vector.storage);
    }

    public String toString(String fmt) {
        StringBuilder sb = new StringBuilder("[");
        sb.append("[ ");
        for (int i = 0; i < this.numElements; ++i) {
            sb.append(String.format(fmt, Float.valueOf(this.get(i).getFloat32())) + " ");
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        Object str = String.format("VectorHalf <%d>", this.numElements);
        if (this.numElements < 32) {
            str = (String)str + this.toString("%.3f");
        }
        return str;
    }

    @Override
    public void loadFromBuffer(ShortBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ShortBuffer asBuffer() {
        return ShortBuffer.wrap(this.storage.toShortArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    public int getLength() {
        return this.numElements;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

